/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.TimeTrackingRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.TimeTrackingJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class TimeTrackingSystemField
extends AbstractOrderableField
implements HideableField,
RequirableField,
RestAwareField,
RestFieldOperations {
    private static final Logger log = Logger.getLogger(TimeTrackingSystemField.class);
    private static final String TIME_TRACKING_NAME_KEY = "issue.field.timetracking";
    public static final String TIMETRACKING_TARGETSUBFIELD = "timetracking_targetsubfield";
    public static final String TIMETRACKING_ORIGINALESTIMATE = "timetracking_originalestimate";
    public static final String TIMETRACKING_REMAININGESTIMATE = "timetracking_remainingestimate";
    private static final String ISCREATEISSUE = "isCreateIssue";
    private final IssueManager issueManager;
    private final JiraDurationUtils jiraDurationUtils;

    public TimeTrackingSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, IssueManager issueManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, JiraDurationUtils jiraDurationUtils) {
        super("timetracking", TIME_TRACKING_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, null);
        this.issueManager = issueManager;
        this.jiraDurationUtils = jiraDurationUtils;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        velocityParams.put(ISCREATEISSUE, Boolean.TRUE);
        this.getOurSpecificVelocityParams(issue, velocityParams, operationContext.getFieldValuesHolder());
        return this.renderTemplate("timetracking-edit.vm", velocityParams);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        this.getOurSpecificVelocityParams(issue, velocityParams, operationContext.getFieldValuesHolder());
        return this.renderTemplate("timetracking-edit.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull((String)"bulkEditBean", (Object)bulkEditBean);
        Assertions.notEmpty((String)"selectedIssues", (Collection)bulkEditBean.getSelectedIssues());
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            return this.getBulkMoveHtml(operationContext, action, bulkEditBean, displayParameters);
        }
        return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
    }

    private String getBulkMoveHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
        Issue issue = bulkEditBean.getFirstTargetIssueObject();
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        this.getOurSpecificVelocityParams(issue, velocityParams, operationContext.getFieldValuesHolder());
        return this.renderTemplate("timetracking-bulkmove.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.getOurSpecificVelocityParams(issue, velocityParams, null);
        this.populateFromIssue(velocityParams, issue);
        return this.getViewVelocityTemplate(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put(this.getId(), value);
        return this.getViewVelocityTemplate(velocityParams);
    }

    private String getViewVelocityTemplate(Map velocityParams) {
        return this.renderTemplate("timetracking-view.vm", velocityParams);
    }

    private void getOurSpecificVelocityParams(Issue issue, Map velocityParams, Map<String, Object> fieldValuesHolder) {
        boolean legacyBehaviorEnabled = this.isLegacyBehaviorEnabled();
        velocityParams.put("legacyBehaviour", legacyBehaviorEnabled);
        if (legacyBehaviorEnabled) {
            boolean hasWorkStarted = this.hasWorkStarted(issue);
            velocityParams.put("hasWorkStarted", hasWorkStarted);
            if (hasWorkStarted) {
                velocityParams.put("fieldName", "common.concepts.remaining.estimate");
            } else {
                velocityParams.put("fieldName", "common.concepts.original.estimate");
            }
        }
        velocityParams.put("isWorklogPresent", fieldValuesHolder != null && fieldValuesHolder.containsKey("worklog"));
    }

    public void createValue(Issue issue, Object value) {
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), new TimeTrackingValue.Builder().setInLegacyMode(this.isLegacyBehaviorEnabled()).build());
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), new TimeTrackingValue.Builder().setInLegacyMode(this.isLegacyBehaviorEnabled()).setEstimate(stringValue).build());
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    @Override
    public boolean hasParam(Map parameters) {
        if (parameters.get(this.getId()) != null) {
            return true;
        }
        if (parameters.get(TIMETRACKING_TARGETSUBFIELD) != null) {
            return true;
        }
        if (parameters.get(TIMETRACKING_ORIGINALESTIMATE) != null) {
            return true;
        }
        return parameters.get(TIMETRACKING_REMAININGESTIMATE) != null;
    }

    @Override
    public void populateFromParams(Map<String, Object> fieldValuesHolder, Map<String, String[]> inputParameters) {
        super.populateFromParams(fieldValuesHolder, inputParameters);
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> inputParameters) {
        TimeTrackingValue.Builder builder = new TimeTrackingValue.Builder();
        if (this.isLegacyBehaviorEnabled(inputParameters)) {
            builder.setInLegacyMode(true).setEstimate(inputParameters.get(this.getId()));
        } else {
            String[] targetField = inputParameters.get(TIMETRACKING_TARGETSUBFIELD);
            String targetSubField = targetField == null ? null : this.fromArray(targetField);
            builder.setTargetSubField(targetSubField);
            if (TIMETRACKING_ORIGINALESTIMATE.equals(targetSubField)) {
                builder.setOriginalEstimate(inputParameters.get(TIMETRACKING_ORIGINALESTIMATE));
            } else if (TIMETRACKING_REMAININGESTIMATE.equals(targetSubField)) {
                builder.setRemainingEstimate(inputParameters.get(TIMETRACKING_REMAININGESTIMATE));
            } else {
                builder.setOriginalEstimate(inputParameters.get(TIMETRACKING_ORIGINALESTIMATE)).setRemainingEstimate(inputParameters.get(TIMETRACKING_REMAININGESTIMATE));
            }
            builder.setInLegacyMode(false);
        }
        builder.setCreateIssue(inputParameters.get(ISCREATEISSUE));
        builder.setLogWorkActivated(inputParameters.get("worklog_activate"));
        return builder.build();
    }

    private String fromArray(String[] value) {
        return value != null && value.length > 0 ? value[0] : null;
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        TimeTrackingValue.Builder valueBuilder = new TimeTrackingValue.Builder();
        if (this.isLegacyBehaviorEnabled()) {
            valueBuilder.setInLegacyMode(true);
            Long estimate = this.hasWorkStarted(issue) ? issue.getEstimate() : issue.getOriginalEstimate();
            if (estimate != null) {
                valueBuilder.setEstimate(this.formatMillisIntoDisplayFormat(estimate));
            }
        } else {
            valueBuilder.setInLegacyMode(false).setOriginalEstimate(this.formatMillisIntoDisplayFormat(issue.getOriginalEstimate())).setRemainingEstimate(this.formatMillisIntoDisplayFormat(issue.getEstimate()));
        }
        fieldValuesHolder.put(this.getId(), valueBuilder.build());
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        TimeTrackingValue value = (TimeTrackingValue)operationContext.getFieldValuesHolder().get(this.getId());
        if (value != null) {
            boolean hasWorkStarted = this.hasWorkStarted(issue);
            TimeTrackingValue newValue = value.isInLegacyMode() ? this.validateParamsInLegacyMode(errorCollection, i18n, fieldScreenRenderLayoutItem.isRequired(), issue, value, value.isLogWorkActivated(), hasWorkStarted) : this.validateParamsInModernMode(errorCollection, i18n, fieldScreenRenderLayoutItem.isRequired(), issue, value, value.isLogWorkActivated());
            if (newValue != null) {
                operationContext.getFieldValuesHolder().put(this.getId(), newValue);
            }
        }
    }

    private TimeTrackingValue validateParamsInModernMode(ErrorCollection errorCollection, I18nHelper i18n, boolean fieldIsRequired, Issue issue, TimeTrackingValue value, boolean isLogWorkActivated) {
        if (!this.isTimeTrackingEnabled()) {
            errorCollection.addError(this.getId(), i18n.getText("createissue.error.timetracking.disabled"));
            return null;
        }
        String originalEstimate = value.getOriginalEstimateDisplayValue();
        String remainingEstimate = value.getRemainingEstimateDisplayValue();
        if (fieldIsRequired) {
            if (isLogWorkActivated && StringUtils.isBlank((String)originalEstimate)) {
                errorCollection.addError(TIMETRACKING_ORIGINALESTIMATE, i18n.getText("issue.field.required", i18n.getText("common.concepts.original.estimate")));
                return this.resetEstimateForValue(value, issue);
            }
            if (StringUtils.isBlank((String)originalEstimate) && StringUtils.isBlank((String)remainingEstimate)) {
                errorCollection.addError(TIMETRACKING_ORIGINALESTIMATE, i18n.getText("issue.field.required", i18n.getText("common.concepts.original.estimate")));
                errorCollection.addError(TIMETRACKING_REMAININGESTIMATE, i18n.getText("issue.field.required", i18n.getText("common.concepts.remaining.estimate")));
                return null;
            }
        }
        boolean originalEstimateValid = false;
        boolean remainingEstimateValid = false;
        if (this.isDurationInvalid(originalEstimate)) {
            errorCollection.addError(TIMETRACKING_ORIGINALESTIMATE, i18n.getText("createissue.error.original.estimate.invalid"));
        } else {
            originalEstimateValid = true;
        }
        if (isLogWorkActivated) {
            remainingEstimateValid = true;
            value = this.resetEstimateForValue(value, issue);
            remainingEstimate = value.getRemainingEstimateDisplayValue();
        } else if (this.isDurationInvalid(remainingEstimate)) {
            errorCollection.addError(TIMETRACKING_REMAININGESTIMATE, i18n.getText("createissue.error.remaining.estimate.invalid"));
        } else {
            remainingEstimateValid = true;
        }
        if (!originalEstimateValid || !remainingEstimateValid) {
            return value;
        }
        if (StringUtils.isNotBlank((String)originalEstimate) && StringUtils.isBlank((String)remainingEstimate)) {
            TimeTrackingValue.Builder b = new TimeTrackingValue.Builder(value);
            b.setRemainingEstimate(originalEstimate);
            return b.build();
        }
        if (StringUtils.isBlank((String)originalEstimate) && StringUtils.isNotBlank((String)remainingEstimate)) {
            TimeTrackingValue.Builder b = new TimeTrackingValue.Builder(value);
            b.setOriginalEstimate(remainingEstimate);
            return b.build();
        }
        return value;
    }

    boolean isDurationInvalid(String duration) {
        if (StringUtils.isNotBlank((String)duration)) {
            try {
                this.jiraDurationUtils.parseDuration(duration, this.authenticationContext.getLocale());
            }
            catch (InvalidDurationException e) {
                return true;
            }
        }
        return false;
    }

    private TimeTrackingValue validateParamsInLegacyMode(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, boolean fieldIsRequired, Issue issue, TimeTrackingValue value, boolean isLogWorkActivated, boolean hasWorkStarted) {
        if (isLogWorkActivated && hasWorkStarted) {
            return this.resetEstimateForValue(value, issue);
        }
        String estimate = value.getEstimateDisplayValue();
        if (StringUtils.isNotBlank((String)estimate)) {
            if (this.isTimeTrackingEnabled()) {
                if (this.isDurationInvalid(estimate)) {
                    String key = hasWorkStarted ? "createissue.error.remaining.estimate.invalid" : "createissue.error.original.estimate.invalid";
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText(key));
                    return null;
                }
            } else {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.timetracking.disabled"));
                return null;
            }
        }
        if (fieldIsRequired && StringUtils.isBlank((String)estimate)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
            return null;
        }
        return null;
    }

    private TimeTrackingValue resetEstimateForValue(TimeTrackingValue oldValue, Issue issue) {
        TimeTrackingValue.Builder builder = new TimeTrackingValue.Builder(oldValue);
        Long currentEstimate = issue.getEstimate();
        String currentEstimateString = currentEstimate != null ? this.formatMillisIntoDisplayFormat(currentEstimate) : null;
        if (oldValue.isInLegacyMode()) {
            builder.setEstimate(currentEstimateString);
        } else {
            builder.setRemainingEstimate(currentEstimateString);
        }
        return builder.build();
    }

    public Object getValueFromParams(Map fieldValueHolder) {
        TimeTrackingValue value = (TimeTrackingValue)fieldValueHolder.get(this.getId());
        if (value != null) {
            if (value.isInLegacyMode()) {
                return this.convertToIssueFormInLegacyMode(value);
            }
            return this.convertToIssueFormInModernMode(value);
        }
        return null;
    }

    private Object convertToIssueFormInModernMode(TimeTrackingValue value) {
        TimeTrackingValue.Builder builder = new TimeTrackingValue.Builder();
        String oeDisplayValue = value.getOriginalEstimateDisplayValue();
        String reDisplayValue = value.getRemainingEstimateDisplayValue();
        String targetedSubField = value.getTargetSubField();
        builder.setTargetSubField(targetedSubField);
        if (TIMETRACKING_ORIGINALESTIMATE.equals(targetedSubField)) {
            if (StringUtils.isNotBlank((String)oeDisplayValue)) {
                builder.setOriginalEstimate(this.convertDurationIntoSeconds(oeDisplayValue));
            }
        } else if (TIMETRACKING_REMAININGESTIMATE.equals(targetedSubField)) {
            if (StringUtils.isNotBlank((String)reDisplayValue)) {
                builder.setRemainingEstimate(this.convertDurationIntoSeconds(reDisplayValue));
            }
        } else {
            if (StringUtils.isNotBlank((String)oeDisplayValue)) {
                builder.setOriginalEstimate(this.convertDurationIntoSeconds(oeDisplayValue));
            }
            if (StringUtils.isNotBlank((String)reDisplayValue)) {
                builder.setRemainingEstimate(this.convertDurationIntoSeconds(reDisplayValue));
            }
        }
        return builder.build();
    }

    private Object convertToIssueFormInLegacyMode(TimeTrackingValue value) {
        TimeTrackingValue.Builder builder = new TimeTrackingValue.Builder(value);
        String estimate = value.getEstimateDisplayValue();
        if (StringUtils.isNotBlank((String)estimate)) {
            builder.setEstimate(this.convertDurationIntoSeconds(estimate));
        }
        return builder.build();
    }

    private Long convertDurationIntoSeconds(String estimate) {
        try {
            return this.jiraDurationUtils.parseDuration(estimate, this.authenticationContext.getLocale());
        }
        catch (InvalidDurationException e) {
            log.error((Object)"Error occurred while converting time estimates.");
            throw new IllegalArgumentException("Error occurred while converting time estimates:" + e.getMessage());
        }
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        TimeTrackingValue newValue = (TimeTrackingValue)this.getValueFromParams(fieldValueHolder);
        if (newValue == null) {
            return;
        }
        if (newValue.isInLegacyMode()) {
            Long estimate = newValue.getEstimate();
            if (this.hasWorkStarted((Issue)issue)) {
                issue.setEstimate(estimate);
            } else {
                issue.setOriginalEstimate(estimate);
                issue.setEstimate(estimate);
            }
        } else {
            TimeTrackingValue oldValue = new TimeTrackingValue.Builder().setInLegacyMode(false).setTargetSubField(newValue.getTargetSubField()).setOriginalEstimate(issue.getOriginalEstimate()).setRemainingEstimate(issue.getEstimate()).build();
            String targetSubField = newValue.getTargetSubField();
            if (TIMETRACKING_ORIGINALESTIMATE.equals(targetSubField)) {
                issue.setOriginalEstimate(newValue.getOriginalEstimate());
            } else if (TIMETRACKING_REMAININGESTIMATE.equals(targetSubField)) {
                issue.setEstimate(newValue.getRemainingEstimate());
            } else {
                issue.setOriginalEstimate(newValue.getOriginalEstimate());
                issue.setEstimate(newValue.getRemainingEstimate());
            }
            issue.setExternalFieldValue(this.getId(), (Object)oldValue, (Object)newValue);
        }
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object newValue = modifiedValue.getNewValue();
        if (!(newValue instanceof TimeTrackingValue)) {
            this.updateChangeHistoryInLegacyMode(issue, modifiedValue, issueChangeHolder);
        } else {
            this.updateChangeHistoryInModernMode(modifiedValue, issueChangeHolder);
        }
    }

    private void updateChangeHistoryInModernMode(ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        TimeTrackingValue oldValue = (TimeTrackingValue)modifiedValue.getOldValue();
        TimeTrackingValue newValue = (TimeTrackingValue)modifiedValue.getNewValue();
        String targetSubField = newValue.getTargetSubField();
        if (TIMETRACKING_ORIGINALESTIMATE.equals(targetSubField)) {
            this.updateChangeHistoryForFieldInModernMode(issueChangeHolder, "timeoriginalestimate", oldValue.getOriginalEstimate(), newValue.getOriginalEstimate());
        } else if (TIMETRACKING_REMAININGESTIMATE.equals(newValue.getTargetSubField())) {
            this.updateChangeHistoryForFieldInModernMode(issueChangeHolder, "timeestimate", oldValue.getRemainingEstimate(), newValue.getRemainingEstimate());
        } else {
            this.updateChangeHistoryForFieldInModernMode(issueChangeHolder, "timeoriginalestimate", oldValue.getOriginalEstimate(), newValue.getOriginalEstimate());
            this.updateChangeHistoryForFieldInModernMode(issueChangeHolder, "timeestimate", oldValue.getRemainingEstimate(), newValue.getRemainingEstimate());
        }
    }

    private void updateChangeHistoryForFieldInModernMode(IssueChangeHolder issueChangeHolder, String fieldName, Long oldValue, Long newValue) {
        String oldChangeLogValue = this.getChangelogValue(oldValue);
        String newChangeLogValue = this.getChangelogValue(newValue);
        if (oldValue == null) {
            if (newValue != null) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", fieldName, oldChangeLogValue, oldChangeLogValue, newChangeLogValue, newChangeLogValue));
            }
        } else if (!this.valuesEqual(newValue, oldValue)) {
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", fieldName, oldChangeLogValue, oldChangeLogValue, newChangeLogValue, newChangeLogValue));
        }
    }

    private void updateChangeHistoryInLegacyMode(Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        if (currentValue == null) {
            if (value != null) {
                if (this.hasWorkStarted(issue)) {
                    issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeestimate", null, null, this.getChangelogValue(value), this.getChangelogValue(value)));
                } else {
                    issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeoriginalestimate", null, null, this.getChangelogValue(value), this.getChangelogValue(value)));
                    issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeestimate", null, null, this.getChangelogValue(value), this.getChangelogValue(value)));
                }
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            if (this.hasWorkStarted(issue)) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeestimate", this.getChangelogValue(currentValue), this.getChangelogValue(currentValue), this.getChangelogValue(value), this.getChangelogValue(value)));
            } else {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeoriginalestimate", this.getChangelogValue(currentValue), this.getChangelogValue(currentValue), this.getChangelogValue(value), this.getChangelogValue(value)));
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "timeestimate", this.getChangelogValue(currentValue), this.getChangelogValue(currentValue), this.getChangelogValue(value), this.getChangelogValue(value)));
            }
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        Collection issues = originalIssues;
        for (Issue originalIssue : issues) {
            if (originalIssue.getOriginalEstimate() != null && originalIssue.getEstimate() != null || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setEstimate(null);
        issue.setOriginalEstimate(null);
    }

    public boolean isShown(Issue issue) {
        return this.isTimeTrackingEnabled();
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getOriginalEstimate() != null || issue.getEstimate() != null;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    public boolean hasWorkStarted(Issue issue) {
        if (issue.getGenericValue() == null) {
            return false;
        }
        try {
            return !this.issueManager.getEntitiesByIssueObject("IssueWorklog", issue).isEmpty();
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isTimeTrackingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.timetracking");
    }

    private boolean isLegacyBehaviorEnabled(Map inputParameters) {
        if (!this.isLegacyBehaviorEnabled()) {
            return inputParameters.containsKey(this.getId()) && !inputParameters.containsKey(TIMETRACKING_ORIGINALESTIMATE) && !inputParameters.containsKey(TIMETRACKING_REMAININGESTIMATE);
        }
        return true;
    }

    private boolean isLegacyBehaviorEnabled() {
        return this.getApplicationProperties().getOption("jira.timetracking.estimates.legacy.behaviour");
    }

    private String getChangelogValue(Object value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private String formatMillisIntoDisplayFormat(Long estimate) {
        if (estimate == null) {
            return null;
        }
        return this.jiraDurationUtils.getShortFormattedDuration(estimate, new Locale("en_UK"));
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"timetracking", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        JiraDurationUtils jiraDurationUtils = (JiraDurationUtils)ComponentAccessor.getComponent(JiraDurationUtils.class);
        String originalEstimate = issue.getOriginalEstimate() == null ? null : jiraDurationUtils.getShortFormattedDuration(issue.getOriginalEstimate());
        String estimate = issue.getEstimate() == null ? null : jiraDurationUtils.getShortFormattedDuration(issue.getEstimate());
        String timeSpent = issue.getTimeSpent() == null ? null : jiraDurationUtils.getShortFormattedDuration(issue.getTimeSpent());
        TimeTrackingJsonBean timeTrackingJsonBean = TimeTrackingJsonBean.shortBean((String)originalEstimate, (String)estimate, (String)timeSpent, (Long)issue.getOriginalEstimate(), (Long)issue.getEstimate(), (Long)issue.getTimeSpent());
        if (renderedVersionRequested) {
            String renderedOriginalEstimate = issue.getOriginalEstimate() == null ? null : jiraDurationUtils.getFormattedDuration(issue.getOriginalEstimate(), this.authenticationContext.getLocale());
            String renderedEstimate = issue.getEstimate() == null ? null : jiraDurationUtils.getFormattedDuration(issue.getEstimate(), this.authenticationContext.getLocale());
            String renderedTimeSpent = issue.getTimeSpent() == null ? null : jiraDurationUtils.getFormattedDuration(issue.getTimeSpent(), this.authenticationContext.getLocale());
            TimeTrackingJsonBean renderedTimeTrackingJsonBean = TimeTrackingJsonBean.shortBean((String)renderedOriginalEstimate, (String)renderedEstimate, (String)renderedTimeSpent, (Long)issue.getOriginalEstimate(), (Long)issue.getEstimate(), (Long)issue.getTimeSpent());
            return new FieldJsonRepresentation(new JsonData((Object)timeTrackingJsonBean), new JsonData((Object)renderedTimeTrackingJsonBean));
        }
        return new FieldJsonRepresentation(new JsonData((Object)timeTrackingJsonBean));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new TimeTrackingRestFieldOperationsHandler(this, this.getApplicationProperties(), this.jiraDurationUtils, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    public static interface TimeTrackingValue {
        public boolean isInLegacyMode();

        public boolean isCreateIssue();

        public boolean isLogWorkActivated();

        public String getTargetSubField();

        public Long getOriginalEstimate();

        public Long getRemainingEstimate();

        public Long getEstimate();

        public String getEstimateDisplayValue();

        public String getOriginalEstimateDisplayValue();

        public String getRemainingEstimateDisplayValue();

        public static class Builder {
            Long estimate = null;
            Long originalEstimate = null;
            Long remainingEstimate = null;
            String estimateDisplayValue = null;
            String originalEstimateDisplayValue = null;
            String remainingEstimateDisplayValue = null;
            String targetSubField = null;
            boolean inLegacyMode;
            boolean isCreateIssue;
            boolean isLogWorkActivated;

            Builder() {
            }

            Builder(TimeTrackingValue value) {
                this.estimate = value.getEstimate();
                this.originalEstimate = value.getOriginalEstimate();
                this.remainingEstimate = value.getRemainingEstimate();
                this.estimateDisplayValue = value.getEstimateDisplayValue();
                this.originalEstimateDisplayValue = value.getOriginalEstimateDisplayValue();
                this.remainingEstimateDisplayValue = value.getRemainingEstimateDisplayValue();
                this.targetSubField = value.getTargetSubField();
                this.inLegacyMode = value.isInLegacyMode();
                this.isCreateIssue = value.isCreateIssue();
                this.isLogWorkActivated = value.isLogWorkActivated();
            }

            Builder setCreateIssue(String[] createIssue) {
                String s = this.fromArray(createIssue);
                this.isCreateIssue = StringUtils.isNotBlank((String)s) ? Boolean.valueOf(s) : false;
                return this;
            }

            Builder setLogWorkActivated(String[] logWorkActivated) {
                String s = this.fromArray(logWorkActivated);
                this.isLogWorkActivated = StringUtils.isNotBlank((String)s) ? Boolean.valueOf(s) : false;
                return this;
            }

            Builder setInLegacyMode(boolean flag) {
                this.inLegacyMode = flag;
                return this;
            }

            Builder setTargetSubField(String value) {
                this.targetSubField = value;
                return this;
            }

            Builder setEstimate(Long value) {
                this.estimate = value;
                return this;
            }

            Builder setEstimate(String value) {
                this.estimateDisplayValue = value;
                return this;
            }

            Builder setEstimate(String[] value) {
                this.estimateDisplayValue = this.fromArray(value);
                return this;
            }

            Builder setOriginalEstimate(Long value) {
                this.originalEstimate = value;
                return this;
            }

            Builder setOriginalEstimate(String value) {
                this.originalEstimateDisplayValue = value;
                return this;
            }

            Builder setOriginalEstimate(String[] value) {
                this.originalEstimateDisplayValue = this.fromArray(value);
                return this;
            }

            Builder setRemainingEstimate(Long value) {
                this.remainingEstimate = value;
                return this;
            }

            Builder setRemainingEstimate(String value) {
                this.remainingEstimateDisplayValue = value;
                return this;
            }

            Builder setRemainingEstimate(String[] value) {
                this.remainingEstimateDisplayValue = this.fromArray(value);
                return this;
            }

            private String fromArray(String[] value) {
                return value != null && value.length > 0 ? value[0] : null;
            }

            TimeTrackingValue build() {
                final boolean inLegacyMode = this.inLegacyMode;
                final boolean isCreateIssue = this.isCreateIssue;
                final boolean isLogWorkActivated = this.isLogWorkActivated;
                final Long estimate = this.estimate;
                final Long originalEstimate = this.originalEstimate;
                final Long remainingEstimate = this.remainingEstimate;
                final String estimateDisplayValue = this.estimateDisplayValue;
                final String originalEstimateDisplayValue = this.originalEstimateDisplayValue;
                final String remainingEstimateDisplayValue = this.remainingEstimateDisplayValue;
                final String targetSubField = this.targetSubField;
                return new TimeTrackingValue(){

                    @Override
                    public boolean isInLegacyMode() {
                        return inLegacyMode;
                    }

                    @Override
                    public boolean isCreateIssue() {
                        return isCreateIssue;
                    }

                    @Override
                    public boolean isLogWorkActivated() {
                        return isLogWorkActivated;
                    }

                    @Override
                    public Long getOriginalEstimate() {
                        return originalEstimate;
                    }

                    @Override
                    public Long getRemainingEstimate() {
                        return remainingEstimate;
                    }

                    @Override
                    public Long getEstimate() {
                        return estimate;
                    }

                    @Override
                    public String getEstimateDisplayValue() {
                        return estimateDisplayValue;
                    }

                    @Override
                    public String getOriginalEstimateDisplayValue() {
                        return originalEstimateDisplayValue;
                    }

                    @Override
                    public String getRemainingEstimateDisplayValue() {
                        return remainingEstimateDisplayValue;
                    }

                    @Override
                    public String getTargetSubField() {
                        return targetSubField;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (!(obj instanceof TimeTrackingValue)) {
                            return false;
                        }
                        TimeTrackingValue rhs = (TimeTrackingValue)obj;
                        return new EqualsBuilder().append(inLegacyMode, rhs.isInLegacyMode()).append(isCreateIssue, rhs.isCreateIssue()).append(isLogWorkActivated, rhs.isLogWorkActivated()).append((Object)originalEstimate, (Object)rhs.getOriginalEstimate()).append((Object)remainingEstimate, (Object)rhs.getRemainingEstimate()).append((Object)estimate, (Object)rhs.getEstimate()).append((Object)estimateDisplayValue, (Object)rhs.getEstimateDisplayValue()).append((Object)originalEstimateDisplayValue, (Object)rhs.getOriginalEstimateDisplayValue()).append((Object)remainingEstimateDisplayValue, (Object)rhs.getRemainingEstimateDisplayValue()).append((Object)targetSubField, (Object)rhs.getTargetSubField()).isEquals();
                    }

                    public int hashCode() {
                        return new HashCodeBuilder(17, 31).append(inLegacyMode).append(isCreateIssue).append(isLogWorkActivated).append((Object)originalEstimate).append((Object)remainingEstimate).append((Object)estimate).append((Object)estimateDisplayValue).append((Object)originalEstimateDisplayValue).append((Object)remainingEstimateDisplayValue).append((Object)targetSubField).toHashCode();
                    }

                    public String toString() {
                        return new ToStringBuilder((Object)this).append("legacy", inLegacyMode).append("createIssue", isCreateIssue).append("logWorkActivated", isLogWorkActivated).append("target", (Object)targetSubField).append("estimate", (Object)estimate).append("estimateDV", (Object)estimateDisplayValue).append("originalEstimate", (Object)originalEstimate).append("originalEstimateDV", (Object)originalEstimateDisplayValue).append("remainingEstimate", (Object)remainingEstimate).append("remainingEstimateDV", (Object)remainingEstimateDisplayValue).toString();
                    }
                };
            }
        }
    }
}

