/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractTextSystemField;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.SummaryField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.SummaryRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.SummarySearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparator;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public class SummarySystemField
extends AbstractTextSystemField
implements NavigableField,
MandatoryField,
SummaryField,
RestFieldOperations {
    private static final String SUMMARY_NAME_KEY = "issue.field.summary";
    private static final LuceneFieldSorter SORTER = new TextFieldSorter("sort_summary");

    public SummarySystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, SummarySearchHandlerFactory searchHandlerFactory) {
        super("summary", SUMMARY_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, rendererManager, permissionManager, searchHandlerFactory);
    }

    @Override
    protected String getEditTemplateName() {
        return "summary-edit.vm";
    }

    @Override
    protected String getColumnViewTemplateName() {
        return "summary-columnview.vm";
    }

    @Override
    protected void populateVelocityParams(Map fieldValuesHolder, Map params) {
        super.populateVelocityParams(fieldValuesHolder, params);
    }

    @Override
    protected void populateVelocityParams(FieldLayoutItem fieldLayoutItem, Issue issue, Map params) {
        super.populateVelocityParams(fieldLayoutItem, issue, params);
        if (issue.isSubTask()) {
            params.put("subTask", Boolean.TRUE);
            Issue parentIssue = issue.getParentObject();
            params.put("parentIssueKey", parentIssue.getKey());
            params.put("subTaskParentIssueLinkDisabled", Boolean.TRUE);
            if (this.getPermissionManager().hasPermission(10, parentIssue, this.getAuthenticationContext().getUser())) {
                params.put("parentIssueSummary", parentIssue.getSummary());
                params.put("subTaskParentIssueLinkDisabled", Boolean.FALSE);
            }
        }
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        return issue.getSummary();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        issue.setSummary((String)this.getValueFromParams(fieldValueHolder));
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setSummary(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    @Override
    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), issue.getSummary());
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String summary = (String)this.getValueFromParams(fieldValuesHolder);
        if (summary == null) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.specify.a.summary"));
            return;
        }
        if (!TextUtils.stringSet((String)(summary = summary.trim()))) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.specify.a.summary"));
        }
        if (summary.contains("\n") || summary.contains("\r")) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidsummary.newlines"));
        }
        if ((long)summary.length() > MAX_LEN) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.summary.less.than", MAX_LEN.toString()));
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.summary";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return SORTER;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.singletonList(new SortField("sort_summary", (FieldComparatorSource)new StringSortComparator(), sortOrder));
    }

    @Override
    public boolean isRenderable() {
        return false;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new SummaryRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

