/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;

public abstract class AbstractUserFieldImpl
extends AbstractOrderableNavigableFieldImpl
implements UserField {
    private final UserHistoryManager userHistoryManager;

    protected AbstractUserFieldImpl(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SearchHandlerFactory searchHandlerFactory, UserHistoryManager userHistoryManager) {
        super(id, name, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.userHistoryManager = userHistoryManager;
    }

    protected void addToUsedUserHistoryIfValueChanged(MutableIssue issue) {
        ModifiedValue modifiedValue = (ModifiedValue)issue.getModifiedFields().get(this.getId());
        if (modifiedValue == null) {
            return;
        }
        User newUser = (User)modifiedValue.getNewValue();
        User oldUser = (User)modifiedValue.getOldValue();
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (newUser != null && !UserComparator.equal((User)oldUser, (User)newUser) && !UserComparator.equal((User)newUser, (User)loggedInUser)) {
            this.userHistoryManager.addUserToHistory(UserHistoryItem.USED_USER, loggedInUser, newUser);
        }
    }
}

