/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class GroupPickerStatisticsMapper
implements StatisticsMapper<Group>,
SearchRequestAppender.Factory<Group> {
    private final CustomField customField;
    private final ClauseNames clauseNames;
    private JiraAuthenticationContext authenticationContext;
    private CustomFieldInputHelper customFieldInputHelper;
    private GroupManager groupManager;

    public GroupPickerStatisticsMapper(CustomField customField, GroupManager groupManager, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.groupManager = groupManager;
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        this.customFieldInputHelper = (CustomFieldInputHelper)Assertions.notNull((String)"customFieldInputHelper", (Object)customFieldInputHelper);
        this.customField = (CustomField)Assertions.notNull((String)"customField", (Object)customField);
        this.clauseNames = customField.getClauseNames();
    }

    public String getDocumentConstant() {
        return this.customField.getId();
    }

    public Group getValueFromLuceneField(String documentValue) {
        if (StringUtils.isBlank((String)documentValue)) {
            return null;
        }
        return this.groupManager.getGroup(documentValue);
    }

    public Comparator<Group> getComparator() {
        return new GroupNameComparator();
    }

    protected String getSearchValue(Object value) {
        Group group = (Group)value;
        return group.getName();
    }

    public boolean isValidValue(Group value) {
        return true;
    }

    public boolean isFieldAlwaysPartOfAnIssue() {
        return false;
    }

    @Deprecated
    public SearchRequest getSearchUrlSuffix(Group value, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause((Object)value, searchRequest);
    }

    public SearchRequestAppender<Group> getSearchRequestAppender() {
        return new GroupSearchRequestAppender(this.customFieldInputHelper.getUniqueClauseName(this.authenticationContext.getLoggedInUser(), this.clauseNames.getPrimaryName(), this.customField.getName()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPickerStatisticsMapper that = (GroupPickerStatisticsMapper)o;
        if (!this.clauseNames.equals((Object)that.clauseNames)) {
            return false;
        }
        return this.customField.getId().equals(that.customField.getId());
    }

    public int hashCode() {
        int result = this.customField.getId().hashCode();
        result = 31 * result + this.clauseNames.hashCode();
        return result;
    }

    static class GroupSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<Group>,
    SearchRequestAppender<Group> {
        private final String clauseName;

        GroupSearchRequestAppender(String clauseName) {
            this.clauseName = (String)Assertions.notNull((Object)clauseName);
        }

        public void appendNonNullItem(Group value, JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addStringCondition(this.clauseName, Operator.EQUALS, value.getName());
        }

        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        public SearchRequest appendInclusiveSingleValueClause(Group value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause((Object)value, (SearchRequest)searchRequest, (SearchRequestAddendumBuilder.AddendumCallback)this);
        }

        public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends Group> values, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses(values, (SearchRequest)searchRequest, (SearchRequestAddendumBuilder.AddendumCallback)this);
        }
    }
}

