/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentAdapterImpl;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DefaultAttachmentStore
implements AttachmentStore {
    private static final Logger log = Logger.getLogger(DefaultAttachmentStore.class);
    private static final String THUMBNAIL_DESIGNATION = "_thumb_";
    private static final String TMP_ATTACHMENTS = "tmp_attachments";
    protected final ProjectManager projectManager;
    private final AttachmentPathManager attachmentPathManager;

    public DefaultAttachmentStore(ProjectManager projectManager, AttachmentPathManager attachmentPathManager) {
        this.projectManager = projectManager;
        this.attachmentPathManager = attachmentPathManager;
    }

    public File getThumbnailDirectory(Issue issue) {
        File thumbDir = new File(this.getAttachmentDirectory(issue), "thumbs");
        if (!thumbDir.exists() && !thumbDir.mkdirs()) {
            log.warn((Object)("Unable to make thumbnail directory " + thumbDir.getAbsolutePath()));
        }
        return thumbDir;
    }

    public File getAttachmentDirectory(Issue issue) {
        return this.getAttachmentDirectory(issue, true);
    }

    public File getAttachmentDirectory(Issue issue, boolean createDirectory) {
        Project project = issue.getProjectObject();
        File directory = this.getAttachmentDirectory(this.getAttachmentDirName(), project.getKey(), issue.getKey());
        if (createDirectory) {
            directory.mkdirs();
        }
        return directory;
    }

    public File getTemporaryAttachmentDirectory() {
        File cachesDirectory = ((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getCachesDirectory();
        File tempDirectory = new File(cachesDirectory, TMP_ATTACHMENTS);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        return tempDirectory;
    }

    public File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            File projectDirectory = new File(attachmentDirectory, projectKey);
            return new File(projectDirectory, issueKey);
        }
        String originalProjectKey = project.getOriginalKey();
        File projectDirectory = new File(attachmentDirectory, originalProjectKey);
        return new File(projectDirectory, DefaultAttachmentStore.computeIssueKeyForOriginalProjectKey(originalProjectKey, issueKey));
    }

    public static String computeIssueKeyForOriginalProjectKey(String originalProjectKey, String issueKey) {
        long issueNumber = IssueKey.from((String)issueKey).getIssueNumber();
        return IssueKey.format((String)originalProjectKey, (long)issueNumber);
    }

    public File getAttachmentFile(Issue issue, Attachment attachment) throws DataAccessException {
        File attachmentDir = this.getAttachmentDirectory(issue);
        return this.getAttachmentFile((AttachmentStore.AttachmentAdapter)AttachmentUtils.AttachmentAdapter.fromAttachment((Attachment)attachment), attachmentDir);
    }

    public File getAttachmentFile(Attachment attachment) throws DataAccessException {
        return this.getAttachmentFile(attachment.getIssueObject(), attachment);
    }

    public File getAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        File legacyFile = DefaultAttachmentStore.getLegacyAttachmentFile(attachment, attachmentDir);
        File defaultFile = DefaultAttachmentStore.getDefaultAttachmentFile(attachment, attachmentDir);
        if (defaultFile.exists()) {
            return defaultFile;
        }
        if (legacyFile.exists()) {
            return legacyFile;
        }
        File legacyAttachmentById = DefaultAttachmentStore.findLegacyAttachmentById(attachment, attachmentDir);
        if (legacyAttachmentById == null) {
            return defaultFile;
        }
        return legacyAttachmentById;
    }

    public File getThumbnailFile(Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getThumbnailDirectory(attachment.getIssueObject());
        return DefaultAttachmentStore.getThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }

    public File getThumbnailFile(Issue issue, Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getThumbnailDirectory(issue);
        return DefaultAttachmentStore.getThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }

    public File getLegacyThumbnailFile(Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment((Attachment)attachment);
        File thumbDir = this.getThumbnailDirectory(attachment.getIssueObject());
        return DefaultAttachmentStore.getLegacyThumbnailFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, thumbDir);
    }

    public void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        try {
            File directory = this.getAttachmentDirectory(issue);
            if (!directory.canWrite()) {
                throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.writeerror", directory.getAbsolutePath()));
            }
            this.checkValidTemporaryAttachmentDirectory();
        }
        catch (Exception e) {
            throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.exception", e.toString()), (Throwable)e);
        }
    }

    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        File tempDirectory = this.getTemporaryAttachmentDirectory();
        if (!tempDirectory.canWrite()) {
            throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.temp.writeerror", tempDirectory.getAbsolutePath()));
        }
    }

    private String getAttachmentDirName() {
        return this.attachmentPathManager.getAttachmentPath();
    }

    private static File findLegacyAttachmentById(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        final Pattern allFilesPattern = Pattern.compile("^" + attachment.getId() + "_.+");
        File[] list = attachmentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = allFilesPattern.matcher(name);
                return m.matches();
            }
        });
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Pattern thumbnailExcludingPattern = Pattern.compile("^" + attachment.getId() + "_(?!thumb_).+");
            File firstFile = null;
            int matchCount = 0;
            for (File file : list) {
                if (!thumbnailExcludingPattern.matcher(file.getName()).matches()) continue;
                ++matchCount;
                if (firstFile != null) continue;
                firstFile = file;
            }
            if (matchCount == 1) {
                return firstFile;
            }
            log.warn((Object)("More than one file found for attachment id " + attachment.getId() + " in " + attachmentDir + ". The first entry will be returned."));
        }
        return list[0];
    }

    private static File getThumbnailFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, THUMBNAIL_DESIGNATION + attachment.getId() + ".png");
    }

    private static File getLegacyThumbnailFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId() + THUMBNAIL_DESIGNATION + attachment.getFilename());
    }

    private static File getDefaultAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId().toString());
    }

    private static File getLegacyAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        return new File(attachmentDir, attachment.getId() + "_" + attachment.getFilename());
    }
}

