/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.ClusteredIndexUtils;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class DefaultIndexCopyService
implements IndexCopyService {
    private static final Logger log = Logger.getLogger(DefaultIndexCopyService.class);
    private static final String COPYING = "The index is being copied from another node.  Users will not be able to connect until the copy is finished.";
    private final LazyReference<ClusterManager> clusterManagerRef = new LazyReference<ClusterManager>(){

        protected ClusterManager create() throws Exception {
            return (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        }
    };
    private final String sharedIndexPath;
    private final String localIndexPath;
    private final ClusteredIndexUtils clusteredIndexUtils;
    private final MessageHandler messageHandler;
    private final JohnsonEventContainer eventContainer;

    public DefaultIndexCopyService(IndexPathManager indexPathManager, JiraHome jiraHome, ClusteredIndexUtils clusteredIndexUtils, MessageHandler messageHandler) {
        this(indexPathManager, jiraHome, clusteredIndexUtils, messageHandler, ServletContextProvider.getServletContext());
    }

    @VisibleForTesting
    DefaultIndexCopyService(IndexPathManager indexPathManager, JiraHome jiraHome, ClusteredIndexUtils clusteredIndexUtils, MessageHandler messageHandler, ServletContext servletContext) {
        this.clusteredIndexUtils = clusteredIndexUtils;
        this.localIndexPath = indexPathManager.getIndexRootPath();
        this.messageHandler = messageHandler;
        File sharedHome = jiraHome.getHome();
        this.sharedIndexPath = PathUtils.joinPaths((String[])new String[]{sharedHome.getAbsolutePath(), "caches"});
        this.eventContainer = JohnsonEventContainer.get((ServletContext)servletContext);
    }

    @Override
    public void backupIndex(String requestingNode) {
        if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
            this.copyIndex(this.localIndexPath, this.sharedIndexPath);
            this.messageHandler.sendMessage(requestingNode, Message.indexMessage(Message.MessageType.BACKUP_INDEX_DONE));
        }
    }

    @Override
    public void copyIndex(String sourcePath, String destinationPath) {
        this.clusteredIndexUtils.copyIndexes(sourcePath, destinationPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreIndex() {
        if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
            Event johnson = null;
            try {
                johnson = this.raiseJohnson();
                this.stopIndexing();
                this.copyIndex(this.sharedIndexPath, this.localIndexPath);
            }
            finally {
                this.eventContainer.removeEvent(johnson);
            }
        }
    }

    private void stopIndexing() {
        IssueIndexer indexIssuer = (IssueIndexer)ComponentAccessor.getComponent(IssueIndexer.class);
        SharedEntityIndexer sharedEntityIndexer = (SharedEntityIndexer)ComponentAccessor.getComponent(SharedEntityIndexer.class);
        indexIssuer.deleteIndexes();
        sharedEntityIndexer.clear(SearchRequest.ENTITY_TYPE);
        sharedEntityIndexer.clear(PortalPage.ENTITY_TYPE);
    }

    private Event raiseJohnson() {
        Event appEvent = new Event(EventType.get((String)"clustering"), COPYING, EventLevel.get((String)"warning"));
        this.eventContainer.addEvent(appEvent);
        return appEvent;
    }
}

