/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLEscapeUtil {
    public static final char ESCAPING_CHAR = '\u2603';
    private static final BiMap<Character, String> charToUnicodeString;
    private static final Map<Character, List<Character>> charToUnicodeCollection;
    private static final Pattern decoderPattern;

    public static String unicodeEncode(String string) {
        if (string == null) {
            return null;
        }
        boolean escapingNeeded = false;
        for (char character : string.toCharArray()) {
            if (!XMLEscapeUtil.shouldEscape(character)) continue;
            escapingNeeded = true;
            break;
        }
        if (!escapingNeeded) {
            return string;
        }
        StringBuffer escapedCopy = new StringBuffer();
        for (char character : string.toCharArray()) {
            if (XMLEscapeUtil.shouldEscape(character)) {
                escapedCopy.append((String)charToUnicodeString.get((Object)Character.valueOf(character)));
                continue;
            }
            escapedCopy.append(character);
        }
        return escapedCopy.toString();
    }

    public static String unicodeDecode(String string) {
        if (string == null) {
            return null;
        }
        boolean copied = false;
        StringBuffer copy = new StringBuffer();
        Matcher matcher = decoderPattern.matcher(string);
        while (matcher.find()) {
            copied = true;
            if (charToUnicodeString.inverse().containsKey((Object)matcher.group())) {
                matcher.appendReplacement(copy, ((Character)charToUnicodeString.inverse().get((Object)matcher.group())).toString());
                continue;
            }
            int codeInt = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(copy, Character.toString((char)codeInt));
        }
        if (copied) {
            matcher.appendTail(copy);
            return copy.toString();
        }
        return string;
    }

    public static int unicodeInPlaceEncode(char[] cbuf, int off, int len, int maxLen, Queue<Character> overflow) {
        if (len <= 0) {
            throw new IllegalStateException("Reader in inconsistent state: if nothing more can be read it shouldn't come here len is: " + len);
        }
        int usedLen = 0;
        for (int pos = off; pos < maxLen + off; ++pos) {
            char currentChar;
            if (pos < len + off && !XMLEscapeUtil.unicodeInPlaceEncode(currentChar = cbuf[pos], overflow)) {
                if (!overflow.isEmpty()) {
                    overflow.add(Character.valueOf(currentChar));
                } else {
                    ++usedLen;
                    continue;
                }
            }
            if (overflow.isEmpty() || pos >= maxLen + off) break;
            cbuf[pos] = overflow.remove().charValue();
            ++usedLen;
        }
        return usedLen;
    }

    private static boolean unicodeInPlaceEncode(char c, Queue<Character> overflow) {
        if (XMLEscapeUtil.shouldEscape(c)) {
            overflow.addAll((Collection<Character>)charToUnicodeCollection.get(Character.valueOf(c)));
            return true;
        }
        return false;
    }

    private static boolean shouldEscape(char c) {
        return c <= '\u001f' && c != '\t' && c != '\n' && c != '\r' || c >= '\ud800' && c <= '\udfff' || c >= '\ufffe' || c == '\u2603';
    }

    static {
        decoderPattern = Pattern.compile("\\\u2603([0-9ABCDEF]{4})");
        ImmutableBiMap.Builder stringBiMapBuilder = ImmutableBiMap.builder();
        ImmutableMap.Builder listMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < 65536; ++i) {
            if (!XMLEscapeUtil.shouldEscape((char)i)) continue;
            stringBiMapBuilder.put((Object)Character.valueOf((char)i), (Object)String.format("\u2603%04X", i));
            listMapBuilder.put((Object)Character.valueOf((char)i), (Object)Lists.charactersOf((String)String.format("\u2603%04X", i)));
        }
        charToUnicodeString = stringBiMapBuilder.build();
        charToUnicodeCollection = listMapBuilder.build();
    }
}

