/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.CommentTransformer;
import org.apache.log4j.Logger;

public class CommentTransformerImpl
implements CommentTransformer {
    private static final Logger log = Logger.getLogger(CommentTransformerImpl.class);

    @Override
    public ExternalComment transform(ProjectImportMapper projectImportMapper, ExternalComment oldComment) {
        ExternalComment newComment = new ExternalComment();
        newComment.setBody(oldComment.getBody());
        newComment.setGroupLevel(oldComment.getGroupLevel());
        newComment.setTimePerformed(oldComment.getTimePerformed());
        newComment.setUpdated(oldComment.getUpdated());
        newComment.setUsername(projectImportMapper.getUserMapper().getMappedUserKey(oldComment.getUsername()));
        newComment.setUpdateAuthor(projectImportMapper.getUserMapper().getMappedUserKey(oldComment.getUpdateAuthor()));
        String mappedIssueId = projectImportMapper.getIssueMapper().getMappedId(oldComment.getIssueId());
        newComment.setIssueId(mappedIssueId);
        String oldRoleLevel = oldComment.getRoleLevelId() == null ? null : oldComment.getRoleLevelId().toString();
        String newRoleLevelIdAsString = projectImportMapper.getProjectRoleMapper().getMappedId(oldRoleLevel);
        if (newRoleLevelIdAsString != null) {
            newComment.setRoleLevelId(new Long(newRoleLevelIdAsString));
        } else if (oldRoleLevel != null) {
            log.warn((Object)("Dropping the project role visibility level with id '" + oldRoleLevel + "' for a comment against issue with id '" + mappedIssueId + "' as JIRA is unable to resolve the project role in the backup data."));
        }
        return newComment;
    }
}

