/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParser;
import com.atlassian.jira.imports.project.transformer.CustomFieldValueTransformer;
import com.atlassian.jira.imports.project.transformer.CustomFieldValueTransformerImpl;
import com.atlassian.jira.issue.CustomFieldManager;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class CustomFieldValuePersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(CustomFieldValuePersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final CustomFieldManager customFieldManager;
    private final Long newProjectId;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private final Map<String, CustomFieldValueParser> parsers;
    private CustomFieldValueTransformer customFieldTransformer;

    public CustomFieldValuePersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, CustomFieldManager customFieldManager, Long newProjectId, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor, Map<String, CustomFieldValueParser> parsers) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.customFieldManager = customFieldManager;
        this.newProjectId = newProjectId;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
        this.parsers = parsers;
    }

    @Override
    public void handleEntity(final String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        ExternalCustomFieldValue externalCustomFieldValue;
        if (this.parsers.containsKey(entityName) && (externalCustomFieldValue = this.parsers.get(entityName).parse(attributes)) != null) {
            final ExternalCustomFieldValue transformedExternalCustomFieldValue = this.getCustomFieldValueTransformer().transform(this.projectImportMapper, externalCustomFieldValue, this.newProjectId);
            if (transformedExternalCustomFieldValue != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long customFieldValueId = CustomFieldValuePersisterHandler.this.projectImportPersister.createEntity(((CustomFieldValueParser)CustomFieldValuePersisterHandler.this.parsers.get(entityName)).getEntityRepresentation(transformedExternalCustomFieldValue));
                        if (customFieldValueId == null) {
                            String issueKey = CustomFieldValuePersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalCustomFieldValue.getIssueId());
                            CustomFieldValuePersisterHandler.this.projectImportResults.addError(CustomFieldValuePersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.custom.field.value.error", externalCustomFieldValue.getId(), issueKey));
                        }
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalCustomFieldValue.getIssueId());
                log.debug((Object)("Not persisting custom field value with old id '" + externalCustomFieldValue.getId() + "' for issue '" + issueKey + "', the transformer did not produce a transformed custom field value."));
            }
        }
    }

    CustomFieldValueTransformer getCustomFieldValueTransformer() {
        if (this.customFieldTransformer == null) {
            this.customFieldTransformer = new CustomFieldValueTransformerImpl(this.customFieldManager);
        }
        return this.customFieldTransformer;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }
}

