/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.i18n.AbstractI18nResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class JiraI18nResolver
extends AbstractI18nResolver {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory beanFactory;
    private final Cache<Locale, PrefixCache> localePrefixedKeysCache = CacheBuilder.newBuilder().expireAfterAccess(70L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Locale, PrefixCache>(){

        public PrefixCache load(Locale locale) {
            return new PrefixCache(locale);
        }
    });

    public JiraI18nResolver(JiraAuthenticationContext jiraAuthenticationContext, I18nHelper.BeanFactory beanFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beanFactory = beanFactory;
    }

    @Override
    public String resolveText(String key, Serializable[] arguments) {
        I18nHelper bean = this.beanFactory.getInstance(this.jiraAuthenticationContext.getLocale());
        return bean.getText(key, (Object)arguments);
    }

    @Override
    public String resolveText(Locale locale, String key, Serializable[] arguments) {
        I18nHelper bean = this.beanFactory.getInstance(locale);
        return bean.getText(key, (Object)arguments);
    }

    public String getRawText(String key) {
        I18nHelper bean = this.beanFactory.getInstance(this.jiraAuthenticationContext.getLocale());
        return bean.getUnescapedText(key);
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        return this.getAllTranslationsForPrefix(prefix, this.jiraAuthenticationContext.getLocale());
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        Assertions.notNull((String)"prefix", (Object)prefix);
        Assertions.notNull((String)"locale", (Object)locale);
        PrefixCache prefixCache = (PrefixCache)this.localePrefixedKeysCache.getUnchecked((Object)locale);
        return prefixCache.getAllTranslationsForPrefix(prefix);
    }

    class PrefixCache {
        private final Locale locale;
        private Cache<String, Map<String, String>> prefixValuesCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

            public Map<String, String> load(String prefix) {
                I18nHelper i18nBean = JiraI18nResolver.this.beanFactory.getInstance(PrefixCache.this.locale);
                Set keys = i18nBean.getKeysForPrefix(prefix);
                HashMap<String, String> ret = new HashMap<String, String>();
                for (String key : keys) {
                    ret.put(key.intern(), i18nBean.getUnescapedText(key).intern());
                }
                return ImmutableMap.copyOf(ret);
            }
        });

        PrefixCache(Locale locale) {
            this.locale = locale;
        }

        public Map<String, String> getAllTranslationsForPrefix(String prefix) {
            return (Map)this.prefixValuesCache.getUnchecked((Object)prefix);
        }
    }
}

