/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.external;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.external.ExternalException;
import com.atlassian.jira.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ExternalUtils {
    private final ProjectManager projectManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final CustomFieldManager customFieldManager;
    private final GenericDelegator genericDelegator;
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final ApplicationProperties applicationProperties;
    private final UserUtil userUtil;
    private static final Logger log = Logger.getLogger(ExternalUtils.class);
    public static final String TYPE_SEPERATOR = ":";
    public static final String CF_PREFIX = "customfield_";
    private static final String SEARCHER = "searcher";
    private static final String TEXT_FIELD_TYPE = "textfield";
    private static final String TEXT_FIELD_SEARCHER = "textsearcher";
    private static final String DATE_FIELD_TYPE = "datepicker";
    private static final String DATE_FIELD_SEARCHER = "daterange";

    public ExternalUtils(ProjectManager projectManager, PermissionSchemeManager permissionSchemeManager, IssueManager issueManager, JiraAuthenticationContext authenticationContext, VersionManager versionManager, CustomFieldManager customFieldManager, GenericDelegator genericDelegator, ConstantsManager constantsManager, WorkflowManager workflowManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager, ApplicationProperties applicationProperties, UserUtil userUtil) {
        this.projectManager = projectManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.versionManager = versionManager;
        this.customFieldManager = customFieldManager;
        this.genericDelegator = genericDelegator;
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.applicationProperties = applicationProperties;
        this.userUtil = userUtil;
    }

    public Project getProjectObject(ExternalProject externalProject) {
        Project project = null;
        if (StringUtils.isNotEmpty((String)externalProject.getKey())) {
            project = this.projectManager.getProjectObjByKey(externalProject.getKey());
        }
        if (project == null && StringUtils.isNotEmpty((String)externalProject.getName())) {
            project = this.projectManager.getProjectObjByName(externalProject.getName());
        }
        return project;
    }

    public Project createProject(ExternalProject externalProject) throws ExternalException {
        try {
            if (externalProject.getLead() == null) {
                externalProject.setLead(this.authenticationContext.getUser().getName());
            }
            if (externalProject.getAssigneeType() == null) {
                if (this.isUnassignedIssuesAllowed()) {
                    externalProject.setAssigneeType(String.valueOf(3L));
                } else {
                    externalProject.setAssigneeType(String.valueOf(2L));
                }
            }
            Project project = this.projectManager.createProject(externalProject.getName(), externalProject.getKey(), externalProject.getDescription(), externalProject.getLead(), externalProject.getUrl(), new Long(externalProject.getAssigneeType()));
            this.permissionSchemeManager.addDefaultSchemeToProject(project);
            this.issueTypeScreenSchemeManager.associateWithDefaultScheme(project);
            return project;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create project: " + externalProject, e);
        }
    }

    private boolean isUnassignedIssuesAllowed() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }

    public Version createVersion(ExternalProject externalProject, ExternalVersion externalVersion) {
        Version jiraVersion = null;
        try {
            String versionName = externalVersion.getName();
            jiraVersion = this.versionManager.createVersion(versionName, externalVersion.getReleaseDate(), externalVersion.getDescription(), externalProject.getProjectGV().getLong("id"), null);
            if (externalVersion.isArchived()) {
                this.versionManager.archiveVersion(jiraVersion, true);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while creating Version " + externalVersion), (Throwable)e);
        }
        return jiraVersion;
    }

    public Version getVersion(ExternalProject externalProject, ExternalVersion externalVersion) {
        Version jiraVersion = null;
        try {
            String versionName = externalVersion.getName();
            jiraVersion = this.versionManager.getVersion(externalProject.getProjectGV().getLong("id"), versionName);
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while retrieving Version " + externalVersion), (Throwable)e);
        }
        return jiraVersion;
    }

    public User createUser(ExternalUser externalUser) {
        try {
            return this.userUtil.createUserNoNotification(externalUser.getName(), externalUser.getPassword(), externalUser.getEmail(), externalUser.getFullname());
        }
        catch (Exception e) {
            log.warn((Object)("Problems encoutered while creating User " + externalUser), (Throwable)e);
            return null;
        }
    }

    public GenericValue createIssue(Issue issue, String status, String resolution) throws ExternalException {
        try {
            if (StringUtils.isNotBlank((String)status)) {
                this.checkStatus(issue, status);
            }
            GenericValue issueGV = this.issueManager.createIssue(this.authenticationContext.getLoggedInUser(), issue);
            if (StringUtils.isNotBlank((String)status)) {
                this.setCurrentWorkflowStep(issueGV, status, resolution);
            }
            return issueGV;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create issue: " + issue, e);
        }
    }

    protected void checkStatus(Issue issue, String statusId) throws WorkflowException, ExternalException {
        if (issue != null) {
            Status status = this.constantsManager.getStatusObject(statusId);
            if (status != null) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue.getProjectId(), issue.getIssueTypeId());
                StepDescriptor linkedStep = workflow.getLinkedStep(status);
                if (linkedStep == null) {
                    throw new ExternalException("Status '" + status.getName() + "' does not have a linked step in the '" + workflow.getName() + "' workflow. Please map to a different status.");
                }
            } else {
                throw new ExternalException("Cannot find status with id '" + statusId + "'.");
            }
        }
    }

    private void setCurrentWorkflowStep(GenericValue issue, String statusId, String resolution) throws GenericEntityException, WorkflowException {
        if (issue != null) {
            Status status = this.constantsManager.getStatusObject(statusId);
            if (status != null) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
                StepDescriptor linkedStep = workflow.getLinkedStep(status);
                List wfCurrentStepCollection = this.genericDelegator.findByAnd("OSCurrentStep", MapBuilder.build((Object)"entryId", (Object)issue.getLong("workflowId")));
                if (wfCurrentStepCollection != null && !wfCurrentStepCollection.isEmpty()) {
                    GenericValue wfCurrentStep = (GenericValue)wfCurrentStepCollection.iterator().next();
                    if (linkedStep != null) {
                        wfCurrentStep.set("stepId", (Object)linkedStep.getId());
                        wfCurrentStep.store();
                    } else {
                        log.error((Object)("Workflow '" + workflow.getName() + "' does not have a step for status '" + status.getName() + "'."));
                    }
                } else {
                    log.warn((Object)"Workflow Id not found");
                }
                issue.set("status", (Object)statusId);
                issue.set("resolution", (Object)resolution);
                issue.store();
            } else {
                log.warn((Object)("Status' GV for '" + statusId + "' was null. Issue not updated. " + issue));
            }
        }
    }

    public CustomField getCustomField(ExternalCustomFieldValue customFieldValue) {
        String customfieldId = customFieldValue.getKey();
        return this.getCustomField(customfieldId);
    }

    public CustomField getCustomField(String customfieldId) {
        CustomField customFieldObject = null;
        try {
            try {
                customFieldObject = this.customFieldManager.getCustomFieldObject(customfieldId);
            }
            catch (NumberFormatException e) {
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (customFieldObject == null) {
                String fieldName = this.extractCustomFieldId(customfieldId);
                customFieldObject = this.customFieldManager.getCustomFieldObjectByName(fieldName);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return customFieldObject;
    }

    public CustomField createCustomField(ExternalCustomFieldValue customFieldValue) {
        CustomField customFieldObject = null;
        String customfieldId = customFieldValue.getKey();
        String fieldName = this.extractCustomFieldId(customfieldId);
        String fieldType = this.extractCustomFieldType(customfieldId);
        try {
            customFieldObject = this.createCustomField(fieldName, fieldType);
        }
        catch (ExternalException e) {
            log.warn((Object)("Unable to create custom field " + customFieldValue), (Throwable)((Object)e));
        }
        return customFieldObject;
    }

    public String extractCustomFieldType(String customfieldId) {
        return StringUtils.substringAfter((String)customfieldId, (String)TYPE_SEPERATOR);
    }

    public String extractCustomFieldId(String customfieldId) {
        String fieldId = StringUtils.contains((String)customfieldId, (String)TYPE_SEPERATOR) ? StringUtils.substringBetween((String)customfieldId, (String)CF_PREFIX, (String)TYPE_SEPERATOR) : StringUtils.substringAfter((String)customfieldId, (String)CF_PREFIX);
        return fieldId;
    }

    private CustomField createCustomField(String customFieldName, String type) throws ExternalException {
        try {
            CustomFieldSearcher searcher;
            CustomFieldType cfType;
            if ("select".equals(type) || "userpicker".equals(type) || "multiselect".equals(type)) {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:" + type);
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:" + type + SEARCHER);
            } else if ("date".equals(type) || DATE_FIELD_TYPE.equals(type)) {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:datepicker");
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:daterange");
            } else {
                cfType = this.customFieldManager.getCustomFieldType("com.atlassian.jira.plugin.system.customfieldtypes:textfield");
                searcher = this.customFieldManager.getCustomFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
            }
            CustomField customField = this.customFieldManager.createCustomField(customFieldName, customFieldName, cfType, searcher, EasyList.build((Object)GlobalIssueContext.getInstance()), EasyList.buildNull());
            this.associateCustomFieldWithScreen(customField, null);
            return customField;
        }
        catch (GenericEntityException e) {
            throw new ExternalException(e);
        }
    }

    public void associateCustomFieldWithScreen(CustomField customField, FieldScreen screen) {
        if (screen == null) {
            screen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        }
        if (screen != null && screen.getTabs() != null && !screen.getTabs().isEmpty()) {
            FieldScreenTab tab = screen.getTab(0);
            tab.addFieldScreenLayoutItem(customField.getId());
        }
    }
}

