/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IssueIndexListener
extends AbstractIssueEventListener {
    private static final Logger log = Logger.getLogger(IssueIndexListener.class);
    public static final String NAME = "Issue Index Listener";

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    public boolean isInternal() {
        return true;
    }

    public void issueCreated(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueUpdated(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueAssigned(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueResolved(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueClosed(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueCommented(IssueEvent event) {
        IssueIndexListener.reIndex(event, false, false);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    public void issueWorkLogged(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueReopened(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueGenericEvent(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        IssueIndexListener.reIndex(event, false, false);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    public void issueCommentDeleted(IssueEvent event) {
        IssueIndexListener.reIndex(event, true, false);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        IssueIndexListener.reIndexModifiedIssue(event);
    }

    public void issueDeleted(IssueEvent event) {
    }

    public void issueMoved(IssueEvent event) {
        IssueIndexListener.reIndex(event, true, true);
    }

    public void customEvent(IssueEvent event) {
    }

    private static void reIndex(IssueEvent issueEvent, boolean reIndexComments, boolean reIndexChangeHistory) {
        HashSet<Issue> issuesToReindex = new HashSet<Issue>();
        Issue issue = issueEvent.getIssue();
        issuesToReindex.add(issue);
        if (issueEvent.isSubtasksUpdated()) {
            issuesToReindex.addAll(issue.getSubTaskObjects());
        }
        try {
            ComponentAccessor.getIssueIndexManager().reIndexIssueObjects(issuesToReindex, reIndexComments, reIndexChangeHistory);
        }
        catch (Exception issueReindexException) {
            log.error((Object)("Error re-indexing changes for issue '" + issue.getKey() + "'"), (Throwable)issueReindexException);
        }
    }

    private static void reIndexModifiedIssue(IssueEvent event) {
        IssueIndexListener.reIndex(event, false, true);
        if (event.getComment() != null) {
            IssueIndexListener.reIndexComment(event.getComment());
        }
    }

    private static void reIndexComment(Comment comment) {
        try {
            ComponentAccessor.getIssueIndexManager().reIndexComments(Collections.singletonList(comment));
        }
        catch (Exception commentReindexException) {
            log.error((Object)("Error re-indexing comment '" + comment.getId() + "'"), (Throwable)commentReindexException);
        }
    }

    public boolean isUnique() {
        return true;
    }

    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.issue.index.desc");
    }
}

