/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.jira.crowd.embedded.ofbiz.IdName;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

class OfBizUser
implements TimestampedUser,
IdName {
    private final long id;
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final Date createdDate;
    private final Date updatedDate;
    private final String emailAddress;
    private final String firstName;
    private final String lastName;
    private final String displayName;
    private final String externalId;

    static OfBizUser from(GenericValue userGenericValue) {
        return new OfBizUser(userGenericValue);
    }

    private OfBizUser(GenericValue userGenericValue) {
        Assertions.notNull((Object)userGenericValue);
        this.id = userGenericValue.getLong("id");
        this.directoryId = userGenericValue.getLong("directoryId");
        this.name = userGenericValue.getString("userName");
        this.active = BooleanUtils.toBoolean((int)userGenericValue.getInteger("active"));
        this.createdDate = userGenericValue.getTimestamp("createdDate");
        this.updatedDate = userGenericValue.getTimestamp("updatedDate");
        this.emailAddress = this.getEmailAddressFrom(userGenericValue);
        this.firstName = userGenericValue.getString("firstName");
        this.lastName = userGenericValue.getString("lastName");
        this.displayName = userGenericValue.getString("displayName");
        this.externalId = userGenericValue.getString("externalId");
    }

    private String getEmailAddressFrom(GenericValue userGenericValue) {
        if (userGenericValue.getString("emailAddress") == null) {
            return "";
        }
        return userGenericValue.getString("emailAddress");
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        return o instanceof User && UserComparator.equal((User)this, (User)((User)o));
    }

    public int hashCode() {
        return UserComparator.hashCode((User)this);
    }

    public String toString() {
        return this.name + ":" + this.directoryId;
    }

    public int compareTo(User other) {
        return UserComparator.compareTo((User)this, (User)other);
    }

    public String getExternalId() {
        return this.externalId;
    }
}

