/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.crowd.embedded.ofbiz.IdName;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.MembershipKey;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizInternalMembershipDao
implements InternalMembershipDao {
    private final OfBizDelegator ofBizDelegator;
    private final DirectoryDao directoryDao;
    private Interner<String> myInterner = Interners.newWeakInterner();
    private final ConcurrentMap<MembershipKey, Set<String>> parentsCache = new ConcurrentHashMap<MembershipKey, Set<String>>();
    private final ConcurrentMap<MembershipKey, Set<String>> childrenCache = new ConcurrentHashMap<MembershipKey, Set<String>>();

    public OfBizInternalMembershipDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao) {
        this.ofBizDelegator = ofBizDelegator;
        this.directoryDao = directoryDao;
        this.buildCache();
    }

    @Override
    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        Set parents = (Set)this.parentsCache.get(MembershipKey.getKeyPreserveCase(directoryId, userName, MembershipType.GROUP_USER));
        if (parents == null) {
            parents = (Set)this.parentsCache.get(MembershipKey.getKey(directoryId, userName, MembershipType.GROUP_USER));
        }
        if (parents == null) {
            return false;
        }
        if (parents.contains(groupName)) {
            return true;
        }
        return parents.contains(IdentifierUtils.toLowerCase((String)groupName));
    }

    @Override
    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
    }

    private boolean isDirectMember(long directoryId, MembershipType membershipType, String parentName, String childName) {
        GenericValue genericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).putCaseInsensitive("lowerChildName", childName).putCaseInsensitive("lowerParentName", parentName).put("membershipType", membershipType.name()).build()));
        return genericValue != null;
    }

    @Override
    public synchronized void addUserToGroup(long directoryId, IdName user, IdName group) {
        if (!this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
            this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
            this.addMembershipToParentCache(directoryId, user.getName(), group.getName(), MembershipType.GROUP_USER);
            this.addMembershipToChildCache(directoryId, user.getName(), group.getName(), MembershipType.GROUP_USER);
        }
    }

    private void createMembership(long directoryId, MembershipType membershipType, IdName parent, IdName child) {
        this.ofBizDelegator.createValue("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("childName", child.getName()).putCaseInsensitive("lowerChildName", child.getName()).put("parentId", parent.getId()).put("parentName", parent.getName()).putCaseInsensitive("lowerParentName", parent.getName()).put("membershipType", membershipType.name()).build());
    }

    @Override
    public void addGroupToGroup(long directoryId, IdName child, IdName parent) {
        if (!this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parent.getName(), child.getName())) {
            this.createMembership(directoryId, MembershipType.GROUP_GROUP, parent, child);
            this.addMembershipToParentCache(directoryId, child.getName(), parent.getName(), MembershipType.GROUP_GROUP);
            this.addMembershipToChildCache(directoryId, child.getName(), parent.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public synchronized void removeUserFromGroup(long directoryId, IdName user, IdName group) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_USER, group, user);
        this.removeMembershipFromParentCache(directoryId, user.getName(), group.getName(), MembershipType.GROUP_USER);
        this.removeMembershipFromChildCache(directoryId, user.getName(), group.getName(), MembershipType.GROUP_USER);
    }

    private void removeMembership(long directoryId, MembershipType membershipType, IdName parent, IdName child) throws MembershipNotFoundException {
        GenericValue membershipGenericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("parentId", parent.getId()).put("membershipType", membershipType.name()).build()));
        if (membershipGenericValue == null) {
            throw new MembershipNotFoundException(child.getName(), parent.getName());
        }
        this.ofBizDelegator.removeValue(membershipGenericValue);
    }

    @Override
    public void removeGroupFromGroup(long directoryId, IdName childGroup, IdName parentGroup) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
        this.removeMembershipFromParentCache(directoryId, childGroup.getName(), parentGroup.getName(), MembershipType.GROUP_GROUP);
        this.removeMembershipFromChildCache(directoryId, childGroup.getName(), parentGroup.getName(), MembershipType.GROUP_GROUP);
    }

    @Override
    public void removeAllMembersFromGroup(Group group) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("parentName", group.getName()).build());
        this.removeGroupParentFromAllCaches(group.getDirectoryId(), group.getName());
    }

    @Override
    public void removeAllGroupMemberships(Group group) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("membershipType", MembershipType.GROUP_GROUP.name()).put("childName", group.getName()).build());
        this.removeGroupChildFromAllCaches(group.getDirectoryId(), group.getName());
    }

    @Override
    public void removeAllUserMemberships(User user) {
        this.removeAllUserMemberships(user.getDirectoryId(), user.getName());
    }

    @Override
    public void removeAllUserMemberships(long directoryId, String username) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("membershipType", MembershipType.GROUP_USER.name()).put("childName", username).build());
        this.removeUserFromAllCaches(directoryId, username);
    }

    @Override
    public List<String> search(long directoryId, MembershipQuery query) {
        if (this.canUseCacheSearch(query)) {
            return this.searchCache(directoryId, query);
        }
        PrimitiveMap.Builder filter = PrimitiveMap.builder();
        filter.put("directoryId", directoryId);
        if (query.isFindChildren()) {
            filter.putCaseInsensitive("lowerParentName", query.getEntityNameToMatch());
        } else {
            filter.putCaseInsensitive("lowerChildName", query.getEntityNameToMatch());
        }
        if (query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            filter.put("membershipType", MembershipType.GROUP_USER.name());
        } else {
            filter.put("membershipType", MembershipType.GROUP_GROUP.name());
        }
        List<GenericValue> memberships = this.findMemberships(filter.build());
        ArrayList<String> entityNames = new ArrayList<String>(memberships.size());
        for (GenericValue membership : memberships) {
            entityNames.add(query.isFindChildren() ? membership.getString("childName") : membership.getString("parentName"));
        }
        return entityNames;
    }

    private List<String> searchCache(long directoryId, MembershipQuery<?> query) {
        MembershipType type = query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user()) ? MembershipType.GROUP_USER : MembershipType.GROUP_GROUP;
        if (query.isFindChildren()) {
            return this.getChildrenOfGroupFromCache(directoryId, query.getEntityNameToMatch(), type);
        }
        return this.getParentsForMemberFromCache(directoryId, query.getEntityNameToMatch(), type);
    }

    private List<String> getParentsForMemberFromCache(long directoryId, String userName, MembershipType type) {
        Set parents = (Set)this.parentsCache.get(MembershipKey.getKeyPreserveCase(directoryId, userName, type));
        if (parents == null) {
            parents = (Set)this.parentsCache.get(MembershipKey.getKey(directoryId, userName, type));
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        if (parents != null) {
            for (String parent : parents) {
                groupNames.add(parent);
            }
        }
        return groupNames;
    }

    private List<String> getChildrenOfGroupFromCache(long directoryId, String groupName, MembershipType type) {
        Set children = (Set)this.childrenCache.get(MembershipKey.getKeyPreserveCase(directoryId, groupName, type));
        if (children == null) {
            children = (Set)this.childrenCache.get(MembershipKey.getKey(directoryId, groupName, type));
        }
        ArrayList<String> userNames = new ArrayList<String>();
        if (children != null) {
            for (String child : children) {
                userNames.add(child);
            }
        }
        return userNames;
    }

    private boolean canUseCacheSearch(MembershipQuery<?> query) {
        return query.getStartIndex() == 0 && query.getMaxResults() == -1;
    }

    private List<GenericValue> findMemberships(Map<String, Object> filter) {
        return this.ofBizDelegator.findByAnd("Membership", filter);
    }

    @Override
    public synchronized void flushCache() {
        this.parentsCache.clear();
        this.childrenCache.clear();
        this.buildCache();
    }

    private void buildCache() {
        for (Directory directory : this.directoryDao.findAll()) {
            List<GenericValue> genericValues = this.findMemberships(PrimitiveMap.of("directoryId", directory.getId()));
            for (GenericValue gvMembership : genericValues) {
                Long directoryId = gvMembership.getLong("directoryId");
                String groupName = gvMembership.getString("parentName");
                String userName = gvMembership.getString("childName");
                MembershipType type = MembershipType.valueOf((String)gvMembership.getString("membershipType"));
                this.fastAddUserMembershipToUserCache(directoryId, userName, groupName, type);
                this.fastAddUserMembershipToGroupCache(directoryId, userName, groupName, type);
            }
        }
        for (Map.Entry entry : this.childrenCache.entrySet()) {
            this.childrenCache.put((MembershipKey)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        for (Map.Entry entry : this.parentsCache.entrySet()) {
            this.parentsCache.put((MembershipKey)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
    }

    private void fastAddUserMembershipToGroupCache(Long directoryId, String userName, String groupName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, (String)this.myInterner.intern((Object)groupName), type);
        HashSet<String> children = (HashSet<String>)this.childrenCache.get(key);
        if (children == null) {
            children = new HashSet<String>();
            this.childrenCache.put(key, children);
        }
        String lowerName = (String)this.myInterner.intern((Object)IdentifierUtils.toLowerCase((String)userName));
        children.add(lowerName);
    }

    private void fastAddUserMembershipToUserCache(Long directoryId, String userName, String groupName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, (String)this.myInterner.intern((Object)userName), type);
        HashSet<String> parents = (HashSet<String>)this.parentsCache.get(key);
        if (parents == null) {
            parents = new HashSet<String>();
            this.parentsCache.put(key, parents);
        }
        String name = (String)this.myInterner.intern((Object)IdentifierUtils.toLowerCase((String)groupName));
        parents.add(name);
    }

    private void addMembershipToParentCache(Long directoryId, String userName, String groupName, MembershipType type) {
        Set<String> parents;
        String lowerName = (String)this.myInterner.intern((Object)IdentifierUtils.toLowerCase((String)groupName));
        MembershipKey key = MembershipKey.getKey(directoryId, (String)this.myInterner.intern((Object)userName), type);
        Set existingParents = (Set)this.parentsCache.get(key);
        if (existingParents != null) {
            parents = new HashSet<String>(existingParents.size() + 1);
            parents.addAll(existingParents);
            parents.add(lowerName);
        } else {
            parents = Collections.singleton(lowerName);
        }
        this.parentsCache.put(key, Collections.unmodifiableSet(parents));
    }

    private void addMembershipToChildCache(Long directoryId, String userName, String groupName, MembershipType type) {
        Set<String> children;
        MembershipKey key = MembershipKey.getKey(directoryId, (String)this.myInterner.intern((Object)groupName), type);
        String lowerName = (String)this.myInterner.intern((Object)IdentifierUtils.toLowerCase((String)userName));
        Set existingChildren = (Set)this.childrenCache.get(key);
        if (existingChildren != null) {
            children = new HashSet<String>(existingChildren.size() + 1);
            children.addAll(existingChildren);
            children.add(lowerName);
        } else {
            children = Collections.singleton(lowerName);
        }
        this.childrenCache.put(key, Collections.unmodifiableSet(children));
    }

    private void removeMembershipFromParentCache(Long directoryId, String userName, String groupName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, userName, type);
        Set existingParents = (Set)this.parentsCache.get(key);
        if (existingParents != null) {
            HashSet parents = new HashSet(existingParents);
            parents.remove(IdentifierUtils.toLowerCase((String)groupName));
            if (parents.size() == 0) {
                this.parentsCache.remove(key);
            } else {
                this.parentsCache.put(key, Collections.unmodifiableSet(parents));
            }
        }
    }

    private void removeMembershipFromChildCache(Long directoryId, String userName, String groupName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, groupName, type);
        Set existingChildren = (Set)this.childrenCache.get(key);
        if (existingChildren != null) {
            HashSet children = new HashSet(existingChildren);
            children.addAll(existingChildren);
            children.remove(IdentifierUtils.toLowerCase((String)userName));
            if (children.size() == 0) {
                this.childrenCache.remove(key);
            } else {
                this.childrenCache.put(key, Collections.unmodifiableSet(children));
            }
        }
    }

    private void removeUserFromAllCaches(Long directoryId, String userName) {
        List<String> groups = this.getParentsForMemberFromCache(directoryId, userName, MembershipType.GROUP_USER);
        for (String groupName : groups) {
            this.removeMembershipFromParentCache(directoryId, userName, groupName, MembershipType.GROUP_USER);
            this.removeMembershipFromChildCache(directoryId, userName, groupName, MembershipType.GROUP_USER);
        }
    }

    private void removeGroupParentFromAllCaches(Long directoryId, String groupName) {
        List<String> users = this.getChildrenOfGroupFromCache(directoryId, groupName, MembershipType.GROUP_USER);
        for (String userName : users) {
            this.removeMembershipFromParentCache(directoryId, userName, groupName, MembershipType.GROUP_USER);
            this.removeMembershipFromChildCache(directoryId, userName, groupName, MembershipType.GROUP_USER);
        }
        List<String> childGroups = this.getChildrenOfGroupFromCache(directoryId, groupName, MembershipType.GROUP_GROUP);
        for (String childName : childGroups) {
            this.removeMembershipFromParentCache(directoryId, childName, groupName, MembershipType.GROUP_GROUP);
            this.removeMembershipFromChildCache(directoryId, childName, groupName, MembershipType.GROUP_GROUP);
        }
    }

    private void removeGroupChildFromAllCaches(Long directoryId, String groupName) {
        List<String> parentGroups = this.getParentsForMemberFromCache(directoryId, groupName, MembershipType.GROUP_GROUP);
        for (String parentName : parentGroups) {
            this.removeMembershipFromParentCache(directoryId, groupName, parentName, MembershipType.GROUP_GROUP);
            this.removeMembershipFromChildCache(directoryId, groupName, parentName, MembershipType.GROUP_GROUP);
        }
    }
}

