/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.exception.ParseException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JPanel;

public abstract class DatabaseConfigPanel {
    public static final int TEXT_FIELD_COLUMNS = 20;

    public String toString() {
        return this.getDisplayName();
    }

    public abstract void validate() throws ValidationException;

    public abstract String getDisplayName();

    public abstract String getClassName();

    public abstract String getUrl(String var1) throws ValidationException;

    public abstract String getUsername();

    public abstract String getPassword();

    public abstract String getSchemaName();

    public abstract JPanel getPanel();

    int validatePortNumber(String portText) throws ValidationException {
        if (portText.trim().length() == 0) {
            return -1;
        }
        try {
            int port = Integer.parseInt(portText);
            if (port < 0 || port > 65535) {
                throw new ValidationException("Port number out of range.");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Port must be a valid number.");
        }
    }

    void validateNotBlank(String fieldName, String text) throws ValidationException {
        if (text == null || text.trim().length() == 0) {
            throw new ValidationException("Please set a value for " + fieldName);
        }
    }

    public abstract void setSettings(Settings var1) throws ParseException;

    public void saveSettings(Settings newSettings, String jiraHome) throws ValidationException {
        DatabaseType databaseType;
        String driverClassName = this.getClassName();
        try {
            databaseType = DatabaseType.forJdbcDriverClassName(driverClassName);
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationException(iae.getMessage());
        }
        newSettings.getJdbcDatasourceBuilder().setDatabaseType(databaseType).setDriverClassName(driverClassName).setJdbcUrl(this.getUrl(jiraHome)).setUsername(this.getUsername()).setPassword(this.getPassword());
        newSettings.setSchemaName(this.getSchemaName());
    }

    public void testConnection(String jiraHome) throws ClassNotFoundException, SQLException, ValidationException {
        Driver driver;
        Class<?> driverClass = Class.forName(this.getClassName(), true, DatabaseConfigPanel.getDriverClassLoader());
        try {
            driver = (Driver)driverClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        DriverManager.setLoginTimeout(10);
        Properties props = new Properties();
        props.setProperty("user", this.getUsername());
        props.setProperty("password", this.getPassword());
        driver.connect(this.getUrl(jiraHome), props);
    }

    private static ClassLoader getDriverClassLoader() {
        ArrayList<URL> jars = new ArrayList<URL>();
        File libDir = new File("../lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            libDir = new File("../idea-tomcat/lib");
        }
        for (File file : libDir.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                jars.add(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                System.err.println("Unexpected MalformedURLException on file '" + file.getAbsolutePath() + "'.");
                ex.printStackTrace(System.err);
            }
        }
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }
}

