/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.FeatureStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultFeatureManager
implements FeatureManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultFeatureManager.class);
    private static final String USER_DARKFEATURE_PREFERENCE_KEY = "user.features.enabled";
    private static final boolean DARK_FEATURES_DISABLED_SYSTEM_WIDE = Boolean.getBoolean("atlassian.darkfeature.disabled");
    public static final String FEATURE_RESOURCE_TYPE = "feature";
    public static final Resources.TypeFilter FEATURE_TYPE_FILTER = new Resources.TypeFilter("feature");
    private static final String CORE_FEATURES_RESOURCE = "jira-features.properties";
    private static final Function<String, InputStream> APP_CLASS_LOADER = new Function<String, InputStream>(){

        public InputStream apply(@Nullable String name) {
            return DefaultFeatureManager.class.getClassLoader().getResourceAsStream(name);
        }
    };
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureStore featureStore;
    private final FeaturesMapHolder features;
    private final ResettableLazyReference<Set<String>> siteFeatures = new ResettableLazyReference<Set<String>>(){

        protected Set<String> create() throws Exception {
            return DefaultFeatureManager.this.getSiteEnabledFeaturesFromStore();
        }
    };
    private final Cache<String, Set<String>> userFeaturesCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Set<String>>(){

        public Set<String> load(String key) throws Exception {
            return DefaultFeatureManager.this.getUserEnabledFeaturesFromStore(key);
        }
    });
    private final LazyReference<EventPublisher> eventPublisherRef = new LazyReference<EventPublisher>(){

        protected EventPublisher create() throws Exception {
            return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        }
    };
    private final LazyReference<PermissionManager> permissionManagerRef = new LazyReference<PermissionManager>(){

        protected PermissionManager create() throws Exception {
            return ComponentAccessor.getPermissionManager();
        }
    };

    private static Function<String, InputStream> pluginLoader(final Plugin plugin) {
        return new Function<String, InputStream>(){

            public InputStream apply(@Nullable String name) {
                return plugin.getResourceAsStream(name);
            }
        };
    }

    @VisibleForTesting
    DefaultFeatureManager(PropertiesContainer properties, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, FeatureStore featureStore) {
        this.featureStore = featureStore;
        this.features = new FeaturesMapHolder(properties.properties);
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
    }

    public DefaultFeatureManager(ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, FeatureStore featureStore) {
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.featureStore = featureStore;
        this.features = new FeaturesMapHolder();
    }

    private static Properties loadCoreProperties() {
        String salDarkFeaturesProperty = System.getProperty("darkfeatures.properties.file", "atlassian-darkfeatures.properties");
        Properties jiraProperties = DefaultFeatureManager.loadProperties(CORE_FEATURES_RESOURCE, APP_CLASS_LOADER);
        Properties salProperties = APP_CLASS_LOADER.apply((Object)salDarkFeaturesProperty) != null ? DefaultFeatureManager.loadProperties(salDarkFeaturesProperty, APP_CLASS_LOADER) : Collections.emptyMap();
        MapBuilder unionPropertiesBuilder = MapBuilder.newBuilder();
        Sets.SetView union = Sets.union(jiraProperties.keySet(), salProperties.keySet());
        for (Object key : union) {
            if (jiraProperties.containsKey(key)) {
                unionPropertiesBuilder.add(key, jiraProperties.get(key));
                continue;
            }
            if (!salProperties.containsKey(key)) continue;
            unionPropertiesBuilder.add(key, salProperties.get(key));
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)unionPropertiesBuilder.toHashMap());
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("atlassian.darkfeature.")) continue;
            String featureKey = key.substring("atlassian.darkfeature.".length(), key.length());
            String featureValue = System.getProperty(key);
            log.trace("Feature '{}' is set to {} by system properties", (Object)featureKey, (Object)featureValue);
            properties.setProperty(featureKey, featureValue);
        }
        return properties;
    }

    private static Properties loadProperties(String path, Function<String, InputStream> loader) {
        InputStream propsStream = (InputStream)Assertions.notNull((String)String.format("Resource %s not found", path), (Object)loader.apply((Object)path));
        try {
            Properties props = new Properties();
            props.load(propsStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties from " + path, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)propsStream);
        }
    }

    private boolean isEnabled(String featureKey, boolean isUserSettable) {
        return Boolean.TRUE.equals(this.features.features().get((Object)featureKey)) || this.getDarkFeatures(isUserSettable).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(String featureKey) {
        return this.isEnabled(featureKey, true);
    }

    public boolean isEnabled(Feature feature) {
        if (feature instanceof CoreFeatures) {
            return this.isEnabled((CoreFeatures)feature);
        }
        return this.isEnabled(feature.featureKey(), true);
    }

    public boolean isEnabledForUser(@Nullable ApplicationUser user, String featureKey) {
        return this.getDarkFeaturesForUser(user).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(CoreFeatures feature) {
        return this.isEnabled(feature.featureKey(), feature.isDevFeature());
    }

    public boolean isOnDemand() {
        return this.isEnabled(CoreFeatures.ON_DEMAND);
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.features.enabledFeatures();
    }

    public DarkFeatures getDarkFeatures() {
        return this.getDarkFeatures(true);
    }

    private DarkFeatures getDarkFeatures(boolean includeUserSettable) {
        if (includeUserSettable) {
            ApplicationUser user = this.authenticationContext.getUser();
            return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
        }
        return DARK_FEATURES_DISABLED_SYSTEM_WIDE ? new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet()) : new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), Collections.emptySet());
    }

    public DarkFeatures getDarkFeaturesForUser(@Nullable ApplicationUser user) {
        if (DARK_FEATURES_DISABLED_SYSTEM_WIDE) {
            return new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
    }

    @Deprecated
    public void enableUserDarkFeature(User user, String feature) {
        this.enableUserDarkFeature(ApplicationUsers.from((User)user), feature);
    }

    @Deprecated
    public void disableUserDarkFeature(User user, String feature) {
        this.disableUserDarkFeature(ApplicationUsers.from((User)user), feature);
    }

    public void enableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, true);
    }

    public void disableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, false);
    }

    public void enableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, true);
    }

    public void disableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, false);
    }

    public boolean hasSiteEditPermission() {
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        return ((PermissionManager)this.permissionManagerRef.get()).hasPermission(0, loggedInUser);
    }

    private void changeUserDarkFeature(ApplicationUser user, String feature, boolean enable) {
        CoreFeatures coreFeature = CoreFeatures.forFeatureKey((String)feature);
        if (coreFeature != null && !coreFeature.isDevFeature()) {
            throw new IllegalStateException("User cannot set feature '" + feature + "' at runtime. It must be set by an admin via properties.");
        }
        HashSet enabledFeatures = Sets.newHashSet(this.getUserEnabledFeatures(user));
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, user.getKey());
            enabledFeatures.add(feature);
        } else {
            this.featureStore.delete(feature, user.getKey());
            enabledFeatures.remove(feature);
        }
        this.userFeaturesCache.invalidate((Object)user.getKey());
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature, user) : new FeatureDisabledEvent(feature, user));
    }

    private void changeSiteDarkFeature(String feature, boolean enable) {
        if (!this.hasSiteEditPermission()) {
            throw new IllegalStateException("User " + this.authenticationContext.getUser() + " does not have permission to change site dark features");
        }
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, null);
            enabledFeatures.add(feature);
        } else {
            this.featureStore.delete(feature, null);
            enabledFeatures.remove(feature);
        }
        this.siteFeatures.reset();
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature) : new FeatureDisabledEvent(feature));
    }

    private Set<String> getUserEnabledFeatures(ApplicationUser user) {
        if (user != null) {
            return (Set)this.userFeaturesCache.getUnchecked((Object)user.getKey());
        }
        return Sets.newHashSet();
    }

    private Set<String> getUserEnabledFeaturesFromStore(String userKey) {
        return this.featureStore.getUserFeatures(userKey);
    }

    private Set<String> getSiteEnabledFeatures() {
        return (Set)this.siteFeatures.get();
    }

    private Set<String> getSiteEnabledFeaturesFromStore() {
        return this.featureStore.getSiteFeatures();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.userFeaturesCache.invalidateAll();
        this.siteFeatures.reset();
    }

    private static List<Properties> loadPluginFeatureProperties() {
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        ArrayList features = Lists.newArrayList();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            for (ResourceDescriptor featureDescriptor : DefaultFeatureManager.getFeatureResources(plugin)) {
                features.add(DefaultFeatureManager.loadProperties(featureDescriptor.getLocation(), DefaultFeatureManager.pluginLoader(plugin)));
            }
        }
        return features;
    }

    private static Collection<ResourceDescriptor> getFeatureResources(Plugin plugin) {
        return Collections2.filter((Collection)plugin.getResourceDescriptors(), (Predicate)FEATURE_TYPE_FILTER);
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(this.getClass().getSimpleName() + ".userFeaturesCache").addCache(this.userFeaturesCache).install();
        this.features.start();
    }

    @VisibleForTesting
    static final class PropertiesContainer {
        final Iterable<Properties> properties;

        PropertiesContainer(Iterable<Properties> properties) {
            this.properties = properties;
        }
    }

    @EventComponent
    public static class FeaturesMapHolder {
        private final ResettableLazyReference<ImmutableMap<String, Boolean>> features;
        private final ResettableLazyReference<ImmutableSet<String>> enabledFeatures = new EnabledFeaturesRef();
        private volatile boolean jiraStarted;

        FeaturesMapHolder() {
            this.features = new ResettableLazyReference<ImmutableMap<String, Boolean>>(){

                protected ImmutableMap<String, Boolean> create() throws Exception {
                    ImmutableList propertiesToLoad = FeaturesMapHolder.this.jiraStarted ? Iterables.concat((Iterable)ImmutableList.of((Object)DefaultFeatureManager.loadCoreProperties()), (Iterable)DefaultFeatureManager.loadPluginFeatureProperties()) : ImmutableList.of((Object)DefaultFeatureManager.loadCoreProperties());
                    return FeaturesMapHolder.this.initFeatures((Iterable)propertiesToLoad);
                }
            };
        }

        FeaturesMapHolder(final Iterable<Properties> properties) {
            this.features = new ResettableLazyReference<ImmutableMap<String, Boolean>>(){

                protected ImmutableMap<String, Boolean> create() throws Exception {
                    return FeaturesMapHolder.this.initFeatures(properties);
                }
            };
        }

        ImmutableMap<String, Boolean> features() {
            return (ImmutableMap)this.features.get();
        }

        ImmutableSet<String> enabledFeatures() {
            return (ImmutableSet)this.enabledFeatures.get();
        }

        private ImmutableMap<String, Boolean> initFeatures(Iterable<Properties> properties) {
            HashMap collector = Maps.newHashMap();
            for (Properties singleProperties : properties) {
                for (String property : singleProperties.stringPropertyNames()) {
                    collector.put(property, Boolean.valueOf(singleProperties.getProperty(property)));
                }
            }
            return ImmutableMap.copyOf((Map)collector);
        }

        private ImmutableSet<String> initEnabledFeatures(ImmutableMap<String, Boolean> allFeatures) {
            ImmutableSet.Builder collector = ImmutableSet.builder();
            for (Map.Entry featureToggle : allFeatures.entrySet()) {
                if (!((Boolean)featureToggle.getValue()).booleanValue()) continue;
                collector.add(featureToggle.getKey());
            }
            return collector.build();
        }

        @EventListener
        public void onPluginEnabled(PluginEnabledEvent event) {
            this.onPluginEvent(event.getPlugin());
        }

        @EventListener
        public void onPluginDisabled(PluginDisabledEvent event) {
            this.onPluginEvent(event.getPlugin());
        }

        public void start() {
            this.jiraStarted = true;
            this.clearCache();
        }

        private void onPluginEvent(Plugin plugin) {
            if (!DefaultFeatureManager.getFeatureResources(plugin).isEmpty()) {
                this.clearCache();
            }
        }

        private void clearCache() {
            this.features.reset();
            this.enabledFeatures.reset();
        }

        private class EnabledFeaturesRef
        extends ResettableLazyReference<ImmutableSet<String>> {
            private EnabledFeaturesRef() {
            }

            protected ImmutableSet<String> create() throws Exception {
                return FeaturesMapHolder.this.initEnabledFeatures((ImmutableMap<String, Boolean>)((ImmutableMap)FeaturesMapHolder.this.features.get()));
            }
        }
    }
}

