/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.ClusterServicesRegistry;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.cluster.NodeStateCheckerService;
import com.atlassian.jira.service.services.index.ReplicatedIndexCleaningService;
import com.atlassian.jira.util.I18nHelper;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DefaultClusterServicesManager
implements ClusterServicesManager,
Startable {
    private final MessageHandler messageHandler;
    private final ClusterManager clusterManager;
    private final NodeReindexService nodeReindexService;
    private final ServiceManager serviceManager;
    private final I18nHelper i18nHelper;
    private static final Logger log = Logger.getLogger(ClusterServicesManager.class);

    public DefaultClusterServicesManager(ClusterManager clusterManager, ServiceManager serviceManager, ClusterServicesRegistry clusterServicesRegistry, I18nHelper i18nHelper) {
        this.clusterManager = clusterManager;
        this.serviceManager = serviceManager;
        this.i18nHelper = i18nHelper;
        this.messageHandler = clusterServicesRegistry.getMessageHandler();
        this.nodeReindexService = clusterServicesRegistry.getNodeReindexService();
    }

    @Override
    public void startServices() {
        if (this.clusterManager.isClustered()) {
            this.nodeReindexService.start();
            this.messageHandler.start();
            new IndexCleaningServiceHelper().createIndexCleaningServiceIfNeeded(this.i18nHelper);
            new NodeCheckerServiceHelper().createNodeCheckerServiceIfNeeded(this.i18nHelper);
        }
    }

    @Override
    public void stopServices() {
        this.nodeReindexService.cancel();
        this.messageHandler.stop();
    }

    public void start() throws Exception {
        this.startServices();
    }

    private final class NodeCheckerServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.services.nodechecker.service";
        private final long DELAY = DateUtils.MINUTE_MILLIS * 1L;

        private NodeCheckerServiceHelper() {
        }

        public void createNodeCheckerServiceIfNeeded(I18nHelper i18n) {
            try {
                HashMap params = new HashMap();
                String serviceName = i18n.getText(SERVICE_NAME_KEY);
                if (DefaultClusterServicesManager.this.serviceManager.getServiceWithName(serviceName) == null) {
                    DefaultClusterServicesManager.this.serviceManager.addService(serviceName, NodeStateCheckerService.class.getName(), this.DELAY, params);
                }
            }
            catch (Exception e) {
                log.error((Object)DefaultClusterServicesManager.this.i18nHelper.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }
    }

    private final class IndexCleaningServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.services.indexcleaner.service";
        private final long DELAY = DateUtils.HOUR_MILLIS * 12L;

        private IndexCleaningServiceHelper() {
        }

        public void createIndexCleaningServiceIfNeeded(I18nHelper i18n) {
            try {
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put("RETENTION_PERIOD", new String[]{"30m"});
                String serviceName = i18n.getText(SERVICE_NAME_KEY);
                if (DefaultClusterServicesManager.this.serviceManager.getServiceWithName(serviceName) == null) {
                    DefaultClusterServicesManager.this.serviceManager.addService(serviceName, ReplicatedIndexCleaningService.class.getName(), this.DELAY, params);
                }
            }
            catch (Exception e) {
                log.error((Object)DefaultClusterServicesManager.this.i18nHelper.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }
    }
}

