/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesRegistry;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.index.ha.NodeReindexService;
import javax.annotation.Nullable;

public class DefaultClusterManager
implements ClusterManager {
    private final ClusterServicesRegistry clusterServicesRegistry;
    private final NodeStateManager nodeStateManager;

    public DefaultClusterManager(ClusterServicesRegistry clusterServicesRegistry, NodeStateManager nodeStateManager) {
        this.clusterServicesRegistry = clusterServicesRegistry;
        this.nodeStateManager = nodeStateManager;
    }

    @Override
    @Nullable
    public String getNodeId() {
        return this.nodeStateManager.getNode().getNodeId();
    }

    @Override
    public boolean isClustered() {
        return this.nodeStateManager.getNode().isClustered();
    }

    @Override
    public boolean isActive() {
        return this.nodeStateManager.getNode().getState().equals((Object)Node.NodeState.ACTIVE);
    }

    @Override
    public void checkIndex() {
        NodeReindexService nodeReindexService;
        if (!this.isActive() && (nodeReindexService = this.clusterServicesRegistry.getNodeReindexService()).canIndexBeRebuilt()) {
            this.requestCurrentIndexFromNode("ANY");
        }
    }

    @Override
    public void requestCurrentIndexFromNode(String node) {
        this.clusterServicesRegistry.getMessageHandler().sendMessage(node, Message.indexMessage(Message.MessageType.BACKUP_INDEX));
    }
}

