/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkDeleteOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditOperation;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkUnwatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWorkflowTransitionOperation;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultBulkOperationManager
implements BulkOperationManager {
    public static final String BULK_WATCH_DARK_FEATURE = "com.atlassian.jira.darkfeature.BulkWatch";
    private static final Logger log = Logger.getLogger(DefaultBulkOperationManager.class);
    private final WatcherService watcherService;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final Map<String, BulkOperation> systemBulkOperations = Maps.newLinkedHashMap();
    private final Map<String, BulkOperation> pluginProvidedBulkOperations = Maps.newLinkedHashMap();

    public DefaultBulkOperationManager(JiraAuthenticationContext jiraAuthenticationContext, WatcherService watcherService, FeatureManager featureManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.watcherService = watcherService;
        this.featureManager = featureManager;
        this.systemBulkOperations.put("bulk.edit.operation.name", JiraUtils.loadComponent(BulkEditOperation.class));
        BulkMigrateOperation bulkMigrateOperation = JiraUtils.loadComponent(BulkMigrateOperation.class);
        this.systemBulkOperations.put(bulkMigrateOperation.getNameKey(), bulkMigrateOperation);
        this.systemBulkOperations.put("bulk.workflowtransition.operation.name", JiraUtils.loadComponent(BulkWorkflowTransitionOperation.class));
        this.systemBulkOperations.put("bulk.delete.operation.name", new BulkDeleteOperation());
    }

    public Collection<BulkOperation> getBulkOperations() {
        return this.getBulkOperationsMap().values();
    }

    public BulkOperation getOperation(String operationName) {
        return this.getBulkOperationsMap().get(operationName);
    }

    public boolean isValidOperation(String operationName) {
        return this.getBulkOperationsMap().containsKey(operationName);
    }

    public void addBulkOperation(String operationName, Class<? extends BulkOperation> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Bulk Operation " + operationName + " with class " + componentClass));
        }
        this.pluginProvidedBulkOperations.put(operationName, JiraUtils.loadComponent(componentClass));
    }

    protected Map<String, BulkOperation> getBulkOperationsMap() {
        MapBuilder results = MapBuilder.newBuilder();
        results.addAll(this.systemBulkOperations);
        if (this.jiraAuthenticationContext.isLoggedInUser() && this.watcherService.isWatchingEnabled() && this.featureManager.isEnabled(BULK_WATCH_DARK_FEATURE)) {
            BulkWatchOperation bulkWatchOperation = JiraUtils.loadComponent(BulkWatchOperation.class);
            results.add((Object)bulkWatchOperation.getNameKey(), (Object)bulkWatchOperation);
            BulkUnwatchOperation bulkUnwatchOperation = JiraUtils.loadComponent(BulkUnwatchOperation.class);
            results.add((Object)bulkUnwatchOperation.getNameKey(), (Object)bulkUnwatchOperation);
        }
        results.addAll(this.pluginProvidedBulkOperations);
        return results.toListOrderedMap();
    }
}

