/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class UserMatcherPredicate
implements Predicate<User> {
    private final String query;
    private final boolean canMatchAddresses;

    public UserMatcherPredicate(String query, boolean canMatchAddresses) {
        Assertions.notNull((String)"query", (Object)query);
        this.query = query.toLowerCase();
        this.canMatchAddresses = canMatchAddresses;
    }

    public boolean apply(User user) {
        String userPart = user.getName();
        if (StringUtils.isNotBlank((String)userPart) && userPart.toLowerCase().startsWith(this.query)) {
            return true;
        }
        if (this.canMatchAddresses && StringUtils.isNotBlank((String)(userPart = user.getEmailAddress())) && userPart.toLowerCase().startsWith(this.query)) {
            return true;
        }
        userPart = user.getDisplayName();
        if (StringUtils.isNotBlank((String)userPart)) {
            String lowerCaseDisplayName = userPart.toLowerCase();
            if (lowerCaseDisplayName.startsWith(this.query)) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(lowerCaseDisplayName);
            tokenizer.nextToken();
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().startsWith(this.query)) continue;
                return true;
            }
        }
        return false;
    }
}

