/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.event.user.UserRenamedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.PreDeleteUserErrorsManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultUserService
implements UserService {
    private static final int MAX_FIELD_LENGTH = 255;
    private static final char[] INVALID_USERNAME_CHARS = new char[]{'<', '>', '&'};
    private final UserUtil userUtil;
    private final UserDeleteVeto userDeleteVeto;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraContactHelper jiraContactHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;
    private final PreDeleteUserErrorsManager preDeleteUserErrorsManager;
    private final PasswordPolicyManager passwordPolicyManager;

    public DefaultUserService(UserUtil userUtil, UserDeleteVeto userDeleteVeto, PermissionManager permissionManager, UserManager userManager, JiraContactHelper jiraContactHelper, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext, EventPublisher eventPublisher, PreDeleteUserErrorsManager preDeleteUserErrorsManager, PasswordPolicyManager passwordPolicyManager) {
        this.userUtil = userUtil;
        this.userDeleteVeto = userDeleteVeto;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.jiraContactHelper = jiraContactHelper;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventPublisher = eventPublisher;
        this.preDeleteUserErrorsManager = preDeleteUserErrorsManager;
        this.passwordPolicyManager = passwordPolicyManager;
    }

    public UserService.CreateUserValidationResult validateCreateUserForSignup(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForSignupOrSetup(loggedInUser, username, password, confirmPassword, email, fullname, true);
    }

    public UserService.CreateUserValidationResult validateCreateUserForSetup(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForSignupOrSetup(loggedInUser, username, password, confirmPassword, email, fullname, false);
    }

    public UserService.CreateUserValidationResult validateCreateUserForSignupOrSetup(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForSignupOrSetup(loggedInUser, username, password, confirmPassword, email, fullname, true);
    }

    private UserService.CreateUserValidationResult validateCreateUserForSignupOrSetup(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname, boolean checkForWritableDirectory) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (checkForWritableDirectory && !this.userManager.hasWritableDirectory()) {
            String link = this.getContactAdminLink(i18nBean);
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.all.directories.read.only.contact.admin", link));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        Object passwordErrors = ImmutableList.of();
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, null));
        if (StringUtils.isEmpty((String)password)) {
            errors.addError(UserService.FieldName.PASSWORD, i18nBean.getText("signup.error.password.required"));
        } else {
            passwordErrors = this.buildPasswordErrors((ErrorCollection)errors, ApplicationUsers.from((User)loggedInUser), username, fullname, email, password);
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors, (List)passwordErrors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdminPasswordRequired(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.no.permission.to.create"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.hasWritableDirectory()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.all.directories.read.only"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        Object passwordErrors = ImmutableList.of();
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, null));
        if (StringUtils.isEmpty((String)password)) {
            errors.addError(UserService.FieldName.PASSWORD, i18nBean.getText("signup.error.password.required"));
        } else {
            passwordErrors = this.buildPasswordErrors((ErrorCollection)errors, ApplicationUsers.from((User)loggedInUser), username, fullname, email, password);
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors, (List)passwordErrors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname, null);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForAdmin(loggedInUser, username, password, confirmPassword, email, fullname, null);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(User loggedInUser, String username, String password, String confirmPassword, String email, String fullname, @Nullable Long directoryId) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.no.permission.to.create"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.hasWritableDirectory()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.all.directories.read.only"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, directoryId));
        if (directoryId == null) {
            if (this.userManager.getWritableDirectories().size() == 0) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.all.directories.read.only"));
            }
        } else {
            Directory directory = this.userManager.getDirectory(directoryId);
            if (directory == null) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.no.such.directory", (Object)directoryId));
            } else if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.read.only.directory", directory.getName()));
            }
        }
        Object passwordErrors = ImmutableList.of();
        if (password != null) {
            passwordErrors = this.buildPasswordErrors((ErrorCollection)errors, username, fullname, email, password);
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors, (List)passwordErrors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname, directoryId);
    }

    public UserService.CreateUsernameValidationResult validateCreateUsername(User loggedInUser, String username) {
        return this.validateCreateUsername(loggedInUser, username, null);
    }

    public UserService.CreateUsernameValidationResult validateCreateUsername(User loggedInUser, String username, Long directoryId) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        this.validateUsername(username, directoryId, i18nBean, (ErrorCollection)errors);
        return new UserService.CreateUsernameValidationResult(username, directoryId, (ErrorCollection)errors);
    }

    private ErrorCollection validateCreateUser(I18nHelper i18nBean, String username, String password, String confirmPassword, String email, String fullname, @Nullable Long directoryId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (StringUtils.isEmpty((String)email)) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.required"));
        } else if (email.length() > 255) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.greater.than.max.chars"));
        } else if (!TextUtils.verifyEmail((String)email)) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.valid"));
        }
        if (StringUtils.isEmpty((String)fullname)) {
            errors.addError(UserService.FieldName.FULLNAME, i18nBean.getText("signup.error.fullname.required"));
        } else if (fullname.length() > 255) {
            errors.addError(UserService.FieldName.FULLNAME, i18nBean.getText("signup.error.full.name.greater.than.max.chars"));
        }
        this.validateUsername(username, directoryId, i18nBean, (ErrorCollection)errors);
        if (!(!StringUtils.isNotEmpty((String)confirmPassword) && !StringUtils.isNotEmpty((String)password) || password != null && password.equals(confirmPassword))) {
            errors.addError(UserService.FieldName.CONFIRM_PASSWORD, i18nBean.getText("signup.error.password.mustmatch"));
        }
        return errors;
    }

    private void validateUsername(String username, Long directoryId, I18nHelper i18nBean, ErrorCollection errors) {
        if (StringUtils.isEmpty((String)username)) {
            errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.required"));
        } else if (username.length() > 255) {
            errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.greater.than.max.chars"));
        } else {
            if (StringUtils.containsAny((String)username, (char[])INVALID_USERNAME_CHARS)) {
                errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.invalid.chars"));
            }
            if (!errors.getErrors().containsKey(UserService.FieldName.NAME)) {
                if (directoryId == null) {
                    if (this.userUtil.userExists(username)) {
                        errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.exists"));
                    }
                } else if (this.userManager.findUserInDirectory(username, directoryId) != null) {
                    errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.exists"));
                }
            }
        }
    }

    public User createUserNoNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        String username = result.getUsername();
        String password = result.getPassword();
        String email = result.getEmail();
        String fullname = result.getFullname();
        Long directoryId = result.getDirectoryId();
        return this.userUtil.createUserNoNotification(username, password, email, fullname, directoryId);
    }

    public User createUserFromSignup(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 0);
    }

    public User createUserWithNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 1);
    }

    private User createUserWithNotification(UserService.CreateUserValidationResult result, int eventType) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user, validation result", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        String username = result.getUsername();
        String password = result.getPassword();
        String email = result.getEmail();
        String fullname = result.getFullname();
        Long directoryId = result.getDirectoryId();
        return this.userUtil.createUserWithNotification(username, password, email, fullname, directoryId, eventType);
    }

    public UserService.UpdateUserValidationResult validateUpdateUser(User user) {
        return this.validateUpdateUser(ApplicationUsers.from((User)user));
    }

    public UserService.UpdateUserValidationResult validateUpdateUser(ApplicationUser user) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.update.no.permission"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        ApplicationUser userToUpdate = this.userManager.getUserByKey(user.getKey());
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.user.does.not.exist"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.canUpdateUser(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.edit.user.directory.read.only"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.be.sysadmin.to.edit.sysadmin"));
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        if (!user.isActive()) {
            Collection projects;
            Collection components = this.userUtil.getComponentsUserLeads(userToUpdate);
            if (components.size() > 0) {
                String projectList = this.getDisplayableProjectList(this.getProjectsFor(components));
                errors.addError("active", i18nBean.getText("admin.errors.users.cannot.deactivate.due.to.component.lead", projectList));
            }
            if ((projects = this.userUtil.getProjectsLeadBy(userToUpdate)).size() > 0) {
                String projectList = this.getDisplayableProjectList(projects);
                errors.addError("active", i18nBean.getText("admin.errors.users.cannot.deactivate.due.to.project.lead", projectList));
            }
            if (loggedInUser.getName().equalsIgnoreCase(user.getUsername())) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.deactivate.currently.logged.in"));
            }
        }
        if (!IdentifierUtils.equalsInLowerCase((String)userToUpdate.getUsername(), (String)user.getUsername())) {
            if (this.userManager.canRenameUser(userToUpdate)) {
                this.validateUsername(user.getUsername(), null, i18nBean, (ErrorCollection)errors);
            } else {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.rename.due.to.configuration"));
            }
        }
        if (errors.hasAnyErrors()) {
            return new UserService.UpdateUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.UpdateUserValidationResult(user);
    }

    private Collection<Project> getProjectsFor(Collection<ProjectComponent> components) {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        HashSet<Project> projects = new HashSet<Project>(components.size());
        for (ProjectComponent component : components) {
            projects.add(projectManager.getProjectObj(component.getProjectId()));
        }
        return projects;
    }

    private String getDisplayableProjectList(Collection<Project> projects) {
        Collection projectKeys = Collections2.transform(projects, (Function)new Function<Project, String>(){

            public String apply(Project from) {
                return from.getKey();
            }
        });
        return StringUtils.join((Collection)projectKeys, (String)", ");
    }

    public void updateUser(UserService.UpdateUserValidationResult updateUserValidationResult) {
        if (updateUserValidationResult.isValid()) {
            ApplicationUser oldUser = this.userManager.getUserByKey(updateUserValidationResult.getApplicationUser().getKey());
            this.userManager.updateUser(updateUserValidationResult.getApplicationUser());
            if (IdentifierUtils.equalsInLowerCase((String)oldUser.getUsername(), (String)updateUserValidationResult.getApplicationUser().getUsername())) {
                this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(updateUserValidationResult.getApplicationUser(), this.jiraAuthenticationContext.getUser()));
            } else {
                this.eventPublisher.publish((Object)new UserRenamedEvent(updateUserValidationResult.getApplicationUser(), this.jiraAuthenticationContext.getUser(), oldUser.getUsername()));
            }
        } else {
            throw new IllegalStateException("Invalid UpdateUserValidationResult");
        }
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(User loggedInUser, String username) {
        return this.validateDeleteUser(ApplicationUsers.from((User)loggedInUser), username);
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, String username) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (username == null || username.length() == 0) {
            errors.addError("username", i18nBean.getText("admin.errors.users.cannot.delete.due.to.invalid.username"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        return this.validateDeleteUser(loggedInUser, this.userManager.getUserByName(username));
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(ApplicationUser loggedInUser, ApplicationUser userForDelete) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.delete.no.permission"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.isUserExisting(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.user.does.not.exist"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (userForDelete.equals(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.currently.logged.in"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.userManager.canUpdateUser(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.user.read.only"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userForDelete)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.sysadmin"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        try {
            if (!this.userManager.getUserState(userForDelete).isInMultipleDirectories()) {
                this.validateDeleteUserReferences(loggedInUser, userForDelete, i18nBean, (ErrorCollection)errors);
            }
        }
        catch (Exception e) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.exception.occured.validating") + " " + e);
        }
        if (errors.hasAnyErrors()) {
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.DeleteUserValidationResult(userForDelete);
    }

    private void validateDeleteUserReferences(ApplicationUser loggedInUser, ApplicationUser userForDelete, I18nHelper i18nBean, ErrorCollection errors) throws SearchException {
        long numberOfProjectsUserLeads;
        long numberOfComments;
        long numberOfAssignedIssues;
        String username = userForDelete.getUsername();
        long numberOfReportedIssues = this.userUtil.getNumberOfReportedIssuesIgnoreSecurity(loggedInUser, userForDelete);
        if (numberOfReportedIssues > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.reported.issues", "'" + username + "'", "" + numberOfReportedIssues));
        }
        if ((numberOfAssignedIssues = this.userUtil.getNumberOfAssignedIssuesIgnoreSecurity(loggedInUser, userForDelete)) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.assigned.issues", "'" + username + "'", "" + numberOfAssignedIssues));
        }
        if ((numberOfComments = this.userDeleteVeto.getCommentCountByAuthor(userForDelete)) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.commented.issues", "'" + username + "'", "" + numberOfComments));
        }
        if ((numberOfProjectsUserLeads = (long)this.userUtil.getProjectsLeadBy(userForDelete).size()) > 0L) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.project.lead", "'" + username + "'", "" + numberOfProjectsUserLeads));
        }
        ImmutableList<WebErrorMessage> lst = this.preDeleteUserErrorsManager.getWarnings(userForDelete.getDirectoryUser());
        for (WebErrorMessage errorMessage : lst) {
            errors.addErrorMessage(errorMessage.getDescription());
        }
    }

    private boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    private boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user);
    }

    public void removeUser(User loggedInUser, UserService.DeleteUserValidationResult result) {
        this.removeUser(ApplicationUsers.from((User)loggedInUser), result);
    }

    public void removeUser(ApplicationUser loggedInUser, UserService.DeleteUserValidationResult result) {
        Assertions.notNull((String)"You can not remove a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not remove a user with an invalid validation result.", (boolean)result.isValid());
        ApplicationUser userForDelete = result.getApplicationUser();
        this.userUtil.removeUser(loggedInUser, userForDelete);
    }

    I18nHelper getI18nBean(User user) {
        return this.i18nFactory.getInstance(user);
    }

    I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    private String getContactAdminLink(I18nHelper i18n) {
        return this.jiraContactHelper.getAdministratorContactMessage(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WebErrorMessage> buildPasswordErrors(ErrorCollection errors, ApplicationUser loggedInUser, String username, String fullname, String email, String password) {
        ApplicationUser originalUser = this.jiraAuthenticationContext.getUser();
        this.jiraAuthenticationContext.setLoggedInUser(loggedInUser);
        try {
            List<WebErrorMessage> list = this.buildPasswordErrors(errors, username, fullname, email, password);
            return list;
        }
        finally {
            this.jiraAuthenticationContext.setLoggedInUser(originalUser);
        }
    }

    private List<WebErrorMessage> buildPasswordErrors(ErrorCollection errors, String username, String fullname, String email, String password) {
        Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(username, fullname, email, password);
        if (messages.isEmpty()) {
            return ImmutableList.of();
        }
        errors.addError(UserService.FieldName.PASSWORD, this.jiraAuthenticationContext.getI18nHelper().getText("signup.error.password.rejected"));
        return ImmutableList.copyOf(messages);
    }
}

