/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.worklog;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResultFactory;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.entity.PredicatedPagedList;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.PagedList;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultWorklogService
implements WorklogService {
    private static final Logger log = Logger.getLogger(DefaultWorklogService.class);
    private final WorklogManager worklogManager;
    private final PermissionManager permissionManager;
    private final VisibilityValidator visibilityValidator;
    private final ProjectRoleManager projectRoleManager;
    private final IssueManager issueManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final JiraDurationUtils jiraDurationUtils;
    private final GroupManager groupManager;
    private static final String WORKLOG_I18N_PREFIX = "worklog";

    public DefaultWorklogService(WorklogManager worklogManager, PermissionManager permissionManager, VisibilityValidator visibilityValidator, ProjectRoleManager projectRoleManager, IssueManager issueManager, TimeTrackingConfiguration timeTrackingConfiguration, JiraDurationUtils jiraDurationUtils, GroupManager groupManager) {
        this.worklogManager = worklogManager;
        this.permissionManager = permissionManager;
        this.visibilityValidator = visibilityValidator;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.jiraDurationUtils = jiraDurationUtils;
        this.groupManager = groupManager;
    }

    public WorklogResult validateDelete(JiraServiceContext jiraServiceContext, Long worklogId) {
        Worklog originalWorklog = this.worklogManager.getById(worklogId);
        if (this.hasPermissionToDelete(jiraServiceContext, originalWorklog)) {
            return WorklogResultFactory.create((Worklog)originalWorklog);
        }
        return null;
    }

    public WorklogNewEstimateResult validateDeleteWithNewEstimate(JiraServiceContext jiraServiceContext, Long worklogId, String newEstimate) {
        WorklogResult originalWorklogResult = this.validateDelete(jiraServiceContext, worklogId);
        if (originalWorklogResult != null && this.isValidNewEstimate(jiraServiceContext, newEstimate)) {
            Long estimate = newEstimate == null ? null : Long.valueOf(this.getDurationForFormattedString(newEstimate, jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)originalWorklogResult, (Long)estimate);
        }
        return null;
    }

    public WorklogAdjustmentAmountResult validateDeleteWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, Long worklogId, String adjustmentAmount) {
        WorklogResult originalWorklogResult = this.validateDelete(jiraServiceContext, worklogId);
        if (originalWorklogResult != null && this.isValidAdjustmentAmount(jiraServiceContext, adjustmentAmount)) {
            return WorklogResultFactory.createAdjustmentAmount((WorklogResult)originalWorklogResult, (Long)this.getDurationForFormattedString(adjustmentAmount, jiraServiceContext));
        }
        return null;
    }

    public boolean deleteWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogNewEstimate, boolean dispatchEvent) {
        return this.delete(jiraServiceContext, (WorklogResult)worklogNewEstimate, worklogNewEstimate.getNewEstimate(), dispatchEvent);
    }

    public boolean deleteWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        Long newEstimate = this.increaseEstimate(worklogResult.getWorklog().getIssue(), worklogResult.getAdjustmentAmount());
        return this.delete(jiraServiceContext, (WorklogResult)worklogResult, newEstimate, dispatchEvent);
    }

    public boolean deleteAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.delete(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public boolean deleteAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return false;
        }
        Long timeSpent = worklogResult.getWorklog().getTimeSpent();
        Long newEstimate = this.increaseEstimate(worklogResult.getWorklog().getIssue(), timeSpent);
        return this.delete(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    public WorklogResult validateUpdate(JiraServiceContext jiraServiceContext, WorklogInputParameters params) {
        Worklog updatedWorklog;
        Assertions.notNull((String)"params", (Object)params);
        Worklog originalWorklog = this.worklogManager.getById(params.getWorklogId());
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        if (this.hasPermissionToUpdate(jiraServiceContext, originalWorklog) && (updatedWorklog = this.validateParamsAndCreateWorklog(jiraServiceContext, originalWorklog.getIssue(), originalWorklog.getAuthorObject(), params.getGroupLevel(), params.getRoleLevelId(), params.getTimeSpent(), params.getStartDate(), params.getWorklogId(), params.getComment(), originalWorklog.getCreated(), new Date(), user, params.getErrorFieldPrefix())) != null) {
            return WorklogResultFactory.create((Worklog)updatedWorklog);
        }
        return null;
    }

    public WorklogNewEstimateResult validateUpdateWithNewEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateInputParameters params) {
        Assertions.notNull((String)"params", (Object)params);
        WorklogResult worklogResult = this.validateUpdate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidNewEstimate(jiraServiceContext, params.getNewEstimate(), params.getErrorFieldPrefix()) && worklogResult != null) {
            Long estimate = params.getNewEstimate() == null ? null : Long.valueOf(this.getDurationForFormattedString(params.getNewEstimate(), jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)worklogResult, estimate);
        }
        return null;
    }

    public Worklog updateWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogResult, boolean dispatchEvent) {
        return this.update(jiraServiceContext, (WorklogResult)worklogResult, worklogResult.getNewEstimate(), dispatchEvent);
    }

    public Worklog updateAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.update(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public Worklog updateAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return null;
        }
        Worklog originalWorklog = this.worklogManager.getById(worklogResult.getWorklog().getId());
        if (originalWorklog == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.worklog.for.id", worklogResult.getWorklog().getId().toString()));
            return null;
        }
        Long originalTimeSpent = originalWorklog.getTimeSpent();
        Long newTimeSpent = worklogResult.getWorklog().getTimeSpent();
        Long newEstimate = this.getAutoAdjustNewEstimateOnUpdate(worklogResult.getWorklog().getIssue(), newTimeSpent, originalTimeSpent);
        return this.update(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    protected boolean delete(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return false;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return false;
        }
        if (this.hasPermissionToDelete(jiraServiceContext, worklogResult.getWorklog())) {
            return this.worklogManager.delete(ApplicationUsers.toDirectoryUser((ApplicationUser)user), worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return false;
    }

    protected Worklog update(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        Worklog updatedWorklog = null;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (worklogResult.getWorklog().getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
            return null;
        }
        if (this.hasPermissionToUpdate(jiraServiceContext, worklogResult.getWorklog())) {
            updatedWorklog = this.worklogManager.update(ApplicationUsers.toDirectoryUser((ApplicationUser)user), worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return updatedWorklog;
    }

    public WorklogResult validateCreate(JiraServiceContext jiraServiceContext, WorklogInputParameters params) {
        Worklog worklog;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        if (this.hasPermissionToCreate(jiraServiceContext, params.getIssue(), params.isEditableCheckRequired()) && (worklog = this.validateParamsAndCreateWorklog(jiraServiceContext, params.getIssue(), user, params.getGroupLevel(), params.getRoleLevelId(), params.getTimeSpent(), params.getStartDate(), null, params.getComment(), null, null, null, params.getErrorFieldPrefix())) != null) {
            return WorklogResultFactory.create((Worklog)worklog, (boolean)params.isEditableCheckRequired());
        }
        return null;
    }

    public WorklogNewEstimateResult validateCreateWithNewEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateInputParameters params) {
        WorklogResult worklogResult = this.validateCreate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidNewEstimate(jiraServiceContext, params.getNewEstimate(), params.getErrorFieldPrefix()) && worklogResult != null) {
            Long estimate = params.getNewEstimate() == null ? null : Long.valueOf(this.getDurationForFormattedString(params.getNewEstimate(), jiraServiceContext));
            return WorklogResultFactory.createNewEstimate((WorklogResult)worklogResult, estimate);
        }
        return null;
    }

    public WorklogAdjustmentAmountResult validateCreateWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountInputParameters params) {
        WorklogResult worklogResult = this.validateCreate(jiraServiceContext, (WorklogInputParameters)params);
        if (this.isValidAdjustmentAmount(jiraServiceContext, params.getAdjustmentAmount(), params.getErrorFieldPrefix()) && worklogResult != null) {
            return WorklogResultFactory.createAdjustmentAmount((WorklogResult)worklogResult, (Long)this.getDurationForFormattedString(params.getAdjustmentAmount(), jiraServiceContext));
        }
        return null;
    }

    public Worklog createWithNewRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogNewEstimateResult worklogResult, boolean dispatchEvent) {
        return this.create(jiraServiceContext, (WorklogResult)worklogResult, worklogResult.getNewEstimate(), dispatchEvent);
    }

    public Worklog createWithManuallyAdjustedEstimate(JiraServiceContext jiraServiceContext, WorklogAdjustmentAmountResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        Worklog worklog = worklogResult.getWorklog();
        Long newEstimate = this.reduceEstimate(worklog.getIssue(), worklogResult.getAdjustmentAmount());
        return this.create(jiraServiceContext, (WorklogResult)worklogResult, newEstimate, dispatchEvent);
    }

    public Worklog createAndRetainRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        return this.create(jiraServiceContext, worklogResult, null, dispatchEvent);
    }

    public Worklog createAndAutoAdjustRemainingEstimate(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        Long newEstimate = this.reduceEstimate(worklogResult.getWorklog().getIssue(), worklogResult.getWorklog().getTimeSpent());
        return this.create(jiraServiceContext, worklogResult, newEstimate, dispatchEvent);
    }

    public boolean hasPermissionToCreate(JiraServiceContext jiraServiceContext, Issue issue, boolean isEditableCheckRequired) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return false;
        }
        if (isEditableCheckRequired && !this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.not.editable.workflow.state"));
            return false;
        }
        boolean hasPerm = this.permissionManager.hasPermission(20, issue, user);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.permission.no.user"));
            }
        }
        return hasPerm;
    }

    public boolean hasPermissionToUpdate(JiraServiceContext jiraServiceContext, Worklog worklog) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        this.validateUpdateOrDeletePermissionCheckParams(worklog, (ErrorCollection)errorCollection, jiraServiceContext);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasEditAllPermission(user, worklog.getIssue()) && !this.hasEditOwnPermission(user, worklog)) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.edit.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.edit.permission.no.user"));
            }
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        boolean isValidVisibility = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)errorCollection), WORKLOG_I18N_PREFIX, worklog.getIssue(), worklog.getGroupLevel(), worklog.getRoleLevelId() == null ? null : worklog.getRoleLevelId().toString());
        if (!isValidVisibility) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean hasPermissionToDelete(JiraServiceContext jiraServiceContext, Worklog worklog) {
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.time.tracking.not.enabed"));
            return false;
        }
        this.validateUpdateOrDeletePermissionCheckParams(worklog, (ErrorCollection)errorCollection, jiraServiceContext);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasDeleteAllPermission(user, worklog.getIssue()) && !this.hasDeleteOwnPermission(user, worklog)) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.delete.permission", user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.no.delete.permission.no.user"));
            }
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        boolean isValidVisibility = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)errorCollection), WORKLOG_I18N_PREFIX, worklog.getIssue(), worklog.getGroupLevel(), worklog.getRoleLevelId() == null ? null : worklog.getRoleLevelId().toString());
        if (!isValidVisibility) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public Worklog getById(JiraServiceContext jiraServiceContext, Long id) {
        if (!this.isTimeTrackingEnabled()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.time.tracking.not.enabed"));
            return null;
        }
        Worklog worklog = this.worklogManager.getById(id);
        if (worklog != null) {
            if (this.hasPermissionToView(jiraServiceContext, worklog)) {
                return worklog;
            }
            jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.no.view.permission"));
            return null;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("worklog.service.error.no.worklog.for.id", (Object)id));
        return null;
    }

    public List getByIssue(JiraServiceContext jiraServiceContext, Issue issue) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.null.issue"));
            return Collections.EMPTY_LIST;
        }
        return this.worklogManager.getByIssue(issue);
    }

    public List<Worklog> getByIssueVisibleToUser(JiraServiceContext jiraServiceContext, Issue issue) {
        ArrayList<Worklog> visibleWorklogs = new ArrayList<Worklog>();
        List allWorklogs = this.getByIssue(jiraServiceContext, issue);
        for (Object allWorklog : allWorklogs) {
            Worklog worklog = (Worklog)allWorklog;
            if (!this.hasPermissionToView(jiraServiceContext, worklog)) continue;
            visibleWorklogs.add(worklog);
        }
        return visibleWorklogs;
    }

    public PagedList<Worklog> getByIssueVisibleToUser(final JiraServiceContext jiraServiceContext, Issue issue, int pageSize) {
        PagedList worklogs = this.worklogManager.getByIssue(issue, pageSize);
        return new PredicatedPagedList<Worklog>(worklogs, new Predicate<Worklog>(){

            public boolean apply(@Nullable Worklog worklog) {
                return DefaultWorklogService.this.hasPermissionToView(jiraServiceContext, worklog);
            }
        });
    }

    private boolean hasPermissionToView(JiraServiceContext jiraServiceContext, Worklog worklog) {
        String groupLevel = worklog.getGroupLevel();
        Long roleLevel = worklog.getRoleLevelId();
        boolean roleProvided = roleLevel != null;
        boolean groupProvided = StringUtils.isNotBlank((String)groupLevel);
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        boolean userInRole = roleProvided && this.isUserInRole(roleLevel, user, worklog.getIssue());
        boolean userInGroup = groupProvided && this.isUserInGroup(user, groupLevel);
        boolean noLevelsProvided = !groupProvided && !roleProvided;
        return noLevelsProvided || userInRole || userInGroup;
    }

    public boolean isTimeTrackingEnabled() {
        return this.timeTrackingConfiguration.enabled();
    }

    public boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    void validateUpdateOrDeletePermissionCheckParams(Worklog worklog, ErrorCollection errorCollection, JiraServiceContext jiraServiceContext) {
        if (worklog == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return;
        }
        Issue issue = worklog.getIssue();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return;
        }
        if (!this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.not.editable.workflow.state"));
            return;
        }
        if (worklog.getId() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.id.null"));
        }
    }

    boolean hasEditIssuePermission(User user, Issue issue) {
        return this.permissionManager.hasPermission(12, issue, user);
    }

    protected Worklog validateParamsAndCreateWorklog(JiraServiceContext jiraServiceContext, Issue issue, ApplicationUser author, String groupLevel, String roleLevelId, String timeSpent, Date startDate, Long worklogId, String comment, Date created, Date updated, ApplicationUser updateAuthor, String errorFieldPrefix) {
        boolean defaultInputFieldsValidated;
        WorklogImpl worklog = null;
        if (this.visibilityValidator.isValidVisibilityData(jiraServiceContext, WORKLOG_I18N_PREFIX, issue, groupLevel, roleLevelId) && (defaultInputFieldsValidated = this.isValidWorklogInputFields(jiraServiceContext, issue, timeSpent, startDate, errorFieldPrefix))) {
            worklog = new WorklogImpl(this.worklogManager, issue, worklogId, ApplicationUsers.getKeyFor((ApplicationUser)author), comment, startDate, groupLevel, TextUtils.stringSet((String)roleLevelId) ? Long.valueOf(roleLevelId) : null, Long.valueOf(this.getDurationForFormattedString(timeSpent, jiraServiceContext)), updateAuthor != null ? updateAuthor.getKey() : null, created, updated);
        }
        return worklog;
    }

    protected Worklog create(JiraServiceContext jiraServiceContext, WorklogResult worklogResult, Long newEstimate, boolean dispatchEvent) {
        Worklog newWorklog = null;
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (worklogResult == null || worklogResult.getWorklog() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.worklog.null"));
            return null;
        }
        if (worklogResult.getWorklog().getIssue() == null) {
            errorCollection.addErrorMessage(this.getText(jiraServiceContext, "worklog.service.error.issue.null"));
            return null;
        }
        if (this.hasPermissionToCreate(jiraServiceContext, worklogResult.getWorklog().getIssue(), worklogResult.isEditableCheckRequired())) {
            newWorklog = this.worklogManager.create(ApplicationUsers.toDirectoryUser((ApplicationUser)user), worklogResult.getWorklog(), newEstimate, dispatchEvent);
        }
        return newWorklog;
    }

    protected boolean hasEditOwnPermission(ApplicationUser user, Worklog worklog) {
        return this.isSameAuthor(user, worklog) && this.permissionManager.hasPermission(40, worklog.getIssue(), user);
    }

    protected boolean hasEditAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(41, issue, user);
    }

    protected boolean hasDeleteOwnPermission(ApplicationUser user, Worklog worklog) {
        return this.isSameAuthor(user, worklog) && this.permissionManager.hasPermission(42, worklog.getIssue(), user);
    }

    protected boolean hasDeleteAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(43, issue, user);
    }

    protected boolean isSameAuthor(ApplicationUser user, Worklog worklog) {
        if (user != null && worklog.getAuthorObject() != null) {
            return user.equals(worklog.getAuthorObject());
        }
        return user == null && worklog != null && worklog.getAuthorObject() == null;
    }

    protected Long getAutoAdjustNewEstimateOnUpdate(Issue issue, Long newTimeSpent, Long originalTimeSpent) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate + originalTimeSpent - newTimeSpent;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected Long reduceEstimate(Issue issue, Long amount) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate - amount;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected Long increaseEstimate(Issue issue, Long amount) {
        Long timeEstimate = issue.getEstimate();
        long oldTimeEstimate = timeEstimate == null ? 0L : timeEstimate;
        long newTimeEstimate = oldTimeEstimate + amount;
        return newTimeEstimate < 0L ? 0L : newTimeEstimate;
    }

    protected boolean isValidNewEstimate(JiraServiceContext jiraServiceContext, String newEstimate) {
        return this.isValidNewEstimate(jiraServiceContext, newEstimate, null);
    }

    protected boolean isValidNewEstimate(JiraServiceContext jiraServiceContext, String newEstimate, String errorFieldPrefix) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        String errorField = "newEstimate";
        if (StringUtils.isNotBlank((String)errorFieldPrefix)) {
            errorField = errorFieldPrefix + errorField;
        }
        if (TextUtils.stringSet((String)newEstimate)) {
            if (!this.isValidDuration(newEstimate, jiraServiceContext)) {
                errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.newestimate"));
                return false;
            }
        } else {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.new.estimate.not.specified"));
            return false;
        }
        return true;
    }

    protected boolean isValidAdjustmentAmount(JiraServiceContext jiraServiceContext, String adjustmentAmount) {
        return this.isValidAdjustmentAmount(jiraServiceContext, adjustmentAmount, null);
    }

    protected boolean isValidAdjustmentAmount(JiraServiceContext jiraServiceContext, String adjustmentAmount, String errorFieldPrefix) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        String errorField = "adjustmentAmount";
        if (StringUtils.isNotBlank((String)errorFieldPrefix)) {
            errorField = errorFieldPrefix + errorField;
        }
        if (!TextUtils.stringSet((String)adjustmentAmount)) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.adjustment.amount.not.specified"));
            return false;
        }
        if (!this.isValidDuration(adjustmentAmount, jiraServiceContext)) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.adjustment.amount.invalid"));
            return false;
        }
        return true;
    }

    protected boolean isValidWorklogInputFields(JiraServiceContext jiraServiceContext, Issue issue, String timeSpent, Date startDate, String errorFieldPrefix) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String errorField = "timeLogged";
        if (StringUtils.isNotBlank((String)errorFieldPrefix)) {
            errorField = errorFieldPrefix + errorField;
        }
        if (!TextUtils.stringSet((String)timeSpent)) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.timespent.required"));
        } else if (!this.isValidDuration(timeSpent, jiraServiceContext)) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.invalid.time.duration"));
        } else if (this.getDurationForFormattedString(timeSpent, jiraServiceContext) == 0L) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.timespent.zero"));
        }
        errorField = "startDate";
        if (StringUtils.isNotBlank((String)errorFieldPrefix)) {
            errorField = errorFieldPrefix + errorField;
        }
        if (startDate == null) {
            errorCollection.addError(errorField, this.getText(jiraServiceContext, "worklog.service.error.invalid.worklog.date"));
        }
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        }
        return !errorCollection.hasAnyErrors();
    }

    boolean isValidDuration(String duration, JiraServiceContext jiraServiceContext) {
        if (StringUtils.isNotBlank((String)duration)) {
            Long aLong = null;
            try {
                aLong = this.jiraDurationUtils.parseDuration(duration, jiraServiceContext.getI18nBean().getLocale());
            }
            catch (InvalidDurationException e) {
                return false;
            }
        }
        return true;
    }

    protected long getDurationForFormattedString(String timeSpent, JiraServiceContext jiraServiceContext) {
        try {
            return this.jiraDurationUtils.parseDuration(timeSpent, jiraServiceContext.getI18nBean().getLocale());
        }
        catch (InvalidDurationException e) {
            log.error((Object)"Trying to create/update a worklog with an invalid duration, this should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean isUserInGroup(ApplicationUser user, String groupLevel) {
        return user != null && this.groupManager.isUserInGroup(user.getUsername(), groupLevel);
    }

    protected boolean isUserInRole(Long roleLevel, ApplicationUser user, Issue issue) {
        boolean isUserInRole = false;
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleLevel);
        if (projectRole != null) {
            isUserInRole = this.projectRoleManager.isUserInProjectRole(user, projectRole, issue.getProjectObject());
        }
        return isUserInRole;
    }

    private String getText(JiraServiceContext jiraServiceContext, String key) {
        return jiraServiceContext.getI18nBean().getText(key);
    }

    private String getText(JiraServiceContext jiraServiceContext, String key, String param) {
        return jiraServiceContext.getI18nBean().getText(key, param);
    }
}

