/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.watcher;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatcherService
implements WatcherService {
    private final Logger log = LoggerFactory.getLogger(DefaultWatcherService.class);
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18n;
    private final PermissionManager permissionManager;
    private final WatcherManager watcherManager;
    private final UserManager userManager;

    public DefaultWatcherService(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18n, PermissionManager permissionManager, WatcherManager watcherManager, UserManager userManager) {
        this.watcherManager = watcherManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    public ServiceOutcome<Pair<Integer, List<User>>> getWatchers(Issue issue, @Nullable User remoteUser) throws WatchingDisabledException {
        Pair<Integer, List<String>> watchers = this.getWatcherUsernames(issue, remoteUser);
        return ServiceOutcomeImpl.ok(this.convertUsers(watchers, new UserFromName()));
    }

    public ServiceOutcome<List<User>> addWatcher(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        Pair<Boolean, String> canWatchIssue = this.canWatchIssue(issue, remoteUser, watcher);
        if (((Boolean)canWatchIssue.first()).booleanValue()) {
            this.watcherManager.startWatching(watcher, issue);
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        return ServiceOutcomeImpl.error((String)canWatchIssue.second());
    }

    public WatcherService.BulkWatchResult addWatcherToAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        ArrayList<Issue> successfulIssues = new ArrayList<Issue>();
        ArrayList<Pair> failedIssues = new ArrayList<Pair>();
        for (Issue issue : issues) {
            Pair<Boolean, String> canWatchIssue = this.canWatchIssue(issue, remoteUser, watcher);
            if (((Boolean)canWatchIssue.first()).booleanValue()) {
                successfulIssues.add(issue);
                continue;
            }
            failedIssues.add(Pair.nicePairOf((Object)issue, (Object)canWatchIssue.second()));
        }
        if (!successfulIssues.isEmpty()) {
            this.watcherManager.startWatching(watcher, successfulIssues);
        }
        return new WatcherService.BulkWatchResult(failedIssues);
    }

    public ServiceOutcome<List<User>> removeWatcher(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        Pair<Boolean, String> canUnwatchIssue = this.canUnwatchIssue(issue, remoteUser, watcher);
        if (((Boolean)canUnwatchIssue.first()).booleanValue()) {
            this.watcherManager.stopWatching(watcher, issue);
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        return ServiceOutcomeImpl.error((String)canUnwatchIssue.second());
    }

    public WatcherService.BulkWatchResult removeWatcherFromAll(Collection<Issue> issues, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        ArrayList<Issue> successfulIssues = new ArrayList<Issue>();
        ArrayList<Pair> failedIssues = new ArrayList<Pair>();
        for (Issue issue : issues) {
            Pair<Boolean, String> canUnwatchIssue = this.canUnwatchIssue(issue, remoteUser, watcher);
            if (((Boolean)canUnwatchIssue.first()).booleanValue()) {
                successfulIssues.add(issue);
                continue;
            }
            failedIssues.add(Pair.nicePairOf((Object)issue, (Object)canUnwatchIssue.second()));
        }
        if (!successfulIssues.isEmpty()) {
            this.watcherManager.stopWatching(watcher, successfulIssues);
        }
        return new WatcherService.BulkWatchResult(failedIssues);
    }

    private Pair<Boolean, String> canWatchIssue(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        ApplicationUser appRemoteUser = ApplicationUsers.from((User)remoteUser);
        ApplicationUser appWatcher = ApplicationUsers.from((User)watcher);
        return this.canWatchIssue(issue, appRemoteUser, appWatcher);
    }

    private Pair<Boolean, String> canWatchIssue(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        try {
            if (!this.isWatchingEnabled()) {
                throw new WatchingDisabledException();
            }
            boolean canView = this.permissionManager.hasPermission(10, issue, watcher);
            if (!canView) {
                return Pair.nicePairOf((Object)false, (Object)this.buildAddWatcherCannotViewString(issue, remoteUser, watcher));
            }
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            return Pair.nicePairOf((Object)true, null);
        }
        catch (PermissionException e) {
            return Pair.nicePairOf((Object)false, (Object)this.buildAddWatcherNotAllowedString(issue, remoteUser));
        }
    }

    private Pair<Boolean, String> canUnwatchIssue(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        ApplicationUser appRemoteUser = ApplicationUsers.from((User)remoteUser);
        ApplicationUser appWatcher = ApplicationUsers.from((User)watcher);
        return this.canUnwatchIssue(issue, appRemoteUser, appWatcher);
    }

    private Pair<Boolean, String> canUnwatchIssue(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws WatchingDisabledException {
        try {
            if (!this.isWatchingEnabled()) {
                throw new WatchingDisabledException();
            }
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            return Pair.nicePairOf((Object)true, null);
        }
        catch (PermissionException e) {
            return Pair.nicePairOf((Object)false, (Object)this.buildRemoveUserNotAllowedString(issue, remoteUser));
        }
    }

    @Deprecated
    public boolean canWatchAll(Iterable<Issue> issues, User remoteUser) {
        return this.canUnwatchAll(issues, ApplicationUsers.from((User)remoteUser));
    }

    public boolean canWatchAll(Iterable<Issue> issues, ApplicationUser applicationUser) {
        if (!this.isWatchingEnabled()) {
            return false;
        }
        for (Issue issue : issues) {
            boolean canView = this.permissionManager.hasPermission(10, issue, applicationUser);
            if (canView) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean canUnwatchAll(Iterable<Issue> issues, User remoteUser) {
        return this.isWatchingEnabled();
    }

    public boolean canUnwatchAll(Iterable<Issue> issues, ApplicationUser remoteUser) {
        return this.isWatchingEnabled();
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean hasViewWatcherListPermission(Issue issue, @Nullable User remoteUser) {
        return this.permissionManager.hasPermission(31, issue, remoteUser) || this.canEditWatcherList(issue, remoteUser);
    }

    protected Pair<Integer, List<String>> getWatcherUsernames(Issue issue, User remoteUser) throws WatchingDisabledException {
        if (!this.isWatchingEnabled()) {
            throw new WatchingDisabledException();
        }
        List watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue);
        int watcherCount = watcherNames.size();
        if (!this.hasViewWatcherListPermission(issue, remoteUser)) {
            if (remoteUser == null) {
                watcherNames.clear();
            } else {
                watcherNames.retainAll(Collections.singletonList(remoteUser.getName()));
            }
        }
        this.log.trace("Visible watchers on issue '{}': {}", (Object)issue.getKey(), (Object)watcherNames);
        return Pair.of((Object)watcherCount, (Object)watcherNames);
    }

    protected List<User> getCurrentWatchersFor(Issue issue) {
        List watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue);
        return DefaultWatcherService.newListFrom(watcherNames, new UserFromName());
    }

    protected boolean canEditWatcherList(Issue issue, @Nullable User remoteUser) {
        return this.permissionManager.hasPermission(32, issue, remoteUser);
    }

    protected <T extends User> Pair<Integer, List<T>> convertUsers(Pair<Integer, List<String>> watchers, Function<String, T> function) {
        return Pair.of((Object)watchers.first(), (Object)Lists.newArrayList((Iterable)Lists.transform((List)((List)watchers.second()), function)));
    }

    protected void checkModifyWatchersPermission(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) throws PermissionException, WatchingDisabledException {
        boolean canManage = this.permissionManager.hasPermission(32, issue, remoteUser);
        if (!canManage && !remoteUser.equals(watcher)) {
            throw new PermissionException();
        }
    }

    private String buildAddWatcherNotAllowedString(Issue issue, ApplicationUser remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.add.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    private String buildAddWatcherCannotViewString(Issue issue, ApplicationUser remoteUser, ApplicationUser watcher) {
        return this.i18n.getInstance(remoteUser).getText("watcher.error.user.cant.see.issue", watcher.getName(), issue.getKey());
    }

    private String buildRemoveUserNotAllowedString(Issue issue, ApplicationUser remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.remove.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    static <F, T> List<T> newListFrom(List<F> from, Function<F, T> fn) {
        return Lists.newArrayList((Iterable)Lists.transform(from, fn));
    }

    static class PermissionException
    extends Exception {
        PermissionException() {
        }
    }

    class UserFromName
    implements Function<String, User> {
        UserFromName() {
        }

        public User apply(String username) {
            return DefaultWatcherService.this.userManager.getUserEvenWhenUnknown(username);
        }
    }
}

