/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;

public class ColumnServiceImpl
implements ColumnService {
    private final Function<String, NavigableField> toNavigableField = new Function<String, NavigableField>(){

        public NavigableField apply(String fieldId) {
            return ColumnServiceImpl.this.fieldManager.getNavigableField(fieldId);
        }
    };
    private I18nHelper.BeanFactory beanFactory;
    private ColumnLayoutManager columnLayoutManager;
    private FieldManager fieldManager;
    private GlobalPermissionManager globalPermissionManager;
    private SearchRequestService searchRequestService;

    public ColumnServiceImpl(I18nHelper.BeanFactory beanFactory, ColumnLayoutManager columnLayoutManager, FieldManager fieldManager, GlobalPermissionManager globalPermissionManager, SearchRequestService searchRequestService) {
        this.beanFactory = beanFactory;
        this.columnLayoutManager = columnLayoutManager;
        this.fieldManager = fieldManager;
        this.globalPermissionManager = globalPermissionManager;
        this.searchRequestService = searchRequestService;
    }

    public ServiceOutcome<ColumnLayout> getColumnLayout(ApplicationUser serviceUser, ApplicationUser userWithColumns) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        if (this.permissionForUsersColumns(serviceUser, userWithColumns)) {
            try {
                ColumnLayout editableUserColumnLayout = this.columnLayoutManager.getColumnLayout(userWithColumns.getDirectoryUser());
                return ServiceOutcomeImpl.ok(editableUserColumnLayout);
            }
            catch (ColumnLayoutStorageException e) {
                return this.fail(i18nHelper, (Exception)((Object)e));
            }
        }
        String mesg = i18nHelper.getText("admin.generic.permission");
        return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceOutcome<ColumnLayout> getColumnLayout(ApplicationUser serviceUser, Long filterId) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(serviceUser);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
        ErrorCollection errors = jiraServiceContext.getErrorCollection();
        if (errors.hasAnyErrors()) {
            return new ServiceOutcomeImpl<ColumnLayout>(errors);
        }
        try {
            if (this.columnLayoutManager.hasColumnLayout(filter)) {
                return ServiceOutcomeImpl.ok(this.columnLayoutManager.getColumnLayout(serviceUser.getDirectoryUser(), filter));
            }
            return ServiceOutcomeImpl.ok(null);
        }
        catch (ColumnLayoutStorageException e) {
            return this.fail(this.beanFactory.getInstance(serviceUser), (Exception)((Object)e));
        }
    }

    public ServiceOutcome<ColumnLayout> getDefaultColumnLayout(ApplicationUser serviceUser) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        if (serviceUser != null && this.globalPermissionManager.hasPermission(0, serviceUser)) {
            try {
                EditableDefaultColumnLayout editableDefaultColumnLayout = this.columnLayoutManager.getEditableDefaultColumnLayout();
                return ServiceOutcomeImpl.ok(editableDefaultColumnLayout);
            }
            catch (ColumnLayoutStorageException e) {
                return this.fail(i18nHelper, (Exception)((Object)e));
            }
        }
        String msg = i18nHelper.getText("admin.generic.permission");
        return ServiceOutcomeImpl.error(msg, ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceResult setColumns(ApplicationUser serviceUser, ApplicationUser userWithColumns, List<String> fieldIds) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        if (this.permissionForUsersColumns(serviceUser, userWithColumns)) {
            try {
                EditableUserColumnLayout editableUserColumnLayout = this.columnLayoutManager.getEditableUserColumnLayout(userWithColumns.getDirectoryUser());
                editableUserColumnLayout.setColumns(Lists.transform(fieldIds, this.toNavigableField));
                this.columnLayoutManager.storeEditableUserColumnLayout(editableUserColumnLayout);
                return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
            }
            catch (ColumnLayoutStorageException e) {
                return this.fail(i18nHelper, (Exception)((Object)e));
            }
        }
        String mesg = i18nHelper.getText("admin.generic.permission");
        return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceResult setColumns(ApplicationUser serviceUser, Long filterId, List<String> fieldIds) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(serviceUser);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
        ErrorCollection errors = jiraServiceContext.getErrorCollection();
        if (errors.hasAnyErrors()) {
            return new ServiceOutcomeImpl(errors);
        }
        try {
            if (serviceUser.equals(filter.getOwner())) {
                EditableSearchRequestColumnLayout columnLayout = this.columnLayoutManager.getEditableSearchRequestColumnLayout(serviceUser.getDirectoryUser(), filter);
                columnLayout.setColumns(Lists.transform(fieldIds, this.toNavigableField));
                this.columnLayoutManager.storeEditableSearchRequestColumnLayout(columnLayout);
                return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
            }
            String mesg = i18nHelper.getText("admin.generic.permission");
            return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
        }
        catch (ColumnLayoutStorageException e) {
            return this.fail(i18nHelper, (Exception)((Object)e));
        }
    }

    public ServiceResult setDefaultColumns(ApplicationUser serviceUser, List<String> fieldIds) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        if (serviceUser != null && this.globalPermissionManager.hasPermission(0, serviceUser)) {
            try {
                EditableDefaultColumnLayout editableDefaultColumnLayout = this.columnLayoutManager.getEditableDefaultColumnLayout();
                editableDefaultColumnLayout.setColumns(Lists.transform(fieldIds, this.toNavigableField));
                this.columnLayoutManager.storeEditableDefaultColumnLayout(editableDefaultColumnLayout);
                return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
            }
            catch (ColumnLayoutStorageException e) {
                return this.fail(i18nHelper, (Exception)((Object)e));
            }
        }
        String mesg = i18nHelper.getText("admin.generic.permission");
        return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceResult resetColumns(ApplicationUser serviceUser, ApplicationUser userWithColumns) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        if (this.permissionForUsersColumns(serviceUser, userWithColumns)) {
            try {
                this.columnLayoutManager.restoreUserColumnLayout(userWithColumns.getDirectoryUser());
                return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
            }
            catch (ColumnLayoutStorageException e) {
                return this.fail(i18nHelper, (Exception)((Object)e));
            }
        }
        String mesg = i18nHelper.getText("admin.generic.permission");
        return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceResult resetColumns(ApplicationUser serviceUser, Long filterId) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(serviceUser);
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(serviceUser);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
        ErrorCollection errors = jiraServiceContext.getErrorCollection();
        if (errors.hasAnyErrors()) {
            return new ServiceOutcomeImpl(errors);
        }
        try {
            if (serviceUser.equals(filter.getOwner())) {
                this.columnLayoutManager.restoreSearchRequestColumnLayout(filter);
                return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
            }
            String mesg = i18nHelper.getText("admin.generic.permission");
            return ServiceOutcomeImpl.error(mesg, ErrorCollection.Reason.FORBIDDEN);
        }
        catch (ColumnLayoutStorageException e) {
            return this.fail(i18nHelper, (Exception)((Object)e));
        }
    }

    private boolean permissionForUsersColumns(ApplicationUser serviceUser, ApplicationUser userWithColumns) {
        return serviceUser != null && (serviceUser.equals(userWithColumns) || this.globalPermissionManager.hasPermission(0, serviceUser));
    }

    private ServiceOutcomeImpl<ColumnLayout> fail(I18nHelper i18nHelper, Exception e) {
        return ServiceOutcomeImpl.error(i18nHelper.getText("generic.error", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
    }
}

