/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarServiceImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.avatar.ImageScaler;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class AvatarManagerImpl
implements AvatarManager {
    private static final Logger log = Logger.getLogger(AvatarManagerImpl.class);
    private static final String AVATAR_DIRECTORY = "data/avatars";
    private static final String AVATAR_CLASSPATH_PREFIX = "/avatars/";
    private AvatarStore store;
    private JiraHome jiraHome;
    private ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private ImageScaler scaler;

    public AvatarManagerImpl(AvatarStore store, JiraHome jiraHome, ApplicationProperties applicationProperties, PermissionManager permissionManager) {
        this.store = store;
        this.jiraHome = jiraHome;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.scaler = new ImageScaler();
    }

    public Avatar getById(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        return this.store.getById(avatarId);
    }

    public boolean delete(Long avatarId) {
        return this.delete(avatarId, true);
    }

    public boolean delete(Long avatarId, boolean alsoDeleteAvatarFile) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        Avatar avatar = this.store.getById(avatarId);
        if (avatar != null) {
            if (alsoDeleteAvatarFile) {
                for (AvatarManager.ImageSize size : AvatarManager.ImageSize.values()) {
                    this.deleteFile(this.getAvatarFile(avatar, size.getFilenameFlag()));
                }
            }
            return this.store.delete(avatarId);
        }
        return false;
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        this.store.update(avatar);
    }

    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        return this.store.create(avatar);
    }

    public Avatar create(Avatar avatar, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"avatar", (Object)avatar);
        if (avatar.isSystemAvatar()) {
            throw new IllegalArgumentException("System avatars cannot be created with custom image data");
        }
        Assertions.notNull((String)"imageData", (Object)imageData);
        File avatarFile = null;
        try {
            Avatar created = this.create(avatar);
            File largeAvatarFile = avatarFile = this.processImage(created, imageData, croppingSelection, AvatarManager.ImageSize.largest());
            for (AvatarManager.ImageSize size : AvatarManager.ImageSize.values()) {
                if (AvatarManager.ImageSize.largest().equals((Object)size)) continue;
                avatarFile = this.processImage(created, FileUtils.openInputStream((File)largeAvatarFile), null, size);
            }
            return created;
        }
        catch (RuntimeException failedCreate) {
            this.handleCreationFailure(avatarFile);
            throw failedCreate;
        }
    }

    public Avatar create(String fileName, String contentType, Project owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"avatar", (Object)contentType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        return this.create(AvatarImpl.createCustomAvatar(fileName, contentType, owner), imageData, croppingSelection);
    }

    public Avatar create(String fileName, String contentType, ApplicationUser owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"avatar", (Object)contentType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        return this.create(AvatarImpl.createCustomAvatar(fileName, contentType, owner), imageData, croppingSelection);
    }

    private void handleCreationFailure(File avatarFile) {
        try {
            if (avatarFile != null && avatarFile.exists() && !avatarFile.delete()) {
                log.warn((Object)("Created avatar file '" + avatarFile + "' but then failed to store to db. Failed to delete the file!"));
            }
        }
        catch (RuntimeException failedDeleteFile) {
            log.warn((Object)("Created avatar file '" + avatarFile + "' but then failed to store to db. Failed to delete the file!"), (Throwable)failedDeleteFile);
        }
    }

    File processImage(Avatar created, InputStream imageData, Selection croppingSelection, AvatarManager.ImageSize size) throws IOException {
        RenderedImage image = this.scaler.getSelectedImageData(ImageIO.read(imageData), croppingSelection, size.getPixels());
        File file = this.createAvatarFile(created, size.getFilenameFlag());
        ImageIO.write(image, AVATAR_IMAGE_FORMAT_FULL.getName(), file);
        return file;
    }

    File createAvatarFile(Avatar avatar, String flag) throws IOException {
        File base = this.getAvatarBaseDirectory();
        this.createDirectoryIfAbsent(base);
        return new File(base, avatar.getId() + "_" + flag + avatar.getFileName());
    }

    public File getAvatarBaseDirectory() {
        return new File(this.jiraHome.getHome(), AVATAR_DIRECTORY);
    }

    private void createDirectoryIfAbsent(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Avatars directory is absent and I'm unable to create it. '" + dir.getAbsolutePath() + "'");
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Avatars directory cannot be created due to an existing file. '" + dir.getAbsolutePath() + "'");
        }
    }

    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        return Lists.newArrayList((Iterable)Collections2.filter(this.store.getAllSystemAvatars(type), this.isUsableAvatarPredicate(type)));
    }

    private Predicate<? super Avatar> isUsableAvatarPredicate(final Avatar.Type type) {
        return new Predicate<Avatar>(){

            public boolean apply(@Nullable Avatar input) {
                if (null == input) {
                    return false;
                }
                if (Avatar.Type.PROJECT.equals((Object)type)) {
                    return !Avatar.demotedSystemProjectAvatars.contains(input.getFileName());
                }
                return true;
            }
        };
    }

    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        return this.store.getCustomAvatarsForOwner(type, ownerId);
    }

    public boolean isAvatarOwner(Avatar avatar, String ownerId) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"owner", (Object)ownerId);
        return this.getCustomAvatarsForOwner(avatar.getAvatarType(), ownerId).contains(avatar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAvatarData(Avatar avatar, Consumer<InputStream> dataAccessor, AvatarManager.ImageSize size) throws IOException {
        InputStream data;
        if (avatar.isSystemAvatar()) {
            String path = AVATAR_CLASSPATH_PREFIX + size.getFilenameFlag() + avatar.getFileName();
            data = this.getClasspathStream(path);
            if (data == null) {
                log.error((Object)("System Avatar not found at the following resource path: " + path));
                throw new IOException("File not found");
            }
        } else {
            File file = this.getOrGenerateAvatarFile(avatar, size);
            data = new FileInputStream(file);
        }
        try {
            dataAccessor.consume((Object)data);
        }
        finally {
            ((InputStream)data).close();
        }
    }

    private File getOrGenerateAvatarFile(Avatar avatar, AvatarManager.ImageSize size) throws IOException {
        File file = this.getAvatarFile(avatar, size.getFilenameFlag());
        if (!file.exists()) {
            File largeFile = this.getOrGenerateLargerAvatarFile(avatar, size);
            return this.processImage(avatar, FileUtils.openInputStream((File)largeFile), null, size);
        }
        return file;
    }

    private File getOrGenerateLargerAvatarFile(Avatar avatar, AvatarManager.ImageSize sizeToGet) {
        File largestFileOnHand = null;
        File newFile = null;
        AvatarManager.ImageSize availableSize = null;
        for (Avatar.Size size : Avatar.Size.inPixelOrder()) {
            AvatarManager.ImageSize imageSize = AvatarManager.ImageSize.fromSize((Avatar.Size)size);
            File avatarFile = this.getAvatarFile(avatar, imageSize.getFilenameFlag());
            if (avatarFile.exists()) {
                largestFileOnHand = avatarFile;
                availableSize = imageSize;
            }
            if (null == availableSize || availableSize.getPixels() <= sizeToGet.getPixels()) continue;
            break;
        }
        try {
            newFile = this.processImage(avatar, FileUtils.openInputStream(largestFileOnHand), null, sizeToGet);
        }
        catch (IOException ioe) {
            log.error((Object)String.format("Failed to generate new image for '%s' from image '%s'", sizeToGet, largestFileOnHand), (Throwable)ioe);
        }
        return newFile != null ? newFile : (largestFileOnHand != null ? largestFileOnHand : null);
    }

    InputStream getClasspathStream(String path) {
        return AvatarManagerImpl.class.getResourceAsStream(path);
    }

    File getAvatarFile(Avatar avatar, String sizeFlag) {
        File base = this.getAvatarBaseDirectory();
        return new File(base, avatar.getId() + "_" + sizeFlag + avatar.getFileName());
    }

    public void readAvatarData(Avatar avatar, AvatarManager.ImageSize size, Consumer<InputStream> dataAccessor) throws IOException {
        this.processAvatarData(avatar, dataAccessor, size);
    }

    public Long getDefaultAvatarId(Avatar.Type ofType) {
        Assertions.stateTrue((String)"Can only handle Project & User avatars at this time.", (Avatar.Type.PROJECT.equals((Object)ofType) || Avatar.Type.USER.equals((Object)ofType) ? 1 : 0) != 0);
        String defaultAvatarId = null;
        if (Avatar.Type.PROJECT.equals((Object)ofType)) {
            defaultAvatarId = this.applicationProperties.getString("jira.avatar.default.id");
        }
        if (Avatar.Type.USER.equals((Object)ofType)) {
            defaultAvatarId = this.applicationProperties.getString("jira.avatar.user.default.id");
        }
        return defaultAvatarId != null ? Long.valueOf(defaultAvatarId) : null;
    }

    public Long getAnonymousAvatarId() {
        String avatarId = this.applicationProperties.getString("jira.avatar.user.anonymous.id");
        return avatarId != null ? Long.valueOf(avatarId) : null;
    }

    public boolean hasPermissionToView(User remoteUser, Avatar.Type type, String ownerId) {
        if (ownerId == null) {
            return type != Avatar.Type.PROJECT;
        }
        try {
            return type == Avatar.Type.PROJECT ? this.hasPermissionToView(AvatarServiceImpl.fromStaleUser(remoteUser), this.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(ownerId)))) : this.hasPermissionToView(AvatarServiceImpl.fromStaleUser(remoteUser), ApplicationUsers.byKey((String)ownerId));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, Project project) {
        if (project == null) {
            return false;
        }
        boolean isAdmin = this.permissionManager.hasPermission(0, remoteUser);
        boolean isProjectAdmin = this.permissionManager.hasPermission(23, project, remoteUser);
        boolean hasBrowseProject = this.permissionManager.hasPermission(10, project, remoteUser);
        return isAdmin || isProjectAdmin || hasBrowseProject;
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, ApplicationUser user) {
        boolean remoteUserIsSame = user == null ? true : remoteUser != null && user.equals(remoteUser);
        return remoteUserIsSame || this.permissionManager.hasPermission(1, remoteUser);
    }

    public boolean hasPermissionToEdit(User remoteUser, Avatar.Type type, String ownerId) {
        if (ownerId == null) {
            return false;
        }
        try {
            if (type == Avatar.Type.PROJECT) {
                return this.hasPermissionToEdit(AvatarServiceImpl.fromStaleUser(remoteUser), this.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(ownerId))));
            }
            return this.hasPermissionToEdit(AvatarServiceImpl.fromStaleUser(remoteUser), ApplicationUsers.byKey((String)ownerId));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, ApplicationUser owner) {
        if (Users.isAnonymous((ApplicationUser)remoteUser) || owner == null) {
            return false;
        }
        boolean isAdmin = this.permissionManager.hasPermission(0, remoteUser);
        boolean isOwner = remoteUser.getKey().equals(owner.getKey());
        return isAdmin || isOwner;
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, Project owner) {
        boolean isAdmin = this.permissionManager.hasPermission(0, remoteUser);
        if (owner == null) {
            return false;
        }
        boolean isProjectAdmin = this.permissionManager.hasPermission(23, owner, remoteUser);
        return isAdmin || isProjectAdmin;
    }

    ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }
}

