/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowStateCheck
extends CheckImpl {
    public WorkflowStateCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.state.check.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        try {
            Map map = this.getWorkflowIdToKeyMap();
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                Long workflowId = (Long)entry.getKey();
                String issueKey = (String)entry.getValue();
                List workflowEntries = this.ofBizDelegator.findByAnd("OSWorkflowEntry", EasyMap.build((Object)"id", (Object)workflowId));
                for (GenericValue workflowEntry : workflowEntries) {
                    String message;
                    if (workflowEntry.getInteger("state") != null && !"0".equals(workflowEntry.getInteger("state").toString())) continue;
                    if (correct) {
                        workflowEntry.set("state", (Object)new Integer(1));
                        workflowEntry.store();
                        message = this.getI18NBean().getText("admin.integrity.check.workflow.state.check.message", issueKey, workflowEntry.getLong("id").toString());
                        results.add(new CheckAmendment(2, message, "JRA-4241"));
                        continue;
                    }
                    message = this.getI18NBean().getText("admin.integrity.check.workflow.state.check.preview", issueKey, workflowEntry.getLong("id").toString());
                    results.add(new CheckAmendment(2, message, "JRA-4241"));
                }
            }
        }
        catch (GenericEntityException e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getWorkflowIdToKeyMap() {
        HashMap<Long, String> map = new HashMap<Long, String>();
        OfBizListIterator listIterator = null;
        try {
            listIterator = this.ofBizDelegator.findListIteratorByCondition("Issue", null, null, (Collection)EasyList.build((Object)"workflowId", (Object)"key"), null, null);
            GenericValue issue = listIterator.next();
            while (issue != null) {
                map.put(issue.getLong("workflowId"), issue.getString("key"));
                issue = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return map;
    }
}

