/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler;

import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.scheduler.AtlassianSimpleTrigger;
import com.atlassian.scheduler.NoOpQuartzJob;
import com.atlassian.util.concurrent.LazyReference;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;

public class OfBizJobStore
implements JobStore {
    private static final Logger log = Logger.getLogger(OfBizJobStore.class);
    private final RAMJobStore memoryStore = new RAMJobStore();
    private boolean memoryStoreInited = false;
    private LazyReference<String> delegatorNameRef;
    public static final String STATE_WAITING = "WAITING";
    public static final String STATE_ACQUIRED = "ACQUIRED";
    public static final String STATE_EXECUTING = "EXECUTING";
    public static final String STATE_COMPLETE = "COMPLETE";
    public static final String STATE_BLOCKED = "BLOCKED";
    public static final String TTYPE_SIMPLE = "SIMPLE";
    public static final String TTYPE_CRON = "CRON";

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.memoryStore.initialize(loadHelper, signaler);
        this.delegatorNameRef = new LazyReference<String>(){

            protected String create() throws Exception {
                return DefaultOfBizConnectionFactory.getInstance().getDelegatorName();
            }
        };
    }

    private void initialise(SchedulingContext ctxt) throws JobPersistenceException {
        Timestamp now = new Timestamp(new Date().getTime());
        this.memoryStoreInited = true;
        try {
            List jobDetailGVs = this.getDelegator().findAll("QRTZJobDetails");
            for (int j = 0; j < jobDetailGVs.size(); ++j) {
                GenericValue jobDetailGV = (GenericValue)jobDetailGVs.get(j);
                JobDetail jobDetail = this.createJobDetail(jobDetailGV);
                this.memoryStore.storeJob(ctxt, jobDetail, true);
                List triggerGVs = jobDetailGV.getRelated("ChildQRTZTriggers");
                for (int i = 0; i < triggerGVs.size(); ++i) {
                    GenericValue triggerGV = (GenericValue)triggerGVs.get(i);
                    if (triggerGV.getString("triggerType").equals(TTYPE_SIMPLE)) {
                        this.loadSimpleTrigger(ctxt, now, jobDetail, triggerGV);
                        continue;
                    }
                    if (triggerGV.getString("triggerType").equals(TTYPE_CRON)) {
                        this.loadCronTrigger(ctxt, jobDetail, triggerGV);
                        continue;
                    }
                    throw new JobPersistenceException("Unsupported trigger type: '" + triggerGV.getString("triggerType") + "'");
                }
            }
        }
        catch (GenericEntityException e) {
            throw new JobPersistenceException("Error retrieving Job details", (Exception)((Object)e));
        }
    }

    private JobDetail createJobDetail(GenericValue jobDetailGV) {
        String jobName = jobDetailGV.getString("jobName");
        String jobGroup = jobDetailGV.getString("jobGroup");
        String jobClassName = jobDetailGV.getString("className");
        boolean isDurable = Boolean.valueOf(jobDetailGV.getString("isDurable"));
        boolean requestRecovery = Boolean.valueOf(jobDetailGV.getString("requestsRecovery"));
        Class jobClass = this.loadJobClassResiliently(jobName, jobClassName);
        return new JobDetail(jobName, jobGroup, jobClass, false, isDurable, requestRecovery);
    }

    private Class loadJobClassResiliently(String jobName, String jobClassName) {
        Class<NoOpQuartzJob> fallbackClass = NoOpQuartzJob.class;
        try {
            Class<?> jobClass = Class.forName(jobClassName);
            if (Job.class.isAssignableFrom(jobClass)) {
                return jobClass;
            }
            log.error((Object)("The Quartz Job class '" + jobClassName + "' does not implement org.quartz.Job!"));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The Quartz Job class '" + jobClassName + "' cannot be loaded"));
            log.error((Object)("The Quartz Job configuration for '" + jobName + "' is invalid!  This can be caused by Plugin JARS no longer being available on the class path."));
        }
        log.error((Object)("A NoOp Job class has been returned and hence '" + jobName + "' will not do anything until fixed."));
        return fallbackClass;
    }

    private void loadCronTrigger(SchedulingContext ctxt, JobDetail jobDetail, GenericValue triggerGV) throws GenericEntityException, JobPersistenceException {
        GenericValue cronTriggerGV = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZCronTriggers", UtilMisc.toMap((String)"trigger", (Object)triggerGV.getLong("id"))));
        if (cronTriggerGV != null) {
            String cronExpression = cronTriggerGV.getString("cronExpression");
            try {
                CronTrigger trigger = new CronTrigger(triggerGV.getString("triggerName"), triggerGV.getString("triggerGroup"), jobDetail.getName(), jobDetail.getGroup(), (Date)triggerGV.getTimestamp("startTime"), (Date)triggerGV.getTimestamp("endTime"), cronExpression);
                trigger.setNextFireTime((Date)triggerGV.getTimestamp("nextFire"));
                this.memoryStore.storeTrigger(ctxt, (Trigger)trigger, true);
            }
            catch (ParseException e) {
                log.error((Object)("Could not read cron trigger with cron spec '" + cronExpression + "'"), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Could not read cron trigger with cron spec '" + cronExpression + "'"), (Throwable)e);
            }
        } else {
            log.warn((Object)("Could not find cron trigger with trigger id " + triggerGV.getLong("id") + "."));
        }
    }

    private void loadSimpleTrigger(SchedulingContext ctxt, Timestamp now, JobDetail jobDetail, GenericValue triggerGV) throws GenericEntityException, JobPersistenceException {
        GenericValue simpleTriggerGV = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZSimpleTriggers", UtilMisc.toMap((String)"trigger", (Object)triggerGV.getLong("id"))));
        if (simpleTriggerGV != null) {
            AtlassianSimpleTrigger trigger = new AtlassianSimpleTrigger(triggerGV.getString("triggerName"), triggerGV.getString("triggerGroup"), jobDetail.getName(), jobDetail.getGroup(), (Date)triggerGV.getTimestamp("startTime"), (Date)triggerGV.getTimestamp("endTime"), simpleTriggerGV.getInteger("repeatCount").intValue(), simpleTriggerGV.getLong("repeatInterval").longValue());
            trigger.setNextFireTime((Date)triggerGV.getTimestamp("nextFire"));
            if (trigger.getNextFireTime() == null || trigger.getNextFireTime().getTime() < now.getTime()) {
                trigger.setNextFireTime((Date)now);
            }
            this.memoryStore.storeTrigger(ctxt, (Trigger)trigger, true);
        } else {
            log.warn((Object)("Could not find simple trigger with trigger id " + triggerGV.getLong("id") + "."));
        }
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public void shutdown() {
        this.memoryStore.shutdown();
    }

    public boolean supportsPersistence() {
        return true;
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeJob(ctxt, newJob);
        this.storeTrigger(ctxt, newTrigger);
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeJob(ctxt, newJob, false);
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        block9: {
            if (!this.memoryStoreInited) {
                this.initialise(ctxt);
            }
            if (!newJob.isDurable()) {
                throw new IllegalArgumentException("Non durable jobs are currently not supported: " + newJob);
            }
            if (newJob.requestsRecovery()) {
                throw new IllegalArgumentException("Requests Recovery jobs are currently not supported: " + newJob);
            }
            this.memoryStore.storeJob(ctxt, newJob, replaceExisting);
            if (!newJob.isVolatile()) {
                try {
                    GenericValue jobDetail = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZJobDetails", UtilMisc.toMap((String)"jobName", (Object)newJob.getName(), (String)"jobGroup", (Object)newJob.getGroup())));
                    Map fields = UtilMisc.toMap((String)"jobName", (Object)newJob.getName(), (String)"jobGroup", (Object)newJob.getGroup(), (String)"className", (Object)newJob.getJobClass().getName(), (String)"isDurable", (Object)Boolean.toString(newJob.isDurable()), (String)"isStateful", (Object)Boolean.toString(newJob.isStateful()), (String)"requestsRecovery", (Object)Boolean.toString(newJob.requestsRecovery()));
                    if (newJob.getJobDataMap() != null && !newJob.getJobDataMap().isEmpty()) {
                        throw new UnsupportedOperationException("Atlassian Scheduler does not support the persistence of a Job Data Map");
                    }
                    if (jobDetail == null) {
                        EntityUtils.createValue("QRTZJobDetails", fields);
                        break block9;
                    }
                    if (replaceExisting) {
                        jobDetail.setFields(fields);
                        jobDetail.store();
                        break block9;
                    }
                    throw new ObjectAlreadyExistsException(newJob.getName() + " already exists.\n" + ExceptionUtils.getStackTrace((Throwable)new Throwable()));
                }
                catch (GenericEntityException e) {
                    throw new JobPersistenceException("Error storing Job", (Exception)((Object)e));
                }
            }
        }
    }

    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        try {
            Trigger[] triggers;
            for (Trigger trigger : triggers = this.getTriggersForJob(ctxt, jobName, groupName)) {
                this.removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
            }
            GenericValue jobDetail = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZJobDetails", UtilMisc.toMap((String)"jobName", (Object)jobName, (String)"jobGroup", (Object)groupName)));
            if (jobDetail != null) {
                jobDetail.remove();
            }
            return this.memoryStore.removeJob(ctxt, jobName, groupName);
        }
        catch (GenericEntityException e) {
            throw new JobPersistenceException("Could not remove job: " + jobName + " in group: " + groupName, (Exception)((Object)e));
        }
    }

    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        return this.memoryStore.retrieveJob(ctxt, jobName, groupName);
    }

    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeTrigger(ctxt, newTrigger, false);
    }

    public synchronized void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        this.memoryStore.storeTrigger(ctxt, newTrigger, replaceExisting);
        this.persistTrigger(newTrigger, replaceExisting);
    }

    private synchronized void persistTrigger(Trigger newTrigger, boolean replaceExisting) throws JobPersistenceException, ObjectAlreadyExistsException {
        block13: {
            if (!newTrigger.isVolatile()) {
                try {
                    String subEntity;
                    Map subFields;
                    GenericValue trigger = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZTriggers", UtilMisc.toMap((String)"triggerName", (Object)newTrigger.getName(), (String)"triggerGroup", (Object)newTrigger.getGroup())));
                    GenericValue jobDetail = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZJobDetails", UtilMisc.toMap((String)"jobName", (Object)newTrigger.getJobName(), (String)"jobGroup", (Object)newTrigger.getJobGroup())));
                    Map fields = UtilMisc.toMap((String)"triggerName", (Object)newTrigger.getName(), (String)"triggerGroup", (Object)newTrigger.getGroup(), (String)"job", (Object)jobDetail.getLong("id"), (String)"triggerState", (Object)STATE_WAITING);
                    if (newTrigger.getNextFireTime() != null) {
                        fields.put("nextFire", new Timestamp(newTrigger.getNextFireTime().getTime()));
                    }
                    if (newTrigger instanceof SimpleTrigger) {
                        fields.put("triggerType", TTYPE_SIMPLE);
                        SimpleTrigger simpleTrig = (SimpleTrigger)newTrigger;
                        subFields = UtilMisc.toMap((String)"repeatCount", (Object)new Integer(simpleTrig.getRepeatCount()), (String)"repeatInterval", (Object)new Long(simpleTrig.getRepeatInterval()), (String)"timesTriggered", (Object)new Integer(simpleTrig.getTimesTriggered()));
                        subEntity = "QRTZSimpleTriggers";
                    } else if (newTrigger instanceof CronTrigger) {
                        fields.put("triggerType", TTYPE_CRON);
                        CronTrigger cronTrigger = (CronTrigger)newTrigger;
                        subFields = UtilMisc.toMap((String)"cronExpression", (Object)cronTrigger.getCronExpression());
                        subEntity = "QRTZCronTriggers";
                    } else {
                        throw new JobPersistenceException("Unsupported trigger type: '" + newTrigger.getClass().getName() + "'");
                    }
                    if (newTrigger.getStartTime() != null) {
                        fields.put("startTime", new Timestamp(newTrigger.getStartTime().getTime()));
                    }
                    if (newTrigger.getEndTime() != null) {
                        fields.put("endTime", new Timestamp(newTrigger.getEndTime().getTime()));
                    }
                    fields.put("calendarName", newTrigger.getCalendarName());
                    fields.put("misfireInstr", new Integer(newTrigger.getMisfireInstruction()));
                    if (newTrigger.getJobDataMap() != null && !newTrigger.getJobDataMap().isEmpty()) {
                        throw new UnsupportedOperationException("Atlassian Scheduler does not support the persistence of a Job Data Map");
                    }
                    if (trigger == null) {
                        GenericValue createdTrigger = EntityUtils.createValue("QRTZTriggers", fields);
                        subFields.put("trigger", createdTrigger.getLong("id"));
                        EntityUtils.createValue(subEntity, subFields);
                        break block13;
                    }
                    if (replaceExisting) {
                        GenericValue subTrigger = EntityUtil.getOnly((List)this.getDelegator().findByAnd(subEntity, UtilMisc.toMap((String)"trigger", (Object)trigger.getLong("id"))));
                        trigger.setFields(fields);
                        subTrigger.setFields(subFields);
                        trigger.store();
                        subTrigger.store();
                        break block13;
                    }
                    throw new ObjectAlreadyExistsException(newTrigger.getName() + " already exists");
                }
                catch (GenericEntityException e) {
                    throw new JobPersistenceException("Error storing Job", (Exception)((Object)e));
                }
            }
        }
    }

    public synchronized boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        try {
            GenericValue trigger = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZTriggers", UtilMisc.toMap((String)"triggerName", (Object)triggerName, (String)"triggerGroup", (Object)groupName)));
            if (trigger != null) {
                if (trigger.getString("triggerType").equals(TTYPE_SIMPLE)) {
                    GenericValue simpleTriggerGV = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZSimpleTriggers", UtilMisc.toMap((String)"trigger", (Object)trigger.getLong("id"))));
                    if (simpleTriggerGV != null) {
                        simpleTriggerGV.remove();
                    }
                } else if (trigger.getString("triggerType").equals(TTYPE_CRON)) {
                    GenericValue cronTriggerGV = EntityUtil.getOnly((List)this.getDelegator().findByAnd("QRTZCronTriggers", UtilMisc.toMap((String)"trigger", (Object)trigger.getLong("id"))));
                    if (cronTriggerGV != null) {
                        cronTriggerGV.remove();
                    }
                } else {
                    throw new JobPersistenceException("Unsupported trigger type: '" + trigger.getClass().getName() + "'");
                }
                trigger.remove();
            }
            return this.memoryStore.removeTrigger(ctxt, triggerName, groupName);
        }
        catch (GenericEntityException e) {
            throw new JobPersistenceException("Could not retrieve trigger: " + triggerName + " in group: " + groupName, (Exception)((Object)e));
        }
    }

    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.retrieveTrigger(ctxt, triggerName, groupName);
    }

    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String triggerGroup) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getTriggerState(ctxt, triggerName, triggerGroup);
    }

    public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar) throws ObjectAlreadyExistsException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        return new BaseCalendar();
    }

    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getNumberOfJobs(ctxt);
    }

    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getNumberOfTriggers(ctxt);
    }

    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getJobNames(ctxt, groupName);
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getTriggerNames(ctxt, groupName);
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getJobGroupNames(ctxt);
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getTriggerGroupNames(ctxt);
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Trigger[] getTriggersBeforeDate(SchedulingContext ctxt, Date fireBeforeDate) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Trigger[] getTriggersAfterDate(SchedulingContext ctxt, Date fireAfterDate) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Trigger[] getTriggersDuringDateRange(SchedulingContext ctxt, Date fireAfterDate, Date fireBeforeDate) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.getTriggersForJob(ctxt, jobName, groupName);
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        return this.memoryStore.acquireNextTrigger(ctxt, noLaterThan);
    }

    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        this.memoryStore.releaseAcquiredTrigger(ctxt, trigger);
    }

    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        TriggerFiredBundle toReturn = this.memoryStore.triggerFired(ctxt, trigger);
        this.persistTrigger(trigger, true);
        return toReturn;
    }

    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        if (!this.memoryStoreInited) {
            this.initialise(ctxt);
        }
        this.memoryStore.triggeredJobComplete(ctxt, trigger, jobDetail, triggerInstCode);
    }

    private GenericDelegator getDelegator() {
        return GenericDelegator.getGenericDelegator((String)((String)this.delegatorNameRef.get()));
    }
}

