/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.user.preferences.DefaultPreferences;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerConfigurationHandler;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class OFBizMailServerManager
extends AbstractMailServerManager {
    private DefaultPreferences defaultPreferences = new DefaultPreferences();

    public MailServer getMailServer(Long id) throws MailException {
        try {
            GenericValue gv = CoreFactory.getGenericDelegator().findByPrimaryKeyCache("MailServer", UtilMisc.toMap((String)"id", (Object)id));
            if (gv == null) {
                return null;
            }
            return this.constructMailServer(gv);
        }
        catch (GenericEntityException e) {
            throw new MailException((Throwable)e);
        }
    }

    public MailServer getMailServer(String name) throws MailException {
        try {
            GenericValue gv = EntityUtil.getOnly((List)CoreFactory.getGenericDelegator().findByAndCache("MailServer", UtilMisc.toMap((String)"name", (Object)name)));
            if (gv == null) {
                return null;
            }
            return this.constructMailServer(gv);
        }
        catch (GenericEntityException e) {
            throw new MailException((Throwable)e);
        }
    }

    private List<MailServer> getAllServers() {
        try {
            List mailServerGVs = CoreFactory.getGenericDelegator().findAllCache("MailServer", UtilMisc.toList((Object)"id asc"));
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)mailServerGVs, (Function)new Function<GenericValue, MailServer>(){

                public MailServer apply(GenericValue from) {
                    return OFBizMailServerManager.this.constructMailServer(from);
                }
            }));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getServerNames() throws MailException {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getAllServers(), (Function)new Function<MailServer, String>(){

            public String apply(MailServer from) {
                return from.getName();
            }
        }));
    }

    public List<SMTPMailServer> getSmtpMailServers() {
        return this.getMailServersByType(SMTPMailServer.class);
    }

    public List<PopMailServer> getPopMailServers() {
        return this.getMailServersByType(PopMailServer.class);
    }

    public Long create(MailServer mailServer) throws MailException {
        try {
            GenericValue storedMailServer = EntityUtils.createValue("MailServer", this.getMapFromColumns(mailServer));
            return storedMailServer.getLong("id");
        }
        catch (DataAccessException e) {
            throw new MailException((Throwable)e);
        }
    }

    public void update(MailServer mailServer) throws MailException {
        try {
            GenericValue storedMailServer = this.getMailServerGV(mailServer.getId());
            storedMailServer.setFields(this.getMapFromColumns(mailServer));
            storedMailServer.store();
        }
        catch (GenericEntityException e) {
            throw new MailException((Throwable)e);
        }
    }

    public void delete(Long mailServerId) throws MailException {
        try {
            GenericValue storedMailServer = this.getMailServerGV(mailServerId);
            storedMailServer.remove();
        }
        catch (GenericEntityException e) {
            throw new MailException((Throwable)e);
        }
    }

    @Nullable
    public SMTPMailServer getDefaultSMTPMailServer() {
        try {
            SMTPMailServer smtps = (SMTPMailServer)this.getMailServer(this.defaultPreferences.getString("DefaultSmtpServer"));
            if (smtps != null) {
                return smtps;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        List<SMTPMailServer> smtpMailServers = this.getSmtpMailServers();
        if (smtpMailServers == null || smtpMailServers.size() == 0) {
            return null;
        }
        return smtpMailServers.get(0);
    }

    @Nullable
    public PopMailServer getDefaultPopMailServer() {
        try {
            PopMailServer pops = (PopMailServer)this.getMailServer(this.defaultPreferences.getString("DefaultPopServer"));
            if (pops != null) {
                return pops;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        List<PopMailServer> popMailServers = this.getPopMailServers();
        if (popMailServers == null || popMailServers.size() == 0) {
            return null;
        }
        return popMailServers.get(0);
    }

    protected <T extends MailServer> List<T> getMailServersByType(Class<T> serverType) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllServers(), serverType));
    }

    protected GenericValue getMailServerGV(Long id) throws MailException {
        try {
            return CoreFactory.getGenericDelegator().findByPrimaryKeyCache("MailServer", UtilMisc.toMap((String)"id", (Object)id));
        }
        catch (GenericEntityException e) {
            throw new MailException((Throwable)e);
        }
    }

    protected MailServer constructMailServer(GenericValue gv) {
        MailServer mailServer = this.constructMailServerImpl(gv);
        MailServerConfigurationHandler mailServerConfigurationHandler = this.getMailServerConfigurationHandler();
        if (mailServerConfigurationHandler != null) {
            mailServerConfigurationHandler.configureMailServer(mailServer);
        }
        return mailServer;
    }

    private MailServer constructMailServerImpl(GenericValue gv) {
        long timeout;
        String protocol;
        String serverType = gv.getString("type");
        String port = gv.getString("smtpPort");
        if (port == null) {
            port = this.getDefaultPort(serverType);
        }
        MailProtocol mailProtocol = (protocol = gv.getString("protocol")) != null ? MailProtocol.getMailProtocol((String)protocol) : this.getDefaultProtocol(serverType);
        long l = timeout = gv.getLong("timeout") == null ? 10000L : gv.getLong("timeout");
        if (SERVER_TYPES[0].equals(serverType)) {
            return new PopMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), mailProtocol, gv.getString("servername"), port, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
        }
        if (SERVER_TYPES[1].equals(serverType)) {
            boolean isTlsRequired = Boolean.valueOf(gv.getString("istlsrequired"));
            if (TextUtils.stringSet((String)gv.getString("servername"))) {
                return new SMTPMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), false, mailProtocol, gv.getString("servername"), port, isTlsRequired, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
            }
            return new SMTPMailServerImpl(gv.getLong("id"), gv.getString("name"), gv.getString("description"), gv.getString("from"), gv.getString("prefix"), true, mailProtocol, gv.getString("jndilocation"), port, isTlsRequired, gv.getString("username"), gv.getString("password"), timeout, gv.getString("socksHost"), gv.getString("socksPort"));
        }
        return null;
    }

    private MailProtocol getDefaultProtocol(String serverType) {
        return SERVER_TYPES[0].equals(serverType) ? MailConstants.DEFAULT_POP_PROTOCOL : MailConstants.DEFAULT_SMTP_PROTOCOL;
    }

    private String getDefaultPort(String serverType) {
        return SERVER_TYPES[0].equals(serverType) ? "110" : "25";
    }

    protected Map<String, Object> getMapFromColumns(MailServer mailServer) throws MailException {
        HashMap columns = Maps.newHashMap();
        columns.put("name", mailServer.getName());
        columns.put("description", mailServer.getDescription());
        columns.put("username", mailServer.getUsername());
        columns.put("password", mailServer.getPassword());
        columns.put("type", mailServer.getType());
        columns.put("servername", mailServer.getHostname());
        columns.put("smtpPort", mailServer.getPort());
        columns.put("protocol", mailServer.getMailProtocol().getProtocol());
        columns.put("timeout", mailServer.getTimeout());
        columns.put("socksHost", mailServer.getSocksHost());
        columns.put("socksPort", mailServer.getSocksPort());
        if (!SERVER_TYPES[0].equals(mailServer.getType())) {
            if (SERVER_TYPES[1].equals(mailServer.getType())) {
                SMTPMailServer smtp = (SMTPMailServer)mailServer;
                columns.put("from", smtp.getDefaultFrom());
                columns.put("prefix", smtp.getPrefix());
                columns.put("istlsrequired", Boolean.toString(smtp.isTlsRequired()));
                if (smtp.isSessionServer()) {
                    columns.put("jndilocation", smtp.getJndiLocation());
                } else {
                    columns.put("servername", smtp.getHostname());
                }
            } else {
                throw new MailException("The Type of Mail Server is not recognised");
            }
        }
        return columns;
    }
}

