/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import java.util.List;
import javax.annotation.Nonnull;

public class DefaultWorkflowSchemeMigrationTaskAccessor
implements WorkflowSchemeMigrationTaskAccessor {
    private final TaskManager taskManager;
    private final WorkflowSchemeManager manager;

    public DefaultWorkflowSchemeMigrationTaskAccessor(TaskManager taskManager, WorkflowSchemeManager manager) {
        this.taskManager = taskManager;
        this.manager = manager;
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActive(@Nonnull Project project) {
        return this.taskManager.getLiveTask(new EnterpriseWorkflowTaskContext(project));
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActive(@Nonnull DraftWorkflowScheme scheme) {
        List projectsUsing = this.manager.getProjectsUsing(scheme.getParentScheme());
        if (projectsUsing.isEmpty()) {
            return null;
        }
        Project primaryProject = (Project)projectsUsing.get(0);
        return this.taskManager.getLiveTask(new EnterpriseWorkflowTaskContext(primaryProject, projectsUsing, scheme.getId(), true));
    }
}

