/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AbstractWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.ProjectMigrator;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationCompletedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;

public class AssignableWorkflowSchemeMigrationHelper
extends AbstractWorkflowSchemeMigrationHelper<AssignableWorkflowScheme> {
    private final Project project;
    private final String projectName;
    private final Long projectId;
    private final ProjectMigrator<AssignableWorkflowScheme> projectMigrator;

    AssignableWorkflowSchemeMigrationHelper(Project project, AssignableWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher) throws WorkflowException, GenericEntityException {
        super(targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher);
        this.project = project;
        this.projectName = project.getName();
        this.projectId = project.getId();
        this.projectMigrator = new ProjectMigrator<AssignableWorkflowScheme>(project, targetScheme, workflowManager, schemeManager, delegator, user, constantsManager, i18nHelper, issueIndexManager, new ProjectMigrator.OnCompleteCallback<AssignableWorkflowScheme>(){

            @Override
            public void onComplete(SchemeManager schemeManager, Project project, AssignableWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
                AssignableWorkflowSchemeMigrationHelper.this.assignSchemeToTemplate(migrationSink);
            }
        });
        this.calculateInputRequired();
    }

    @Override
    JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        return this.getExistingWorkflowByProjectId(issueTypeId, this.projectId);
    }

    @Override
    EntityCondition getProjectClause(String projectField) {
        return new EntityFieldMap((Map)ImmutableMap.of((Object)projectField, (Object)this.projectId), EntityOperator.AND);
    }

    @Override
    public WorkflowMigrationResult migrate(TaskProgressSink sink) throws GenericEntityException, WorkflowException {
        return this.projectMigrator.migrate(sink, this.typesNeedingMigration, this.workflowMigrationMapping);
    }

    @VisibleForTesting
    void assignSchemeToTemplate(StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        AssignableWorkflowScheme sourceScheme = this.workflowSchemeManager.getWorkflowSchemeObj(this.project);
        this.assignSchemeToProjectTemplate(migrationSink);
        this.workflowSchemeManager.clearWorkflowCache();
        this.copyAndDeleteDraftsForInactiveWorkflowsIn((WorkflowScheme)sourceScheme);
        this.eventPublisher.publish((Object)new WorkflowSchemeMigrationCompletedEvent(this.targetScheme));
    }

    @Override
    void quickMigrate() throws GenericEntityException {
        this.projectMigrator.complete(this.schemeManager, this.project, (AssignableWorkflowScheme)this.targetScheme, null);
    }

    @Override
    String getMigrateAsyncTaskDesc() {
        return this.i18nHelper.getText("admin.selectworkflows.task.desc", this.projectName, this.schemeName);
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.project, this.schemeId, false);
    }

    @VisibleForTesting
    void assignSchemeToProjectTemplate(StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        this.workflowSchemeManager.cleanUpSchemeDraft(this.project, this.user);
        this.schemeManager.removeSchemesFromProject(this.project);
        if (this.targetScheme != null && ((AssignableWorkflowScheme)this.targetScheme).getId() != null) {
            Scheme scheme = this.workflowSchemeManager.getSchemeObject(((AssignableWorkflowScheme)this.targetScheme).getId());
            this.schemeManager.addSchemeToProject(this.project, scheme);
        }
    }

    public void associateProjectAndWorkflowScheme() throws GenericEntityException {
        this.projectMigrator.complete(this.schemeManager, this.project, (AssignableWorkflowScheme)this.targetScheme, null);
    }
}

