/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.ComponentManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.util.ContainUtil;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class SoyTemplateTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private static final SoyTemplateRenderer soyRenderer = ComponentManager.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    private static final Logger log = LoggerFactory.getLogger(SoyTemplateTag.class);
    protected String template;
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected String completeModuleKey;

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getModuleKey() {
        return this.completeModuleKey;
    }

    public void setModuleKey(String completeModuleKey) {
        this.completeModuleKey = completeModuleKey;
    }

    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public boolean memberOf(Object obj1, Object obj2) {
        return ContainUtil.contains((Object)obj1, (Object)obj2);
    }

    public int doEndTag() throws JspException {
        String id = this.removeSingleQuotes(this.getId());
        String template = this.findString(this.getTemplate());
        String moduleKey = this.findString(this.getModuleKey());
        if (StringUtils.isEmpty((String)moduleKey)) {
            throw new JspTagException("Failed to render soy tag; " + String.format("moduleKey attribute's value of \"%s\" evaluated to an empty string.", this.getModuleKey()) + "\nPerhaps you need to enclose the value in single quotes?");
        }
        if (StringUtils.isEmpty((String)template)) {
            throw new JspTagException("Failed to render soy tag; " + String.format("template attribute's value of \"%s\" evaluated to an empty string.", this.getTemplate()) + "\nPerhaps you need to enclose the value in single quotes?");
        }
        if (!StringUtils.isEmpty((String)id)) {
            this.addParameterInternal("id", id);
        }
        this.getStack().pushValue((Object)this);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Using template '%s' from module '%s'", (Object)template, (Object)moduleKey);
            }
            String output = soyRenderer.render(moduleKey, template, this.getParameters());
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write(output);
            int n = 6;
            return n;
        }
        catch (SoyException e) {
            throw new JspTagException("Soy rendering failed for template '%s'.", (Throwable)e);
        }
        catch (IOException e) {
            throw new JspTagException("Failed to render soy tag, using template '%s' from module '%s'.", (Throwable)e);
        }
        finally {
            this.getStack().popValue();
            this.params = new HashMap<String, Object>();
        }
    }

    private String removeSingleQuotes(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int start = 0;
        int end = s.length() - 1;
        if (s.charAt(start) == '\'') {
            ++start;
        }
        if (s.charAt(end) == '\'') {
            --end;
        }
        if (start == end) {
            return "";
        }
        return s.substring(start, end + 1);
    }
}

