/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.StreamCopyingConsumer;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public abstract class AbstractAvatarServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AbstractAvatarServlet.class);
    static final int AVATAR_BUFFER_SIZE = 4096;
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_OWNER_ID = "ownerId";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String ownerId = this.getOwnerId(request);
            Long avatarId = this.getAvatarId(request);
            AvatarManager.ImageSize size = AvatarManager.ImageSize.fromString((String)request.getParameter(PARAM_SIZE));
            this.defaultDoGet(request, response, ownerId, avatarId, size);
        }
        catch (NumberFormatException e) {
            response.sendError(404);
        }
    }

    private Long getAvatarId(HttpServletRequest request) throws NumberFormatException {
        return NumberUtils.createLong((String)request.getParameter("avatarId"));
    }

    private String getOwnerId(HttpServletRequest request) {
        String ownerId = StringUtils.trim((String)request.getParameter(this.getOwnerIdParamName()));
        if (StringUtils.isBlank((String)ownerId)) {
            ownerId = request.getParameter(PARAM_OWNER_ID);
        }
        return ownerId;
    }

    protected void defaultDoGet(HttpServletRequest request, HttpServletResponse response, String ownerId, Long avatarId, AvatarManager.ImageSize size) throws IOException, ServletException {
        boolean bytesWritten = false;
        try {
            Long realAvatarId = this.validateInput(ownerId, avatarId, response);
            if (realAvatarId == null) {
                return;
            }
            Avatar avatar = this.getAvatarManager().getById(realAvatarId);
            if (avatar == null) {
                response.sendError(404, "Avatar not found");
            } else if (!this.avatarOkForOwner(ownerId, avatar)) {
                log.warn((Object)("Attempted access to avatar " + avatar.getId() + " for owner " + ownerId + " when it doesn't belong to that owner."));
                response.sendError(404);
            } else {
                this.sendAvatar(response, avatar, size);
                bytesWritten = true;
            }
        }
        catch (IOException e) {
            AbstractAvatarServlet.handleOutputStreamingException(response, bytesWritten, e);
        }
        catch (RuntimeException e) {
            AbstractAvatarServlet.handleOutputStreamingException(response, bytesWritten, e);
        }
    }

    protected boolean avatarOkForOwner(String ownerId, Avatar avatar) {
        String owner = avatar.getOwner();
        return owner == null || ownerId != null && IdentifierUtils.equalsInLowerCase((String)ownerId, (String)owner);
    }

    protected static void handleOutputStreamingException(HttpServletResponse response, boolean bytesWritten, Exception e) throws IOException, ServletException {
        if (WebExceptionChecker.canBeSafelyIgnored(e)) {
            return;
        }
        if (bytesWritten || response.isCommitted()) {
            throw new ServletException("Unable to write a coherent reponse for avatar request", (Throwable)e);
        }
        response.sendError(404);
    }

    private void sendAvatar(HttpServletResponse response, Avatar avatar, AvatarManager.ImageSize size) throws IOException {
        response.setContentType(AvatarManager.AVATAR_IMAGE_FORMAT_FULL.getContentType());
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
        ServletOutputStream out = response.getOutputStream();
        StreamCopyingConsumer streamCopier = new StreamCopyingConsumer((OutputStream)out, 4096);
        this.getAvatarManager().readAvatarData(avatar, size, (Consumer)streamCopier);
    }

    protected abstract Long validateInput(String var1, Long var2, HttpServletResponse var3) throws IOException;

    protected abstract String getOwnerIdParamName();

    AvatarManager getAvatarManager() {
        return ComponentAccessor.getAvatarManager();
    }
}

