/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleWebComponentImpl
implements ModuleWebComponent {
    private static final Logger log = LoggerFactory.getLogger(ModuleWebComponentImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ModuleWebComponentFields mwcFields;

    public ModuleWebComponentImpl(JiraAuthenticationContext jiraAuthenticationContext, ModuleWebComponentFields mwcFields) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.mwcFields = mwcFields;
    }

    @Override
    public String renderModules(User user, HttpServletRequest request, List<WebPanelModuleDescriptor> webPanelModuleDescriptors, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        for (WebPanelModuleDescriptor webPanelModuleDescriptor : webPanelModuleDescriptors) {
            this.renderModuleAndLetNoThrowablesEscape(sb, user, request, webPanelModuleDescriptor, params);
        }
        return sb.toString();
    }

    @Override
    public String renderModule(User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        this.renderModuleAndLetNoThrowablesEscape(sb, user, request, webPanelModuleDescriptor, params);
        return sb.toString();
    }

    private void renderModuleAndLetNoThrowablesEscape(StringBuilder module, User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) {
        try {
            this.renderModule(module, user, request, webPanelModuleDescriptor, params);
        }
        catch (Throwable t) {
            log.error("Error rendering web panel: " + webPanelModuleDescriptor, t);
            module.append(this.buildRenderFailureMessage(webPanelModuleDescriptor));
        }
    }

    private void renderModule(StringBuilder module, User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) {
        String prefix;
        String additionalContainerClass;
        String html;
        try {
            html = ((WebPanel)webPanelModuleDescriptor.getModule()).getHtml(params);
        }
        catch (Throwable t) {
            log.error("Error rendering web panel: " + webPanelModuleDescriptor, t);
            html = this.buildRenderFailureMessage(webPanelModuleDescriptor);
        }
        JiraHelper helper = (JiraHelper)params.get("helper");
        if (StringUtils.isBlank((String)html)) {
            return;
        }
        Map moduleParams = webPanelModuleDescriptor.getParams();
        if (moduleParams.containsKey("headless") && ((String)moduleParams.get("headless")).equals("true") || params.containsKey("headless") && params.get("headless").equals(true)) {
            module.append(html);
            return;
        }
        String key = webPanelModuleDescriptor.getKey();
        String string = additionalContainerClass = moduleParams.containsKey("containerClass") ? " " + (String)moduleParams.get("containerClass") : "";
        if (StringUtils.isBlank((String)additionalContainerClass)) {
            additionalContainerClass = params.containsKey("containerClass") ? " " + params.get("containerClass") : "";
        }
        String string2 = prefix = moduleParams.containsKey("prefix") ? "" + (String)moduleParams.get("prefix") : "";
        if (StringUtils.isBlank((String)prefix)) {
            prefix = params.containsKey("prefix") ? "" + params.get("prefix") : "";
        }
        module.append("<div class='module toggle-wrap").append(additionalContainerClass).append("' id='").append(prefix).append(key).append("'>");
        module.append("<div id='").append(key).append("_heading' class='mod-header'>");
        List<SimpleLink> headerItems = this.mwcFields.getHeaderItems(webPanelModuleDescriptor.getCompleteKey(), user, helper);
        List<ModuleWebComponentFields.SectionsAndLinks> dropDownSections = this.mwcFields.getDropdownSections(webPanelModuleDescriptor.getCompleteKey(), user, helper);
        if (!headerItems.isEmpty() || !dropDownSections.isEmpty()) {
            module.append("<ul class='ops'>");
            for (SimpleLink link : headerItems) {
                module.append("<li>");
                this.renderLink(module, link, "");
                module.append("</li>");
            }
            if (!dropDownSections.isEmpty()) {
                module.append("<li class='drop'>");
                module.append("<div class='aui-dd-parent'>");
                String optionText = this.jiraAuthenticationContext.getI18nHelper().getText("admin.common.words.options");
                module.append("<a href='#' class='icon drop-menu js-default-dropdown' title='").append(optionText).append("'><span>").append(optionText).append("</span></a>");
                module.append("<div class='aui-dropdown-content aui-list'>");
                for (int i = 0; i < dropDownSections.size(); ++i) {
                    String additionalClass = "";
                    if (i == 0) {
                        additionalClass = "aui-first";
                    }
                    if (i == dropDownSections.size() - 1) {
                        additionalClass = additionalClass + " aui-last";
                    }
                    ModuleWebComponentFields.SectionsAndLinks sectionAndLinks = dropDownSections.get(i);
                    this.renderSection(module, sectionAndLinks.getSection(), additionalClass, sectionAndLinks.getLinks());
                }
                module.append("</div>");
                module.append("</div>");
                module.append("</li>");
            }
            module.append("</ul>");
        }
        this.renderHeaderPanels(module, webPanelModuleDescriptor.getCompleteKey(), params);
        module.append("<h3 class='toggle-title'>");
        this.renderModHeading(module, request, webPanelModuleDescriptor, params);
        module.append("</h3>");
        module.append("</div>");
        module.append("<div class='mod-content'>");
        module.append(html);
        module.append("</div>");
        module.append("</div>");
    }

    private void renderHeaderPanels(StringBuilder module, String key, Map<String, Object> params) {
        List<WebPanelModuleDescriptor> panels = this.mwcFields.getPanels(key, params);
        if (!panels.isEmpty()) {
            module.append("<div class='mod-header-panels'>");
            for (WebPanelModuleDescriptor panel : panels) {
                module.append("<div class='mod-header-panel'>");
                module.append(((WebPanel)panel.getModule()).getHtml(params));
                module.append("</div>");
            }
            module.append("</div>");
        }
    }

    private void renderSection(StringBuilder module, SimpleLinkSection section, String additionalClass, List<SimpleLink> links) {
        if (StringUtils.isNotBlank((String)section.getLabel())) {
            module.append("<h5>").append(section.getLabel()).append("</h5>");
        }
        module.append("<ul");
        if (StringUtils.isNotBlank((String)section.getId())) {
            module.append(" id='").append(section.getId()).append("'");
        }
        module.append(" class='aui-list-section");
        if (StringUtils.isNotBlank((String)additionalClass)) {
            module.append(" ").append(additionalClass);
        }
        if (StringUtils.isNotBlank((String)section.getStyleClass())) {
            module.append(" ").append(section.getStyleClass());
        }
        module.append("'>");
        for (SimpleLink link : links) {
            module.append("<li class='aui-list-item'>");
            this.renderLink(module, link, "aui-list-item-link");
            module.append("</li>");
        }
        module.append("</ul>");
    }

    private void renderLink(StringBuilder moduleBuilder, SimpleLink link, String additionalClass) {
        moduleBuilder.append("<a");
        if (StringUtils.isNotBlank((String)link.getId())) {
            moduleBuilder.append(" id='").append(link.getId()).append("'");
        }
        moduleBuilder.append(" href='").append(link.getUrl()).append("'");
        if (StringUtils.isNotBlank((String)link.getStyleClass()) || StringUtils.isNotBlank((String)additionalClass)) {
            moduleBuilder.append(" class='");
            if (StringUtils.isNotBlank((String)link.getStyleClass())) {
                moduleBuilder.append(link.getStyleClass());
            }
            moduleBuilder.append(" ").append(additionalClass);
            moduleBuilder.append("'");
        }
        if (StringUtils.isNotBlank((String)link.getTitle())) {
            moduleBuilder.append(" title='").append(link.getTitle()).append("'");
        }
        moduleBuilder.append("><span>");
        moduleBuilder.append(link.getLabel());
        moduleBuilder.append("</span></a>");
    }

    private void renderModHeading(StringBuilder moduleBuilder, HttpServletRequest request, WebPanelModuleDescriptor webPanel, Map<String, Object> params) {
        try {
            WebLabel webLabel = webPanel.getWebLabel();
            if (webLabel != null) {
                moduleBuilder.append(webLabel.getDisplayableLabel(request, params));
            }
        }
        catch (Throwable t) {
            if (webPanel.getI18nNameKey() != null) {
                moduleBuilder.append(this.jiraAuthenticationContext.getI18nHelper().getText(webPanel.getI18nNameKey()));
            }
            moduleBuilder.append(webPanel.getKey());
        }
    }

    private String buildRenderFailureMessage(WebPanelModuleDescriptor webPanelModuleDescriptor) {
        return this.jiraAuthenticationContext.getI18nHelper().getText("modulewebcomponent.exception", webPanelModuleDescriptor.getCompleteKey());
    }
}

