/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.util.DataCleaner;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import javax.servlet.ServletContext;
import webwork.action.ServletActionContext;

public class CleanData
extends JiraWebActionSupport {
    private String userName;
    private String password;
    private boolean dataCleaned;
    private final CrowdService crowdService;

    public CleanData(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public String doDefault() throws Exception {
        this.dataCleaned = false;
        return "success";
    }

    protected void doValidation() {
        User user = this.crowdService.getUser(this.userName);
        if (user != null) {
            boolean hasAdminPermission;
            try {
                this.crowdService.authenticate(user.getName(), this.password);
            }
            catch (FailedAuthenticationException e) {
                this.addErrorMessage(this.getText("admin.errors.cleandata.username.password.incorrect"));
                return;
            }
            if (!this.nonAdminUpgradeAllowed() && !(hasAdminPermission = ComponentAccessor.getPermissionManager().hasPermission(0, user))) {
                this.addError("userName", this.getText("admin.errors.cleandata.no.admin.permission"));
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.cleandata.username.password.incorrect"));
        }
    }

    protected String doExecute() throws Exception {
        OfBizDelegator ofBizDelegator = ComponentManager.getComponent(OfBizDelegator.class);
        ApplicationProperties applicationProperties = ComponentManager.getComponent(ApplicationProperties.class);
        DataCleaner dataCleaner = new DataCleaner(applicationProperties, ofBizDelegator);
        dataCleaner.clean();
        JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        for (Event event : cont.getEvents()) {
            if (event == null || !event.getKey().equals((Object)EventType.get((String)"export-illegal-xml"))) continue;
            cont.removeEvent(event);
        }
        Event newEvent = new Event(EventType.get((String)"restart"), "The illegal XML characters have been removed. The server needs to be restarted.", EventLevel.get((String)"error"));
        cont.addEvent(newEvent);
        this.setDataCleaned(true);
        return this.getResult();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private boolean nonAdminUpgradeAllowed() {
        return Boolean.valueOf(System.getProperty("non.admin.upgrade"));
    }

    public boolean isDataCleaned() {
        return this.dataCleaned;
    }

    private void setDataCleaned(boolean dataCleaned) {
        this.dataCleaned = dataCleaned;
    }
}

