/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.web.action.AbstractViewIssueColumns;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViewUserIssueColumns
extends AbstractViewIssueColumns {
    private String name;
    private User profileUser;
    private EditableUserColumnLayout editableUserColumnLayout;
    private EmailFormatter emailFormatter;
    private GroupPermissionChecker groupPermissionChecker;
    private final UserPreferencesManager userPreferencesManager;

    public ViewUserIssueColumns() {
        this(ComponentManager.getComponentInstanceOfType(IssueSearcherManager.class), ComponentManager.getComponentInstanceOfType(EmailFormatter.class), ComponentManager.getComponentInstanceOfType(GroupPermissionChecker.class), ComponentAccessor.getUserPreferencesManager(), ComponentManager.getComponentInstanceOfType(SearchService.class), ComponentManager.getComponentInstanceOfType(SearchSortUtil.class));
    }

    public ViewUserIssueColumns(IssueSearcherManager issueSearcherManager, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, UserPreferencesManager userPreferencesManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
        this.userPreferencesManager = userPreferencesManager;
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() != null && ComponentAccessor.getPermissionManager().hasPermission(1, this.getLoggedInUser())) {
            return this.runOperation();
        }
        return "securitybreach";
    }

    @Override
    public String getActionLocation(String prefix) {
        return prefix + this.getActionName() + ".jspa";
    }

    @Override
    protected List<NavigableField> getAvailableNavigatableFields() throws FieldException {
        return new ArrayList<NavigableField>(this.getFieldManager().getAvailableNavigableFields(this.getLoggedInUser()));
    }

    @Override
    protected EditableColumnLayout getColumnLayout() {
        if (this.editableUserColumnLayout == null) {
            try {
                this.editableUserColumnLayout = this.getColumnLayoutManager().getEditableUserColumnLayout(this.getUser());
            }
            catch (ColumnLayoutStorageException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.user.could.not.retrieve.column.layout"));
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return this.editableUserColumnLayout;
    }

    @Override
    protected void store() {
        try {
            this.getColumnLayoutManager().storeEditableUserColumnLayout((EditableUserColumnLayout)this.getColumnLayout());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)"The was an error storing the user's column layout.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.user.error.restoring.default.column.layout"));
        }
    }

    @Override
    protected String doRestoreDefault() {
        try {
            this.getColumnLayoutManager().restoreUserColumnLayout(this.getUser());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.user.could.not.restore.default"));
        }
        return this.getResult();
    }

    public User getUser() {
        if (this.profileUser == null) {
            this.profileUser = this.name == null ? this.getLoggedInUser() : UserUtils.getUser((String)this.name);
        }
        return this.profileUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ColumnLayoutItem> getDefaultColumns() {
        try {
            return this.getColumnLayoutManager().getDefaultColumnLayout(this.getLoggedInUser()).getColumnLayoutItems();
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.user.could.not.retrieve.column.layout"));
            return Collections.emptyList();
        }
    }

    public boolean isUsingDefaultColumns() {
        try {
            return !this.getColumnLayoutManager().hasColumnLayout(this.getLoggedInUser());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.user.could.not.check.if.default"));
            return true;
        }
    }

    public boolean isHasViewGroupPermission(String group, User user) {
        return this.groupPermissionChecker.hasViewGroupPermission(group, user);
    }

    public String getDisplayEmail(String email) {
        return this.emailFormatter.formatEmailAsLink(email, this.getLoggedInUser());
    }

    public Boolean isActionsAndOperationsShowing() {
        return this.getUserPreferences().getBoolean("user.show.actions.in.navigator");
    }

    @Override
    public String doShowActionsColumn() throws AtlassianCoreException {
        this.getUserPreferences().setBoolean("user.show.actions.in.navigator", true);
        this.userPreferencesManager.clearCache();
        return "input";
    }

    @Override
    public String doHideActionsColumn() throws AtlassianCoreException {
        this.getUserPreferences().setBoolean("user.show.actions.in.navigator", false);
        this.userPreferencesManager.clearCache();
        return "input";
    }

    public String getText(String keyName) {
        List fields = this.getAddableColumns();
        for (NavigableField field : fields) {
            if (!field.getName().equals(keyName)) continue;
            return field.getName();
        }
        return super.getText(keyName);
    }
}

