/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class MoveSubTask
extends MoveIssue {
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public MoveSubTask(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueTypeSchemeManager issueTypeSchemeManager, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        this.getMoveIssueBean().setCurrentStep(1);
        this.getMoveIssueBean().addAvailablePreviousStep(0);
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                if (!this.hasIssuePermission(25, (Issue)this.getIssueObject())) {
                    this.addErrorMessage(this.getText("move.issue.nopermissions"));
                }
                this.getFieldManager().getIssueTypeField().populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
                MutableIssue issueObject = this.getIssueObject(null);
                this.getFieldManager().getIssueTypeField().validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, (Issue)issueObject, null);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception: " + e), (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.issues.an.exception.occured", e));
            }
        }
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        this.getMoveIssueBean().addAvailablePreviousStep(1);
        this.getMoveIssueBean().setCurrentStep(2);
        return super.doExecute();
    }

    public Collection getSubTaskTypes() {
        return this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(this.getIssueObject().getProjectObject());
    }

    public Collection getOtherSubTaskTypes() {
        Collection subTaskTypes = this.getSubTaskTypes();
        ArrayList<GenericValue> otherSubTaskTypes = new ArrayList<GenericValue>();
        GenericValue currentSubTaskType = this.getSubTaskManager().getSubTaskIssueTypeById(this.getIssue().getString("type"));
        for (GenericValue subTaskType : subTaskTypes) {
            if (currentSubTaskType.equals((Object)subTaskType)) continue;
            otherSubTaskTypes.add(subTaskType);
        }
        return otherSubTaskTypes;
    }

    @Override
    protected Map getViewHtmlParams() {
        return EasyMap.build((Object)"moveissue", (Object)Boolean.TRUE);
    }

    @Override
    public MutableIssue getIssueObject(GenericValue issue) {
        MutableIssue issueObject = super.getIssueObject(issue);
        issueObject.setParentId(this.getSubTaskManager().getParentIssueId(this.getIssue()));
        return issueObject;
    }
}

