/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

@WebSudoRequired
public class ViewWorkflowTransitionConditionalResult
extends AbstractWorkflowTransitionAction {
    private int resultCount;
    private ConditionalResultDescriptor resultDescriptor;
    private String resultXml;

    public ViewWorkflowTransitionConditionalResult(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public ViewWorkflowTransitionConditionalResult(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(int resultCount) {
        this.resultCount = resultCount;
    }

    protected void doValidation() {
        if (this.getTransition().getConditionalResults() == null) {
            this.addErrorMessage(this.getText("admin.errors.workflows.no.conditional.results.defined"));
        } else if (this.resultCount < 1 || this.resultCount > this.getTransition().getConditionalResults().size()) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.step.count", "" + this.resultCount));
        }
        super.doValidation();
    }

    protected String doExecute() throws Exception {
        List conditionalResults = this.getTransition().getConditionalResults();
        this.resultDescriptor = (ConditionalResultDescriptor)conditionalResults.get(this.resultCount - 1);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        this.resultDescriptor.writeXML(writer, 0);
        writer.flush();
        this.resultXml = stringWriter.getBuffer().toString();
        return super.doExecute();
    }

    public StepDescriptor getDestinationStepDescriptor() {
        int targetStepId = this.resultDescriptor.getStep();
        return this.getWorkflow().getDescriptor().getStep(targetStepId);
    }

    public String getResultXML() {
        return this.resultXml;
    }
}

