/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteStatus
extends AbstractDeleteConstant {
    private final StatusManager statusManager;
    private final WorkflowManager workflowManager;

    public DeleteStatus(StatusManager statusManager, WorkflowManager workflowManager) {
        this.statusManager = statusManager;
        this.workflowManager = workflowManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Status";
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return "status";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getStatus(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getStatuses();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    @Override
    protected void doValidation() {
        try {
            if (this.getConstant() == null) {
                this.addErrorMessage(this.getText("admin.errors.no.constant.found", this.getNiceConstantName(), this.id));
            } else if (!this.getAssociatedWorkflows(this.getConstant()).isEmpty()) {
                this.addErrorMessage(this.getText("admin.errors.constant.associated.with.workflow", this.getNiceConstantName(), this.getId()));
            }
        }
        catch (GenericEntityException e) {
            this.log.error((Object)("Error occurred: " + (Object)((Object)e)), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.general.error.occurred", (Object)e));
        }
    }

    public Collection getAssociatedWorkflows(GenericValue statusGV) {
        List workflows = this.workflowManager.getWorkflowsIncludingDrafts();
        ArrayList<String> associatedWorkflows = new ArrayList<String>();
        for (JiraWorkflow workflow : workflows) {
            List linkStatuses = workflow.getLinkedStatuses();
            if (!linkStatuses.contains(statusGV)) continue;
            associatedWorkflows.add(workflow.getName());
        }
        return associatedWorkflows;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.statusManager.removeStatus(this.id);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }
}

