/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.mapper;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.scheme.mapper.SchemeGroupsToRoleTransformerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.mapper.GroupToRoleMapping;
import com.atlassian.jira.scheme.mapper.SchemeTransformResults;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.scheme.mapper.AbstractGroupToRoleAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemeGroupToRoleTransformerAction
extends AbstractGroupToRoleAction {
    public static final String UNMAPPED_PROJECT_ROLE_VALUE = "-1";
    private SchemeGroupsToRoleTransformerService schemeGroupsToRolesTransformerService;
    private List groupToRoleMappings;
    private Predicate mapsGlobalUsePermission = new Predicate(){

        public boolean evaluate(Object object) {
            GroupToRoleMapping mapping = (GroupToRoleMapping)object;
            return SchemeGroupToRoleTransformerAction.this.schemeGroupsToRolesTransformerService.isGroupGrantedGlobalUsePermission(mapping.getGroupName());
        }
    };
    private Predicate doesNotMapGlobalUsePermission = PredicateUtils.notPredicate((Predicate)this.mapsGlobalUsePermission);

    public SchemeGroupToRoleTransformerAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, SchemeGroupsToRoleTransformerService schemeGroupsToRolesTransformer, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
        this.schemeGroupsToRolesTransformerService = schemeGroupsToRolesTransformer;
    }

    public String doDefault() throws Exception {
        Set roleMappings = this.getGroupToRoleMappings() == null ? Collections.EMPTY_SET : new HashSet(this.getGroupToRoleMappings());
        SchemeTransformResults schemeTransformResults = this.schemeGroupsToRolesTransformerService.doTransform(this.getLoggedInUser(), this.getSchemeObjs(), roleMappings, (ErrorCollection)this);
        ActionContext.getSession().put("__schemeGroupsToRoleTransformResults", schemeTransformResults);
        return "input";
    }

    protected void doValidation() {
        if (!this.isHasSelectedSchemeIds()) {
            this.addErrorMessage(this.getText("admin.scheme.group.role.preview.no.schemes.selected"));
        } else if (this.getGroupToRoleMappings().isEmpty()) {
            this.addErrorMessage(this.getText("admin.scheme.group.role.preview.no.groups.selected"));
        }
    }

    protected String doExecute() throws Exception {
        SchemeTransformResults schemeTransformResults = this.getSchemeTransformResults();
        this.schemeGroupsToRolesTransformerService.persistTransformationResults(this.getLoggedInUser(), schemeTransformResults, (ErrorCollection)this);
        return this.forceRedirect("SchemeGroupToRoleResult!default.jspa");
    }

    public List getGroupToRoleMappings() {
        if (this.groupToRoleMappings == null) {
            this.groupToRoleMappings = (List)ActionContext.getSession().get("__schemeGroupsToRoleMapping_sessionkey");
        }
        return this.groupToRoleMappings;
    }

    public boolean isAnyGroupGrantedGlobalUsePermission() {
        Collection groupNames = CollectionUtils.transformedCollection(new ArrayList(), (Transformer)GroupToRoleMapping.MAPPING_TO_GROUPNAME_TRANSFORMER);
        groupNames.addAll(this.getGroupToRoleMappings());
        return this.schemeGroupsToRolesTransformerService.isAnyGroupGrantedGlobalUsePermission(groupNames);
    }

    public boolean isGroupGrantedGlobalUsePermission(String groupName) {
        return this.schemeGroupsToRolesTransformerService.isGroupGrantedGlobalUsePermission(groupName);
    }

    public Iterator getMappingsWithoutGlobalUsePermission() {
        return IteratorUtils.filteredIterator(this.getGroupToRoleMappings().iterator(), (Predicate)this.doesNotMapGlobalUsePermission);
    }

    public Iterator getMappingsWithGlobalUsePermission() {
        return IteratorUtils.filteredIterator(this.getGroupToRoleMappings().iterator(), (Predicate)this.mapsGlobalUsePermission);
    }

    public String getFullNameForUser(String username) {
        User user = UserUtils.getUser((String)username);
        if (user != null) {
            return user.getDisplayName();
        }
        return username;
    }
}

