/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.dashboard.view.DashboardTabViewFactory;
import com.atlassian.gadgets.view.ViewComponent;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditDefaultDashboard
extends JiraWebActionSupport {
    private final PortalPageService portalPageService;
    private final DashboardPermissionService permissionService;
    private final DashboardTabViewFactory dashboardTabViewFactory;
    private final DashboardService dashboardService;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private Long defaultPortalPageId;
    private final ApplicationProperties applicationProperties;

    public EditDefaultDashboard(PortalPageService portalPageService, DashboardPermissionService permissionService, ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.dashboardTabViewFactory = ComponentManager.getOSGiComponentInstanceOfType(DashboardTabViewFactory.class);
        this.dashboardService = ComponentManager.getOSGiComponentInstanceOfType(DashboardService.class);
        this.gadgetRequestContextFactory = ComponentManager.getOSGiComponentInstanceOfType(GadgetRequestContextFactory.class);
        this.portalPageService = portalPageService;
        this.permissionService = permissionService;
    }

    public String doDefault() throws Exception {
        if (!this.isDashboardPluginEnabled()) {
            String link = this.getAdministratorContactLink();
            this.addErrorMessage(this.getText("admin.errors.portalpages.plugin.disabled", link));
            return "error";
        }
        PortalPage defaultPortalPage = this.portalPageService.getSystemDefaultPortalPage();
        if (defaultPortalPage == null) {
            return "error";
        }
        this.defaultPortalPageId = defaultPortalPage.getId();
        if (!this.permissionService.isWritableBy(DashboardId.valueOf((String)this.defaultPortalPageId.toString()), this.getUsername())) {
            return "error";
        }
        return "success";
    }

    private boolean isDashboardPluginEnabled() {
        return this.dashboardTabViewFactory != null && this.dashboardService != null && this.gadgetRequestContextFactory != null;
    }

    public String getDashboardHtml() {
        DashboardState state = this.dashboardService.get(DashboardId.valueOf((String)this.defaultPortalPageId.toString()), this.getUsername());
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(ActionContext.getRequest());
        ViewComponent view = this.dashboardTabViewFactory.createDashboardView(Collections.emptyList(), state, this.getUsername(), DashboardUtil.getMaxGadgets((ApplicationProperties)this.applicationProperties), requestContext);
        StringWriter out = new StringWriter();
        try {
            view.writeTo((Writer)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUsername() {
        User remoteUser = this.getLoggedInUser();
        if (remoteUser != null) {
            return remoteUser.getName();
        }
        return null;
    }
}

