/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.web.action.admin.GeneralConfigurationUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.setting.GzipCompression;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.RegionInfoImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneInfoImpl;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlValidator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.ViewApplicationProperties;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class EditApplicationProperties
extends ViewApplicationProperties {
    public static final String LOGOUT_CONFIRM_ALWAYS = "always";
    public static final String LOGOUT_CONFIRM_NEVER = "never";
    public static final String LOGOUT_CONFIRM_COOKIE = "cookie";
    private static final long serialVersionUID = 3888401310969767356L;
    private String title;
    private String mode;
    private String introduction;
    private String baseURL;
    private String emailFromHeaderFormat;
    private String language;
    private String defaultLocale;
    private boolean captcha;
    private boolean voting;
    private boolean watching;
    private boolean allowUnassigned;
    private boolean externalUM;
    private boolean cacheIssues;
    private String logoutConfirm;
    private boolean criteriaAutoUpdate;
    private boolean useGzip;
    private boolean allowRpc;
    private boolean excludePrecedenceHeader;
    private String emailVisibility;
    private Boolean hasUnassignedIssues;
    private String maximumLengthProjectNames;
    private String maximumLengthProjectKeys;
    private Long unassignedIssueCount;
    private int projectsWithDefaultUnassignedCount = -1;
    private String maximumAuthenticationAttemptsAllowed;
    private boolean groupVisibility;
    private boolean projectRoleVisibility;
    private boolean ajaxIssuePicker;
    private boolean jqlAutocompleteDisabled;
    private String ieMimeSniffer;
    private final Map<String, String> validMimeSnifferOptions = ImmutableMap.of((Object)"insecure", (Object)this.getText("admin.generalconfiguration.ie.mime.sniffing.owned"), (Object)"secure", (Object)this.getText("admin.generalconfiguration.ie.mime.sniffing.paranoid"), (Object)"workaround", (Object)this.getText("admin.generalconfiguration.ie.mime.sniffing.workaround"));
    private boolean showContactAdministratorsForm;
    private String contactAdministratorsMessage;
    private final EventPublisher eventPublisher;
    private final ReindexMessageManager reindexMessageManager;
    private String timeZoneId;
    private final FieldManager fieldManager;
    private final DelegatorInterface genericDelegator;
    private final IssueManager issueManager;
    private final ProjectService projectService;

    public EditApplicationProperties(UserPickerSearchService searchService, ReindexMessageManager reindexMessageManager, LocaleManager localeManager, TimeZoneService timeZoneManager, RendererManager rendererManager, FieldManager fieldManager, DelegatorInterface genericDelegator, PluginAccessor pluginAccessor, GzipCompression gzipCompression, IssueManager issueManager, FeatureManager featureManager, IntroductionProperty introductionProperty, ProjectService projectService) {
        super(searchService, localeManager, timeZoneManager, rendererManager, pluginAccessor, gzipCompression, featureManager, introductionProperty);
        this.fieldManager = fieldManager;
        this.genericDelegator = genericDelegator;
        this.issueManager = issueManager;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.eventPublisher = this.getEventPublisher();
        this.projectService = projectService;
    }

    public String doDefault() throws Exception {
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        this.title = applicationProperties.getString("jira.title");
        this.baseURL = applicationProperties.getString("jira.baseurl");
        this.emailFromHeaderFormat = applicationProperties.getDefaultBackedString("jira.email.fromheader.format");
        this.mode = applicationProperties.getString("jira.mode");
        this.introduction = applicationProperties.getText("jira.introduction");
        this.language = applicationProperties.getString("jira.i18n.language.index");
        this.defaultLocale = applicationProperties.getString("jira.i18n.default.locale");
        this.voting = applicationProperties.getOption("jira.option.voting");
        this.watching = applicationProperties.getOption("jira.option.watching");
        this.allowUnassigned = applicationProperties.getOption("jira.option.allowunassigned");
        this.externalUM = applicationProperties.getOption("jira.option.user.externalmanagement");
        this.logoutConfirm = applicationProperties.getDefaultBackedString("jira.option.logoutconfirm");
        this.useGzip = this.getGzipCompression().isEnabled();
        this.allowRpc = applicationProperties.getOption("jira.option.rpc.allow");
        this.emailVisibility = applicationProperties.getDefaultBackedString("jira.option.emailvisible");
        this.excludePrecedenceHeader = applicationProperties.getOption("jira.option.precedence.header.exclude");
        this.groupVisibility = applicationProperties.getOption("jira.comment.level.visibility.groups");
        this.captcha = applicationProperties.getOption("jira.option.captcha.on.signup");
        this.ajaxIssuePicker = applicationProperties.getOption("jira.ajax.autocomplete.issuepicker.enabled");
        this.ieMimeSniffer = applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        this.jqlAutocompleteDisabled = applicationProperties.getOption("jira.jql.autocomplete.disabled");
        this.maximumAuthenticationAttemptsAllowed = applicationProperties.getDefaultBackedString("jira.maximum.authentication.attempts.allowed");
        this.maximumLengthProjectNames = String.valueOf(this.projectService.getMaximumNameLength());
        this.maximumLengthProjectKeys = String.valueOf(this.projectService.getMaximumKeyLength());
        this.showContactAdministratorsForm = applicationProperties.getOption("jira.show.contact.administrators.form");
        this.contactAdministratorsMessage = applicationProperties.getDefaultBackedText("jira.contact.administrators.message");
        return super.doDefault();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.title)) {
            this.addError("title", this.getText("admin.errors.you.must.set.an.application.title"));
        }
        if (!UrlValidator.isValid(this.baseURL)) {
            this.addError("baseURL", this.getText("admin.errors.you.must.set.a.valid.base.url"));
        }
        if (!TextUtils.stringSet((String)this.emailFromHeaderFormat)) {
            this.addError("emailFromHeaderFormat", this.getText("admin.errors.you.must.set.a.valid.email.from.header"));
        }
        if (!TextUtils.stringSet((String)this.mode)) {
            this.addError("mode", this.getText("admin.errors.invalid.mode.selected"));
        }
        if (!TextUtils.stringSet((String)this.language)) {
            this.addError("language", this.getText("admin.errors.invalid.language.selected"));
        }
        if (this.mode != null && this.mode.equalsIgnoreCase("public") && this.externalUM) {
            this.addError("mode", this.getText("admin.errors.invalid.mode.externalUM.combination"));
        }
        if (this.isSystemAdministrator()) {
            this.validateMimeForSysadmin();
        } else if (StringUtils.isNotBlank((String)this.ieMimeSniffer)) {
            this.log.warn((Object)(this.getLoggedInUser().getName() + " attempted to set Internet Explorer MIME setting without sysadmin permission"));
            this.ieMimeSniffer = null;
        }
        if (TextUtils.stringSet((String)this.maximumAuthenticationAttemptsAllowed)) {
            try {
                long maxAttemptsAllowed = Long.parseLong(this.maximumAuthenticationAttemptsAllowed);
                if (maxAttemptsAllowed <= 0L) {
                    this.addError("maximumAuthenticationAttemptsAllowed", this.getText("admin.generalconfiguration.maximum.authentication.attempts.allowed.is.zero"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("maximumAuthenticationAttemptsAllowed", this.getText("admin.generalconfiguration.maximum.authentication.attempts.allowed.notanumber", this.maximumAuthenticationAttemptsAllowed));
            }
        }
        if (TextUtils.stringSet((String)this.maximumLengthProjectNames)) {
            try {
                long maxProjectNameLength = Integer.parseInt(this.maximumLengthProjectNames);
                if (maxProjectNameLength <= 1L) {
                    this.addError("maximumLengthProjectNames", this.getText("admin.generalconfiguration.maximum.length.project.names.is.too.small"));
                } else if (maxProjectNameLength > 150L) {
                    this.addError("maximumLengthProjectNames", this.getText("admin.generalconfiguration.maximum.length.project.names.is.too.large"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("maximumLengthProjectKeys", this.getText("admin.generalconfiguration.maximum.length.project.names.notanumber", this.maximumLengthProjectNames));
            }
        } else {
            this.maximumLengthProjectNames = String.valueOf(80);
        }
        if (TextUtils.stringSet((String)this.maximumLengthProjectKeys)) {
            try {
                long maxProjectKeyLength = Integer.parseInt(this.maximumLengthProjectKeys);
                if (maxProjectKeyLength <= 1L) {
                    this.addError("maximumLengthProjectKeys", this.getText("admin.generalconfiguration.maximum.length.project.keys.is.too.small"));
                } else if (maxProjectKeyLength > 255L) {
                    this.addError("maximumLengthProjectKeys", this.getText("admin.generalconfiguration.maximum.length.project.keys.is.too.large"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("maximumLengthProjectKeys", this.getText("admin.generalconfiguration.maximum.length.project.keys.notanumber", this.maximumLengthProjectKeys));
            }
        }
        if (this.contactAdministratorsMessage != null && this.contactAdministratorsMessage.length() > 2000) {
            this.addErrorMessage(this.getText("admin.generalconfiguration.contact.administrators.message.too.long"));
        }
        if (!this.defaultLocale.equals("-1")) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            this.localeManager.validateUserLocale(this.getLoggedInUser(), this.defaultLocale, (ErrorCollection)errors);
            if (errors.hasAnyErrors()) {
                this.addError("defaultLocale", (String)errors.getErrors().get("userLocale"));
            }
        }
    }

    private void validateMimeForSysadmin() {
        if (!this.validMimeSnifferOptions.keySet().contains(this.ieMimeSniffer)) {
            if (StringUtils.isBlank((String)this.ieMimeSniffer)) {
                this.addError("ieMimeSniffer", this.getText("admin.errors.mimesniffer.required"));
            } else {
                this.addError("ieMimeSniffer", this.getText("admin.errors.mimesniffer.invalid", this.ieMimeSniffer));
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        applicationProperties.setString("jira.title", this.title);
        applicationProperties.setString("jira.baseurl", this.baseURL);
        applicationProperties.setString("jira.email.fromheader.format", this.emailFromHeaderFormat);
        applicationProperties.setString("jira.mode", this.mode);
        applicationProperties.setString("jira.maximum.authentication.attempts.allowed", this.maximumAuthenticationAttemptsAllowed);
        applicationProperties.setString("jira.projectname.maxlength", this.maximumLengthProjectNames);
        applicationProperties.setString("jira.projectkey.maxlength", this.maximumLengthProjectKeys);
        this.getIntroductionProperty().setValue(this.introduction);
        applicationProperties.setString("jira.i18n.language.index", this.language);
        if ("-1".equals(this.getDefaultLocale())) {
            String dl = applicationProperties.getString("jira.i18n.default.locale");
            if (dl != null) {
                applicationProperties.setString("jira.i18n.default.locale", null);
            }
        } else {
            applicationProperties.setString("jira.i18n.default.locale", this.getDefaultLocale());
        }
        if ("System".equals(this.timeZoneId)) {
            this.timeZoneService.clearDefaultTimeZone(this.getJiraServiceContext());
        } else if (!StringUtils.isEmpty((String)this.timeZoneId)) {
            this.timeZoneService.setDefaultTimeZone(this.timeZoneId, this.getJiraServiceContext());
        }
        boolean oldVoting = applicationProperties.getOption("jira.option.voting");
        if (oldVoting != this.voting) {
            applicationProperties.setOption("jira.option.voting", this.voting);
            this.fieldManager.refresh();
            if (this.voting) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.voting");
            }
        }
        applicationProperties.setOption("jira.option.watching", this.watching);
        try {
            if (this.allowUnassigned || this.isCanSwitchUnassignedOff()) {
                applicationProperties.setOption("jira.option.allowunassigned", this.allowUnassigned);
            }
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Could not retrieve unassigned issues.", (Throwable)e);
        }
        applicationProperties.setOption("jira.option.captcha.on.signup", this.captcha);
        applicationProperties.setOption("jira.option.user.externalmanagement", this.externalUM);
        applicationProperties.setString("jira.option.logoutconfirm", this.logoutConfirm);
        this.getGzipCompression().set(this.useGzip);
        applicationProperties.setOption("jira.option.rpc.allow", this.allowRpc);
        applicationProperties.setString("jira.option.emailvisible", this.emailVisibility);
        applicationProperties.setOption("jira.option.precedence.header.exclude", this.excludePrecedenceHeader);
        applicationProperties.setOption("jira.comment.level.visibility.groups", this.groupVisibility);
        applicationProperties.setOption("jira.ajax.autocomplete.issuepicker.enabled", this.ajaxIssuePicker);
        applicationProperties.setOption("jira.jql.autocomplete.disabled", this.jqlAutocompleteDisabled);
        if (StringUtils.isNotBlank((String)this.ieMimeSniffer)) {
            applicationProperties.setString("jira.attachment.download.mime.sniffing.workaround", this.ieMimeSniffer);
        }
        applicationProperties.setOption("jira.show.contact.administrators.form", this.showContactAdministratorsForm);
        applicationProperties.setText("jira.contact.administrators.message", this.contactAdministratorsMessage);
        this.eventPublisher.publish((Object)new GeneralConfigurationUpdatedEvent());
        applicationProperties.setOption("jira.user.avatar.gravatar.enabled", this.isUseGravatar());
        applicationProperties.setOption("jira.issuenav.criteria.autoupdate", this.getCriteriaAutoUpdate());
        return this.getRedirect("ViewApplicationProperties.jspa");
    }

    public void setParameters(Map parameters) {
    }

    public Map<String, String> getInstalledLocales() {
        return this.getLocaleManager().getInstalledLocalesWithDefault(Locale.getDefault(), (I18nHelper)this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = StringUtils.stripEnd((String)StringUtils.strip((String)baseURL), (String)" /");
    }

    public String getEmailFromHeaderFormat() {
        return this.emailFromHeaderFormat;
    }

    public void setEmailFromHeaderFormat(String emailFromHeaderFormat) {
        this.emailFromHeaderFormat = emailFromHeaderFormat;
    }

    public void setIntroduction(String introduction) {
        this.introduction = TextUtils.stringSet((String)TextUtils.noNull((String)introduction).trim()) ? TextUtils.closeTags((String)introduction) : null;
    }

    public boolean isWatching() {
        return this.watching;
    }

    public void setWatching(boolean watching) {
        this.watching = watching;
    }

    public boolean isVoting() {
        return this.voting;
    }

    public void setVoting(boolean voting) {
        this.voting = voting;
    }

    public boolean isAllowUnassigned() {
        return this.allowUnassigned;
    }

    public void setAllowUnassigned(boolean allowUnassigned) {
        this.allowUnassigned = allowUnassigned;
    }

    public boolean isExternalUM() {
        return this.externalUM;
    }

    public void setExternalUM(boolean externalUM) {
        this.externalUM = externalUM;
    }

    public Map<String, String> getAllowedModes() {
        HashMap<String, String> allowedModes = new HashMap<String, String>();
        allowedModes.put("public", this.getText("admin.jira.mode.public"));
        allowedModes.put("private", this.getText("admin.jira.mode.private"));
        return allowedModes;
    }

    public boolean isCacheIssues() {
        return this.cacheIssues;
    }

    public void setCacheIssues(boolean cacheIssues) {
        this.cacheIssues = cacheIssues;
    }

    public Map<String, String> getAllowedLanguages() {
        LinkedHashMap<String, String> allowedLanguages = new LinkedHashMap<String, String>();
        allowedLanguages.put("armenian", this.getText("admin.jira.allowed.language.armenian"));
        allowedLanguages.put("basque", this.getText("admin.jira.allowed.language.basque"));
        allowedLanguages.put("brazilian", this.getText("admin.jira.allowed.language.brazilian"));
        allowedLanguages.put("bulgarian", this.getText("admin.jira.allowed.language.bulgarian"));
        allowedLanguages.put("catalan", this.getText("admin.jira.allowed.language.catalan"));
        allowedLanguages.put("chinese", this.getText("admin.jira.allowed.language.chinese"));
        allowedLanguages.put("cjk", this.getText("admin.jira.allowed.language.cjk"));
        allowedLanguages.put("czech", this.getText("admin.jira.allowed.language.czech"));
        allowedLanguages.put("danish", this.getText("admin.jira.allowed.language.danish"));
        allowedLanguages.put("dutch", this.getText("admin.jira.allowed.language.dutch"));
        allowedLanguages.put("english", this.getText("admin.jira.allowed.language.english"));
        allowedLanguages.put("finnish", this.getText("admin.jira.allowed.language.finnish"));
        allowedLanguages.put("french", this.getText("admin.jira.allowed.language.french"));
        allowedLanguages.put("german", this.getText("admin.jira.allowed.language.german"));
        allowedLanguages.put("greek", this.getText("admin.jira.allowed.language.greek"));
        allowedLanguages.put("hungarian", this.getText("admin.jira.allowed.language.hungarian"));
        allowedLanguages.put("italian", this.getText("admin.jira.allowed.language.italian"));
        allowedLanguages.put("norwegian", this.getText("admin.jira.allowed.language.norwegian"));
        allowedLanguages.put("portuguese", this.getText("admin.jira.allowed.language.portuguese"));
        allowedLanguages.put("romanian", this.getText("admin.jira.allowed.language.romanian"));
        allowedLanguages.put("russian", this.getText("admin.jira.allowed.language.russian"));
        allowedLanguages.put("spanish", this.getText("admin.jira.allowed.language.spanish"));
        allowedLanguages.put("swedish", this.getText("admin.jira.allowed.language.swedish"));
        allowedLanguages.put("thai", this.getText("admin.jira.allowed.language.thai"));
        allowedLanguages.put("other", this.getText("admin.jira.allowed.language.other"));
        return allowedLanguages;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLogoutConfirm() {
        return this.logoutConfirm;
    }

    public void setLogoutConfirm(String logoutConfirm) {
        this.logoutConfirm = logoutConfirm;
    }

    public boolean getCriteriaAutoUpdate() {
        return this.criteriaAutoUpdate;
    }

    public void setCriteriaAutoUpdate(boolean state) {
        this.criteriaAutoUpdate = state;
    }

    public String getEmailVisibility() {
        return this.emailVisibility;
    }

    public void setEmailVisibility(String emailVisibility) {
        this.emailVisibility = emailVisibility;
    }

    public boolean isCanSwitchUnassignedOff() throws GenericEntityException {
        return !this.isHasUnassignedIssues() && this.getProjectsWithDefaultUnassignedCount() == 0;
    }

    public boolean isHasUnassignedIssues() throws GenericEntityException {
        if (this.hasUnassignedIssues == null) {
            this.hasUnassignedIssues = this.issueManager.hasUnassignedIssues();
        }
        return this.hasUnassignedIssues;
    }

    public long getUnassignedIssueCount() throws GenericEntityException {
        if (this.unassignedIssueCount == null) {
            this.unassignedIssueCount = this.issueManager.getUnassignedIssueCount();
        }
        return this.unassignedIssueCount;
    }

    public int getProjectsWithDefaultUnassignedCount() throws GenericEntityException {
        if (this.projectsWithDefaultUnassignedCount == -1) {
            this.projectsWithDefaultUnassignedCount = this.genericDelegator.findByAnd("Project", EasyMap.build((Object)"assigneetype", (Object)new Long(3L))).size();
            this.projectsWithDefaultUnassignedCount += this.genericDelegator.findByAnd("Project", EasyMap.build((Object)"assigneetype", null)).size();
        }
        return this.projectsWithDefaultUnassignedCount;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getConfiguredTimeZoneId() {
        if (this.timeZoneService.useSystemTimeZone()) {
            return "System";
        }
        return this.timeZoneService.getDefaultTimeZoneInfo(this.getJiraServiceContext()).getTimeZoneId();
    }

    public String getConfiguredTimeZoneRegion() {
        return this.timeZoneService.getDefaultTimeZoneRegionKey();
    }

    public TimeZoneService getTimeZoneManager() {
        return this.timeZoneService;
    }

    public void setDefaultTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public List<TimeZoneInfo> getTimeZoneInfos() {
        List timeZoneInfos = this.timeZoneService.getTimeZoneInfos(this.getJiraServiceContext());
        TimeZoneInfo jvmTimeZoneInfo = this.timeZoneService.getJVMTimeZoneInfo(this.getJiraServiceContext());
        TimeZoneInfoImpl timeZoneInfo = new TimeZoneInfoImpl("System", jvmTimeZoneInfo.getDisplayName(), jvmTimeZoneInfo.toTimeZone(), this.getJiraServiceContext().getI18nBean(), "System");
        timeZoneInfos.add(0, timeZoneInfo);
        return timeZoneInfos;
    }

    public List<RegionInfo> getTimeZoneRegions() {
        List regions = this.timeZoneService.getTimeZoneRegions(this.getJiraServiceContext());
        regions.add(0, new RegionInfoImpl("System", this.getText("timezone.region.system")));
        return regions;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public void setUseGzip(boolean useGzip) {
        this.useGzip = useGzip;
    }

    public boolean isAllowRpc() {
        return this.allowRpc;
    }

    public void setAllowRpc(boolean allowRpc) {
        this.allowRpc = allowRpc;
    }

    public boolean isExcludePrecedenceHeader() {
        return this.excludePrecedenceHeader;
    }

    public void setExcludePrecedenceHeader(boolean excludePrecedenceHeader) {
        this.excludePrecedenceHeader = excludePrecedenceHeader;
    }

    public boolean isGroupVisibility() {
        return this.groupVisibility;
    }

    public void setGroupVisibility(boolean groupVisibility) {
        this.groupVisibility = groupVisibility;
    }

    public boolean isProjectRoleVisibility() {
        return this.projectRoleVisibility;
    }

    public void setProjectRoleVisibility(boolean projectRoleVisibility) {
        this.projectRoleVisibility = projectRoleVisibility;
    }

    public boolean isCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(boolean captcha) {
        this.captcha = captcha;
    }

    public boolean isAjaxIssuePicker() {
        return this.ajaxIssuePicker;
    }

    public void setAjaxIssuePicker(boolean ajaxIssuePicker) {
        this.ajaxIssuePicker = ajaxIssuePicker;
    }

    public boolean isJqlAutocompleteDisabled() {
        return this.jqlAutocompleteDisabled;
    }

    public void setJqlAutocompleteDisabled(boolean jqlAutocompleteDisabled) {
        this.jqlAutocompleteDisabled = jqlAutocompleteDisabled;
    }

    @Override
    public String getContactAdministratorsMessage() {
        return this.contactAdministratorsMessage;
    }

    public void setContactAdministratorsMessage(String contactAdministratorsMessage) {
        this.contactAdministratorsMessage = contactAdministratorsMessage;
    }

    public String getContactAdministratorsMessageEditHtml() {
        try {
            JiraRendererModuleDescriptor rendererDescriptor = this.rendererManager.getRendererForType("atlassian-wiki-renderer").getDescriptor();
            Map rendererParams = MapBuilder.newBuilder().add((Object)"rows", (Object)"10").add((Object)"cols", (Object)"60").add((Object)"wrap", (Object)"virtual").add((Object)"class", (Object)"long-field").toMutableMap();
            return rendererDescriptor.getEditVM(this.getContactAdministratorsMessage(), null, "atlassian-wiki-renderer", "contactAdministratorsMessage", "contactAdministratorsMessage", rendererParams, false);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Could not render edit template for Contact Administrators Message", (Throwable)e);
            return "";
        }
    }

    public boolean isShowContactAdministratorsForm() {
        return this.showContactAdministratorsForm;
    }

    public void setShowContactAdministratorsForm(boolean showContactAdministratorsForm) {
        this.showContactAdministratorsForm = showContactAdministratorsForm;
    }

    public String getIeMimeSniffer() {
        return this.ieMimeSniffer;
    }

    public void setIeMimeSniffer(String ieMimeSniffer) {
        this.ieMimeSniffer = ieMimeSniffer;
    }

    public Map<String, String> getValidMimeSnifferOptions() {
        return this.validMimeSnifferOptions;
    }

    public String getMaximumLengthProjectNames() {
        return this.maximumLengthProjectNames;
    }

    public void setMaximumLengthProjectNames(String maximumLengthProjectNames) {
        this.maximumLengthProjectNames = maximumLengthProjectNames == null ? maximumLengthProjectNames : maximumLengthProjectNames.trim();
    }

    public String getMaximumLengthProjectKeys() {
        return this.maximumLengthProjectKeys;
    }

    public void setMaximumLengthProjectKeys(String maximumLengthProjectKeys) {
        this.maximumLengthProjectKeys = maximumLengthProjectKeys == null ? maximumLengthProjectKeys : maximumLengthProjectKeys.trim();
    }

    public String getMaximumAuthenticationAttemptsAllowed() {
        return this.maximumAuthenticationAttemptsAllowed;
    }

    public void setMaximumAuthenticationAttemptsAllowed(String maximumAuthenticationAttemptsAllowed) {
        this.maximumAuthenticationAttemptsAllowed = maximumAuthenticationAttemptsAllowed == null ? maximumAuthenticationAttemptsAllowed : maximumAuthenticationAttemptsAllowed.trim();
    }

    public boolean hasMailServer() {
        return JiraMailUtils.isHasMailServer();
    }

    public boolean isChangeGzipEnabled() {
        return this.getGzipCompression().isSettableBy();
    }

    protected EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }
}

