/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.multipart.PellMultiPartRequest;

public class JiraMultipartRequestWrapper
extends PellMultiPartRequest {
    Map parameterValueCache = new HashMap();
    Map parameterMap = null;

    public JiraMultipartRequestWrapper(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        super(servletRequest, saveDir, maxSize);
    }

    public String getParameter(String name) {
        return this.parseParameterValue(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        return this.retrieveParameterValues(name);
    }

    private String parseParameterValue(String value) {
        String[] retVal = this.retrieveParameterValues(value);
        return retVal != null && retVal.length >= 1 ? retVal[0] : null;
    }

    private String[] retrieveParameterValues(String string) {
        if (string == null) {
            return null;
        }
        String[] returnValue = (String[])this.parameterValueCache.get(string);
        if (returnValue == null) {
            String[] parameterValues = super.getParameterValues(string);
            if (parameterValues == null) {
                return null;
            }
            for (int i = 0; i < parameterValues.length; ++i) {
                parameterValues[i] = StringUtils.escapeCP1252((String)parameterValues[i], (String)this.getJiraEncoding());
            }
            this.parameterValueCache.put(string, parameterValues);
            returnValue = parameterValues;
        }
        return returnValue;
    }

    private String getJiraEncoding() {
        return ComponentAccessor.getApplicationProperties().getEncoding();
    }
}

