/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.Log4jKit;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.log4j.LogManager;

public class JiraLogLocator {
    private static final String AJL_APPENDER_NAME = "filelog";
    public static final String AJL_FILE_NAME = "atlassian-jira.log";
    private final JiraHome home;

    public JiraLogLocator(JiraHome home) {
        this.home = (JiraHome)Assertions.notNull((String)"home", (Object)home);
    }

    public File findJiraLogFile() {
        Collection<File> files = this.findAllJiraLogFiles();
        if (files.isEmpty()) {
            return null;
        }
        return files.iterator().next();
    }

    @NotNull
    public Collection<File> findAllJiraLogFiles() {
        return JiraLogLocator.filterFiles(this.findAllPotentialJiraLogFiles());
    }

    private Collection<File> findAllPotentialJiraLogFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        File logFile = this.findLogViaAppender();
        if (logFile != null) {
            files.add(logFile);
        }
        if ((logFile = this.findLogViaHome()) != null) {
            files.add(logFile);
        }
        files.add(this.findLogViaWorking());
        return files;
    }

    private File findLogViaWorking() {
        return new File(AJL_FILE_NAME).getAbsoluteFile();
    }

    private File findLogViaHome() {
        try {
            return new File(this.home.getLogDirectory(), AJL_FILE_NAME);
        }
        catch (IllegalStateException e) {
            LogManager.getLogger(this.getClass()).debug((Object)"Unable to find log in JIRA home. Returning null.");
            return null;
        }
    }

    private File findLogViaAppender() {
        return Log4jKit.getLogFileName(AJL_APPENDER_NAME);
    }

    private static Collection<File> filterFiles(Collection<File> files) {
        Iterator<File> fileIterator = files.iterator();
        while (fileIterator.hasNext()) {
            File f = fileIterator.next();
            if (f.exists() && f.canRead()) continue;
            fileIterator.remove();
        }
        return files;
    }
}

