/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.OfBizUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

@EventComponent
public class CachingUserHistoryStore
implements UserHistoryStore,
Startable {
    private static final int DEFAULT_MAX_THRESHOLD = 10;
    static final int DEFAULT_MAX_ITEMS = 20;
    private static final Logger log = Logger.getLogger(CachingUserHistoryStore.class);
    private final Cache<Key, List<UserHistoryItem>> cache = CacheBuilder.newBuilder().maximumSize(2000).build((CacheLoader)new DelegatingStoreCacheLoader());
    private final Function<ApplicationUser, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory((Function)new Function<ApplicationUser, String>(){

        public String get(ApplicationUser input) {
            return input.getKey();
        }
    });
    private final OfBizUserHistoryStore delegatingStore;
    private final ApplicationProperties applicationProperties;
    private final int maxThreshold;

    public CachingUserHistoryStore(@NotNull OfBizUserHistoryStore delegatingStore, @NotNull ApplicationProperties applicationProperties) {
        this(delegatingStore, applicationProperties, 10);
    }

    CachingUserHistoryStore(@NotNull OfBizUserHistoryStore delegatingStore, @NotNull ApplicationProperties applicationProperties, int maxThreshold) {
        this.delegatingStore = (OfBizUserHistoryStore)Assertions.notNull((String)"delegatingStore", (Object)delegatingStore);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.maxThreshold = maxThreshold;
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(this.getClass().getSimpleName()).addCache(this.cache).install();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.invalidateAll();
    }

    @Override
    public void addHistoryItem(final @NotNull ApplicationUser user, final @NotNull UserHistoryItem historyItem) {
        block7: {
            Assertions.notNull((String)"user", (Object)user);
            Assertions.notNull((String)"historyItem", (Object)historyItem);
            AddHistoryResult result = (AddHistoryResult)((ManagedLock)this.lockManager.get((Object)user)).withLock((Supplier)new Supplier<AddHistoryResult>(){

                public AddHistoryResult get() {
                    return CachingUserHistoryStore.this.addCachedHistoryItem(user, historyItem);
                }
            });
            try {
                if (result.create) {
                    try {
                        this.delegatingStore.addHistoryItemNoChecks(user, historyItem);
                        if (result.toDelete != null) {
                            this.delegatingStore.expireOldHistoryItems(user, historyItem.getType(), result.toDelete);
                        }
                        break block7;
                    }
                    catch (DataAccessException e) {
                        if (this.delegatingStore.removeHistoryItem(user, historyItem)) {
                            this.delegatingStore.addHistoryItemNoChecks(user, historyItem);
                            break block7;
                        }
                        throw e;
                    }
                }
                this.delegatingStore.updateHistoryItemNoChecks(user, historyItem);
            }
            catch (DataAccessException e) {
                this.lockAndflushCache(historyItem.getType(), user);
                log.debug((Object)"Unable to add user history to store. Ignoring error.", (Throwable)e);
            }
        }
    }

    @GuardedBy(value="lockManager.get(user)")
    AddHistoryResult addCachedHistoryItem(@NotNull ApplicationUser user, @NotNull UserHistoryItem historyItem) {
        UserHistoryItem.Type type = historyItem.getType();
        List history = (List)this.cache.getUnchecked((Object)new Key(user, type));
        if (this.removeCachedHistoryItem(history, historyItem)) {
            history.add(0, historyItem);
            return AddHistoryResult.SIMPLE_UPDATE;
        }
        history.add(0, historyItem);
        int maxItems = CachingUserHistoryStore.getMaxItems(historyItem.getType(), this.applicationProperties);
        if (history.size() <= maxItems + this.maxThreshold) {
            return AddHistoryResult.SIMPLE_CREATE;
        }
        ArrayList<String> entitiesToDelete = new ArrayList<String>();
        while (history.size() > maxItems) {
            UserHistoryItem item = (UserHistoryItem)history.remove(maxItems);
            entitiesToDelete.add(item.getEntityId());
        }
        return new AddHistoryResult(entitiesToDelete);
    }

    @GuardedBy(value="lockManager.get(user)")
    private boolean removeCachedHistoryItem(@NotNull List<UserHistoryItem> history, @NotNull UserHistoryItem historyItem) {
        for (int i = 0; i < history.size(); ++i) {
            UserHistoryItem currentHistoryItem = history.get(i);
            if (!currentHistoryItem.getEntityId().equals(historyItem.getEntityId())) continue;
            history.remove(i);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<UserHistoryItem> getHistory(final @NotNull UserHistoryItem.Type type, final @NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"type", (Object)type);
        try {
            return (List)((ManagedLock)this.lockManager.get((Object)user)).withLock((Supplier)new Supplier<List<UserHistoryItem>>(){

                public List<UserHistoryItem> get() {
                    return ImmutableList.copyOf((Collection)((Collection)CachingUserHistoryStore.this.cache.getUnchecked((Object)new Key(user, type))));
                }
            });
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof DataAccessException) {
                log.debug((Object)"Unable to get user history items. Returning empty list.", (Throwable)e);
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(final @NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        final Set<UserHistoryItem.Type> typesRemoved = this.delegatingStore.removeHistoryForUser(user);
        ((ManagedLock)this.lockManager.get((Object)user)).withLock(new Runnable(){

            @Override
            public void run() {
                for (UserHistoryItem.Type type : typesRemoved) {
                    CachingUserHistoryStore.this.flushCache(type, user);
                }
            }
        });
        return typesRemoved;
    }

    private void lockAndflushCache(final UserHistoryItem.Type type, final ApplicationUser user) {
        ((ManagedLock)this.lockManager.get((Object)user)).withLock(new Runnable(){

            @Override
            public void run() {
                CachingUserHistoryStore.this.flushCache(type, user);
            }
        });
    }

    private void flushCache(UserHistoryItem.Type type, ApplicationUser user) {
        this.cache.invalidate((Object)new Key(user, type));
    }

    public static int getMaxItems(UserHistoryItem.Type type, ApplicationProperties applicationProperties) {
        String maxItemsForTypeStr = applicationProperties.getDefaultBackedString("jira.max." + type.getName() + ".history.items");
        int maxItems = 20;
        try {
            if (StringUtils.isNotBlank((String)maxItemsForTypeStr)) {
                return Integer.parseInt(maxItemsForTypeStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Incorrect format of property 'jira.max." + type.getName() + ".history.items'.  Should be a number."));
        }
        String maxItemsStr = applicationProperties.getDefaultBackedString("jira.max.history.items");
        try {
            if (StringUtils.isNotBlank((String)maxItemsStr)) {
                return Integer.parseInt(maxItemsStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.items'.  Should be a number.");
        }
        return 20;
    }

    static class AddHistoryResult {
        static final AddHistoryResult SIMPLE_CREATE = new AddHistoryResult(true, null);
        static final AddHistoryResult SIMPLE_UPDATE = new AddHistoryResult(false, null);
        final boolean create;
        final List<String> toDelete;

        AddHistoryResult(List<String> toDelete) {
            this(true, toDelete);
        }

        private AddHistoryResult(boolean create, List<String> toDelete) {
            this.create = create;
            this.toDelete = toDelete;
        }
    }

    private static final class Key {
        private final ApplicationUser user;
        private final UserHistoryItem.Type type;

        public Key(ApplicationUser user, UserHistoryItem.Type type) {
            Assertions.notNull((String)"user", (Object)user);
            Assertions.notNull((String)"type", (Object)type);
            this.user = user;
            this.type = type;
        }

        public String getUserKey() {
            return this.user.getKey();
        }

        public UserHistoryItem.Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals((Object)key.type)) {
                return false;
            }
            return this.getUserKey().equals(key.getUserKey());
        }

        public int hashCode() {
            int result = this.getUserKey().hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    final class DelegatingStoreCacheLoader
    extends CacheLoader<Key, List<UserHistoryItem>> {
        DelegatingStoreCacheLoader() {
        }

        public List<UserHistoryItem> load(Key key) {
            List<UserHistoryItem> history = CachingUserHistoryStore.this.delegatingStore.getHistory(key.type, key.user);
            if (history != null) {
                return new ArrayList<UserHistoryItem>(history);
            }
            return new ArrayList<UserHistoryItem>();
        }
    }
}

