/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserClauseXmlHandler
implements ClauseXmlHandler {
    public static final String GROUP_SUFFIX = "_group";
    private static final Logger log = Logger.getLogger(UserClauseXmlHandler.class);
    private final UserFieldSearchConstantsWithEmpty searchConstants;

    public UserClauseXmlHandler(UserFieldSearchConstantsWithEmpty searchConstants) {
        this.searchConstants = searchConstants;
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String value;
        String originalXmlFieldId = el.getName();
        boolean forGroup = originalXmlFieldId.endsWith(GROUP_SUFFIX);
        String xmlFieldId = forGroup ? originalXmlFieldId.substring(0, originalXmlFieldId.indexOf(GROUP_SUFFIX)) : originalXmlFieldId;
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(originalXmlFieldId);
        }
        String string = value = forGroup ? el.getAttribute("groupName") : el.getAttributeValue("value");
        if (StringUtils.isBlank((String)value)) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(originalXmlFieldId);
        }
        TerminalClauseImpl clause = forGroup ? new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{value})) : (this.searchConstants.getEmptySelectFlag().equals(value) ? new TerminalClauseImpl(clauseName, Operator.IS, (Operand)new EmptyOperand()) : (this.searchConstants.getCurrentUserSelectFlag().equals(value) ? new TerminalClauseImpl(clauseName, Operator.EQUALS, (Operand)new FunctionOperand("currentUser")) : new TerminalClauseImpl(clauseName, Operator.EQUALS, value)));
        if (clauseName.equals(this.searchConstants.getJqlClauseNames().getPrimaryName())) {
            return new ClauseXmlHandler.FullConversionResult((Clause)clause);
        }
        return new ClauseXmlHandler.BestGuessConversionResult((Clause)clause, originalXmlFieldId, clauseName);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }
}

