/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.opensymphony.util.TextUtils;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractSimpleClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(AbstractSimpleClauseXmlHandler.class);
    private static final String VALUE = "value";
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;

    protected AbstractSimpleClauseXmlHandler(FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String xmlFieldId = el.getName();
        return this.convertXmlToClause(el, xmlFieldId);
    }

    protected ClauseXmlHandler.ConversionResult convertXmlToClause(Element el, String xmlFieldId) {
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        List<String> values = this.getValuesFromElement(el, xmlFieldId);
        if (values.isEmpty()) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and could not interpret the values contained in the XML."));
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        Clause clause = this.getClauseForValues(clauseName, values);
        if (!this.xmlFieldIdSupported(xmlFieldId)) {
            return new ClauseXmlHandler.BestGuessConversionResult(clause, xmlFieldId, clauseName);
        }
        return new ClauseXmlHandler.FullConversionResult(clause);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }

    protected abstract boolean xmlFieldIdSupported(String var1);

    Clause getClauseForValues(String jqlName, List<String> values) {
        Operator operator;
        Operand operand;
        if (values.size() == 1) {
            operand = this.getOperandForValue(jqlName, values.get(0));
            operator = operand instanceof FunctionOperand ? Operator.IN : Operator.EQUALS;
        } else {
            operator = Operator.IN;
            ArrayList<Operand> operands = new ArrayList<Operand>();
            for (String stringValue : values) {
                operands.add(this.getOperandForValue(jqlName, stringValue));
            }
            operand = new MultiValueOperand(operands);
        }
        return JqlQueryBuilder.newClauseBuilder().addCondition(jqlName, operator, operand).buildClause();
    }

    Operand getOperandForValue(String jqlName, String value) {
        Operand operandForFlag = this.fieldFlagOperandRegistry.getOperandForFlag(jqlName, value);
        if (operandForFlag != null) {
            return operandForFlag;
        }
        Long longValue = this.getValueAsLong(value);
        if (longValue == null) {
            return new SingleValueOperand(value);
        }
        return new SingleValueOperand(longValue);
    }

    List<String> getValuesFromElement(Element el, String constantName) {
        ArrayList<String> values = new ArrayList<String>();
        Elements valueEls = el.getElements(VALUE);
        while (valueEls.hasMoreElements()) {
            Element valueEl = valueEls.next();
            if (TextUtils.stringSet((String)valueEl.getTextString())) {
                values.add(valueEl.getTextString());
                continue;
            }
            log.warn((Object)("A saved filter parameter for " + constantName + " contains a value tag with no value."));
        }
        return values;
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

