/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public class UpgradeTask_Build812
extends AbstractUpgradeTask {
    public UpgradeTask_Build812() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "812";
    }

    @Override
    public String getShortDescription() {
        return "Shorten name of index on ManagedConfigurationItem entity";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Connection connection = this.getDatabaseConnection();
        String schemaName = this.getSchemaName();
        String tableName = "managedconfigurationitem";
        String index = "managedconfigurationitem_id_type_index";
        try {
            connection.setAutoCommit(false);
            String sql = this.buildDropIndexSql(connection, schemaName, "managedconfigurationitem", "managedconfigurationitem_id_type_index");
            Statement update = connection.createStatement();
            update.execute(sql);
            connection.commit();
        }
        catch (Exception ignore) {
        }
        finally {
            connection.close();
        }
    }

    @Override
    protected Connection getDatabaseConnection() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            DatabaseUtil utils = new DatabaseUtil(helper.getHelperName());
            return utils.getConnection();
        }
        catch (SQLException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
    }

    private boolean isDatabaseTypeForFieldType(Connection connection, String fieldType) {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith(fieldType);
    }

    private boolean isMSSQL(Connection connection) throws SQLException {
        return this.isDatabaseTypeForFieldType(connection, "mssql");
    }

    private boolean isMYSQL(Connection connection) throws SQLException {
        return this.isDatabaseTypeForFieldType(connection, "mysql");
    }

    private String buildDropIndexSql(Connection connection, String schemaName, String tableName, String index) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DROP INDEX ");
        sqlBuilder.append(index);
        if (this.isMYSQL(connection) || this.isMSSQL(connection)) {
            sqlBuilder.append(" ON ");
            if (StringUtils.isNotBlank((String)schemaName)) {
                sqlBuilder.append(schemaName);
                sqlBuilder.append(".");
            }
            sqlBuilder.append(tableName);
        }
        return sqlBuilder.toString();
    }
}

