/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build207;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractNotificationSchemeUpgradeTask
extends AbstractUpgradeTask {
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build207.class);
    private final NotificationSchemeManager notificationSchemeManager;

    public AbstractNotificationSchemeUpgradeTask(NotificationSchemeManager notificationSchemeManager) {
        super(false);
        this.notificationSchemeManager = notificationSchemeManager;
    }

    public void doUpgrade(Long eventIdSource, Long eventIdDestination) throws GenericEntityException {
        try {
            List schemes = this.notificationSchemeManager.getSchemes();
            for (GenericValue schemeGV : schemes) {
                List entities = this.notificationSchemeManager.getEntities(schemeGV, eventIdSource);
                for (GenericValue schemeEntity : entities) {
                    this.addSchemeEntityForDestinationNotification(schemeGV, schemeEntity, eventIdDestination);
                }
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Unable to retrieve all notification schemes.", (Throwable)e);
            throw e;
        }
    }

    private void addSchemeEntityForDestinationNotification(GenericValue schemeGV, GenericValue origSchemeEntity, Long eventIdDestination) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to add notification for event id: '" + eventIdDestination + "' for '" + origSchemeEntity.getString("type") + "' to notification scheme '" + schemeGV.getString("name") + "'"));
        }
        SchemeEntity schemeEntity = new SchemeEntity(origSchemeEntity.getString("type"), origSchemeEntity.getString("parameter"), (Object)eventIdDestination, (Object)origSchemeEntity.getString("templateId"));
        try {
            this.notificationSchemeManager.createSchemeEntity(schemeGV, schemeEntity);
        }
        catch (GenericEntityException e) {
            LOG.error((Object)("Failed to add notification for event id: '" + eventIdDestination + "' for '" + schemeEntity + "' to notification scheme '" + schemeGV.getString("name") + "'!"));
        }
    }
}

