/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.upgrade.ConnectionKeeper;
import com.atlassian.util.concurrent.LazyReference;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class DatabaseLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(DatabaseLauncher.class);
    private static final String HSQLDB = "hsql";
    private static final int CK_CONNECTIONS = 1;
    private static final int CK_SLEEPTIME = 300000;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String TRANSACTION_ISOLATION_PROPERTY = "jira.transaction.isolation";
    private static final String TRANSACTION_DISABLE_PROPERTY = "jira.transaction.disable";
    private volatile ConnectionKeeper connectionKeeper;
    private final LazyReference<DatabaseConfigurationManager> configManagerRef = new LazyReference<DatabaseConfigurationManager>(){

        protected DatabaseConfigurationManager create() throws Exception {
            return (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        }
    };

    @Override
    public void start() {
        DatabaseConfig databaseConfig = ((DatabaseConfigurationManager)this.configManagerRef.get()).getDatabaseConfiguration();
        if (databaseConfig == null) {
            log.fatal((Object)"No database config found");
            return;
        }
        DatasourceInfo datasourceInfo = databaseConfig.getDatasourceInfo();
        if (datasourceInfo == null) {
            log.fatal((Object)"No datasource info found");
            return;
        }
        this.setupHsqlHacks(datasourceInfo);
        this.initDatabaseTransactions(datasourceInfo);
        new JiraStartupLogger().printStartingMessageDatabaseOK();
    }

    @Override
    public void stop() {
        this.shutdownHsqlHacks();
        DatabaseConfig config = ((DatabaseConfigurationManager)this.configManagerRef.get()).getDatabaseConfiguration();
        if (config != null) {
            String name = config.getDatasourceName();
            EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();
            if (entityConfigUtil.getDelegatorInfo(name) != null) {
                entityConfigUtil.removeDelegator(name);
            }
            if (entityConfigUtil.getDatasourceInfo(name) != null) {
                entityConfigUtil.removeDatasource(name);
            }
        }
    }

    private void setupHsqlHacks(DatasourceInfo datasourceInfo) {
        if (datasourceInfo != null) {
            if (HSQLDB.equals(datasourceInfo.getFieldTypeName())) {
                String message1 = "hsqldb is an in-memory database, and susceptible to corruption when abnormally terminated.";
                String message2 = "DO NOT USE IN PRODUCTION, please switch to a regular database.";
                String line = StringUtils.repeat((String)"*", (int)"hsqldb is an in-memory database, and susceptible to corruption when abnormally terminated.".length());
                log.warn((Object)(NEW_LINE + NEW_LINE + line + NEW_LINE + "hsqldb is an in-memory database, and susceptible to corruption when abnormally terminated." + NEW_LINE + "DO NOT USE IN PRODUCTION, please switch to a regular database." + NEW_LINE + line + NEW_LINE));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will open 1 connections to keep the database alive.");
                    log.debug((Object)("Starting ConnectionKeeper with datasource name '" + datasourceInfo.getName() + "', connections to open '" + 1 + "' and sleep time '" + 300000 + "' milliseconds."));
                }
                this.connectionKeeper = new ConnectionKeeper(datasourceInfo.getName(), 1, 300000);
                this.connectionKeeper.start();
            }
        } else {
            log.info((Object)"Cannot get datasource information from server. Probably using JBoss. Please ensure that you are not using hsql also.");
        }
    }

    private void shutdownHsqlHacks() {
        if (this.connectionKeeper != null) {
            this.connectionKeeper.shutdown();
        }
    }

    private void initDatabaseTransactions(DatasourceInfo datasourceInfo) {
        boolean startTransaction = true;
        Integer isolationLevel = null;
        if (datasourceInfo != null) {
            if (HSQLDB.equals(datasourceInfo.getFieldTypeName())) {
                log.info((Object)"Setting isolation level to '1' as this is the only isolation level 'hsql' supports.");
                isolationLevel = 1;
            }
        } else {
            log.info((Object)"Cannot get datasource information from server. Probably using JBoss. If using HSQLDB please set 'jira.transaction.isolation' to '1'. Other databases should not need this property.");
        }
        try {
            String isolationProperty;
            if (Boolean.getBoolean(TRANSACTION_DISABLE_PROPERTY)) {
                log.info((Object)"System property + 'jira.transaction.disable' set to true.");
                startTransaction = false;
            }
            if ((isolationProperty = System.getProperty(TRANSACTION_ISOLATION_PROPERTY)) != null) {
                try {
                    log.info((Object)("System property + 'jira.transaction.isolation' set to '" + isolationProperty + "'. Overriding default."));
                    isolationLevel = Integer.valueOf(isolationProperty);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("The 'jira.transaction.isolation' is set to a non-numeric value '" + isolationProperty + "'."));
                }
            }
        }
        catch (SecurityException e) {
            log.warn((Object)"There was a security problem trying to read transaction configuration system properties. This usually occurs if you are running JIRA with a security manager. As these system properties are not required to be set (unless you are trying to solve another problem) JIRA should function properly.", (Throwable)e);
        }
        log.info((Object)("Database transactions enabled: " + startTransaction));
        CoreTransactionUtil.setUseTransactions(startTransaction);
        if (isolationLevel != null) {
            log.info((Object)("Database transaction isolation level: " + isolationLevel));
            CoreTransactionUtil.setIsolationLevel(isolationLevel);
        } else {
            log.info((Object)("Using JIRA's default for database transaction isolation level: " + CoreTransactionUtil.getIsolationLevel()));
        }
    }
}

