/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GroupSharePermission;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GroupShareQueryFactory
implements ShareQueryFactory<GroupShareTypeSearchParameter> {
    private final GroupManager groupManager;

    public GroupShareQueryFactory(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter, User user) {
        return this.getQuery(searchParameter);
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter) {
        return new TermQuery(new Term("shareTypeGroup", ((GroupShareTypeSearchParameter)searchParameter).getGroupName()));
    }

    public Term[] getTerms(User user) {
        if (user == null) {
            return new Term[0];
        }
        Collection groups = this.groupManager.getGroupNamesForUser(user.getName());
        ArrayList<Term> result = new ArrayList<Term>();
        for (String element : groups) {
            result.add(new Term("shareTypeGroup", element));
        }
        return result.toArray(new Term[result.size()]);
    }

    public Field getField(SharedEntity entity, SharePermission permission) {
        return new Field("shareTypeGroup", new GroupSharePermission(permission).getGroupName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private static final class Name {
        static final String FIELD = "shareTypeGroup";

        private Name() {
        }
    }
}

